/*
 * Decompiled with CFR 0.152.
 */
package filius.software.vermittlungsschicht;

import filius.software.ProtokollThread;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.vermittlungsschicht.IP;
import filius.software.vermittlungsschicht.IpPaket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPThread
extends ProtokollThread<IpPaket> {
    private static Logger LOG = LoggerFactory.getLogger(IPThread.class);
    private IP vermittlung;

    public IPThread(IP vermittlung) {
        super(((InternetKnotenBetriebssystem)vermittlung.holeSystemSoftware()).holeEthernet().holeIPPuffer());
        LOG.trace("INVOKED-2 (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (IPThread), constr: IPThread(" + vermittlung + ")");
        this.vermittlung = vermittlung;
    }

    @Override
    protected void verarbeiteDatenEinheit(IpPaket datenEinheit) {
        IpPaket ipPaket = datenEinheit.clone();
        if (this.vermittlung.isLocalAddress(ipPaket.getEmpfaenger()) || ipPaket.getEmpfaenger().equals("255.255.255.255")) {
            this.vermittlung.benachrichtigeTransportschicht(ipPaket);
        } else if (this.vermittlung.isIPForwardingEnabled()) {
            this.vermittlung.weiterleitenPaket(ipPaket);
        }
    }
}

