/*
 * Decompiled with CFR 0.152.
 */
package filius.software.vermittlungsschicht;

import filius.hardware.Verbindung;
import filius.software.ProtokollThread;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.vermittlungsschicht.ICMP;
import filius.software.vermittlungsschicht.IcmpPaket;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ICMPThread
extends ProtokollThread<IcmpPaket> {
    private static Logger LOG = LoggerFactory.getLogger(ICMPThread.class);
    private ICMP vermittlung;
    private LinkedList<IcmpPaket> rcvdPackets;

    public ICMPThread(ICMP vermittlung) {
        super(((InternetKnotenBetriebssystem)vermittlung.holeSystemSoftware()).holeEthernet().holeICMPPuffer());
        LOG.trace("INVOKED-2 (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (ICMPThread), constr: ICMPThread(" + vermittlung + ")");
        this.rcvdPackets = new LinkedList();
        this.vermittlung = vermittlung;
    }

    @Override
    protected void verarbeiteDatenEinheit(IcmpPaket icmpPaket) {
        if (this.vermittlung.isLocalAddress(icmpPaket.getEmpfaenger()) || this.vermittlung.isApplicableBroadcast(icmpPaket.getEmpfaenger())) {
            if (icmpPaket.isEchoRequest()) {
                this.vermittlung.sendEchoReply(icmpPaket);
            } else {
                this.addIcmpResponse(icmpPaket);
            }
        } else {
            this.vermittlung.weiterleitenPaket(icmpPaket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIcmpResponse(IcmpPaket icmpPaket) {
        LinkedList<IcmpPaket> linkedList = this.rcvdPackets;
        synchronized (linkedList) {
            this.rcvdPackets.add(icmpPaket);
            this.rcvdPackets.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetIcmpResponseQueue() {
        LinkedList<IcmpPaket> linkedList = this.rcvdPackets;
        synchronized (linkedList) {
            this.rcvdPackets.clear();
            this.rcvdPackets.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IcmpPaket waitForIcmpResponse() {
        IcmpPaket response = null;
        LinkedList<IcmpPaket> linkedList = this.rcvdPackets;
        synchronized (linkedList) {
            try {
                this.rcvdPackets.wait(Verbindung.holeRTT());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.rcvdPackets.size() > 0) {
                response = this.rcvdPackets.removeFirst();
            }
        }
        return response;
    }
}

