/*
 * Decompiled with CFR 0.152.
 */
package filius.software.transportschicht;

import filius.exception.SocketException;
import filius.exception.VerbindungsException;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.transportschicht.Socket;
import filius.software.transportschicht.UdpSegment;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDPSocket
extends Socket {
    private static Logger LOG = LoggerFactory.getLogger(UDPSocket.class);
    private LinkedList<UdpSegment> puffer = new LinkedList();
    private boolean verbunden;
    private boolean stopListening;

    public UDPSocket(InternetKnotenBetriebssystem betriebssystem, String zielAdresse, int zielPort) throws VerbindungsException {
        super(betriebssystem, zielAdresse, zielPort, 17);
        LOG.trace("INVOKED-2 (" + this.hashCode() + ") " + this.getClass() + " (UDPSocket), constr: UDPSocket(" + betriebssystem + "," + zielAdresse + "," + zielPort + ")");
    }

    public UDPSocket(InternetKnotenBetriebssystem betriebssystem, String zielAdresse, int zielPort, int lokalerPort) throws VerbindungsException {
        super(betriebssystem, zielAdresse, zielPort, 17, lokalerPort);
        LOG.trace("INVOKED-2 (" + this.hashCode() + ") " + this.getClass() + " (UDPSocket), constr: UDPSocket(" + betriebssystem + "," + zielAdresse + "," + zielPort + "," + lokalerPort + ")");
    }

    public UDPSocket(InternetKnotenBetriebssystem betriebssystem, int lokalerPort) throws VerbindungsException {
        super(betriebssystem, lokalerPort, 17);
        LOG.trace("INVOKED-2 (" + this.hashCode() + ") " + this.getClass() + " (UDPSocket), constr: UDPSocket(" + betriebssystem + "," + lokalerPort + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hinzufuegen(String startIp, int startPort, Object segment) {
        LOG.trace("UDP data received from " + startIp + ":" + startPort + ", data: " + segment);
        this.zielIp = startIp;
        this.zielPort = startPort;
        LinkedList<UdpSegment> linkedList = this.puffer;
        synchronized (linkedList) {
            this.puffer.add((UdpSegment)segment);
            this.puffer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String empfangen(long millis) {
        LOG.trace("UDP receive on port " + this.lokalerPort + " (timeout: " + millis + ")");
        LinkedList<UdpSegment> linkedList = this.puffer;
        synchronized (linkedList) {
            if (this.puffer.size() < 1) {
                try {
                    this.puffer.wait(millis);
                }
                catch (InterruptedException e) {
                    LOG.debug("UDP socket interrupted");
                }
            }
            if (this.puffer.size() >= 1) {
                UdpSegment segment = this.puffer.removeFirst();
                return segment.getDaten();
            }
            LOG.debug("no UDP data received (local port {})", (Object)this.lokalerPort);
            return null;
        }
    }

    @Override
    public synchronized String empfangen() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (UDPSocket), empfangen()");
        return this.empfangen(0L);
    }

    @Override
    public synchronized void senden(String nachricht) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (UDPSocket), senden(" + nachricht + ")");
        UdpSegment segment = new UdpSegment();
        segment.setDaten(nachricht);
        segment.setQuellPort(this.lokalerPort);
        segment.setZielPort(this.zielPort);
        super.sende(segment);
    }

    public synchronized void sendeBroadcast(String nachricht) {
        this.sendeBroadcast(null, nachricht);
    }

    public synchronized void sendeBroadcast(String quellIp, String nachricht) {
        LOG.debug("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (UDPSocket), sendeBroadcast(" + nachricht + ")");
        UdpSegment segment = new UdpSegment();
        segment.setDaten(nachricht);
        segment.setQuellPort(this.lokalerPort);
        segment.setZielPort(this.zielPort);
        this.protokoll.senden("255.255.255.255", quellIp, segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schliessen() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (UDPSocket), schliessen()");
        this.stopListening = true;
        LinkedList<UdpSegment> linkedList = this.puffer;
        synchronized (linkedList) {
            this.puffer.notifyAll();
        }
        if (this.verbunden) {
            this.austragenPort();
            this.verbunden = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beenden() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (UDPSocket), beenden()");
        this.stopListening = true;
        LinkedList<UdpSegment> linkedList = this.puffer;
        synchronized (linkedList) {
            this.puffer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verbinden() {
        LOG.debug("[port={}] start listening UDP", (Object)this.lokalerPort);
        if (!this.verbunden) {
            if (this.modus == 2) {
                LinkedList<UdpSegment> linkedList = this.puffer;
                synchronized (linkedList) {
                    while (this.puffer.size() <= 0 && !this.stopListening) {
                        try {
                            this.puffer.wait(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            if (!this.stopListening) {
                try {
                    this.eintragenPort();
                    this.verbunden = true;
                }
                catch (SocketException e) {
                    LOG.debug("EXCEPTION (" + this.hashCode() + "): verbinden() NICHT erfolgreich", e);
                }
            }
        }
        LOG.debug("[port={}] stop listening UDP", (Object)this.lokalerPort);
    }

    @Override
    public boolean istVerbunden() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (UDPSocket), istVerbunden()");
        return this.verbunden;
    }

    @Override
    public String getStateAsString() {
        if (this.istVerbunden()) {
            return "CONNECTED";
        }
        return "DISCONNECTED";
    }
}

