/*
 * Decompiled with CFR 0.152.
 */
package filius.software.transportschicht;

import filius.exception.SocketException;
import filius.rahmenprogramm.I18n;
import filius.software.Protokoll;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.transportschicht.Segment;
import filius.software.transportschicht.Socket;
import filius.software.transportschicht.SocketSchnittstelle;
import filius.software.transportschicht.TransportProtokollThread;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransportProtokoll
extends Protokoll
implements I18n,
Runnable {
    private static Logger LOG = LoggerFactory.getLogger(TransportProtokoll.class);
    private static final int PORT_UNTERE_GRENZE = 1024;
    private static final int PORT_OBERE_GRENZE = 65535;
    protected static final int TTL = 64;
    private int typ;
    private LinkedList<Object[]> segmentListe = new LinkedList();
    private Map<Integer, SocketSchnittstelle> portTabelle = new HashMap<Integer, SocketSchnittstelle>();
    private TransportProtokollThread thread;
    private Thread sendeThread = null;
    private boolean running = false;

    public TransportProtokoll(InternetKnotenBetriebssystem betriebssystem, int typ) {
        super(betriebssystem);
        LOG.trace("INVOKED-2 (" + this.hashCode() + ") " + this.getClass() + " (TransportProtokoll), constr: TransportProtokoll(" + betriebssystem + "," + typ + ")");
        this.typ = typ;
    }

    public List<SocketSchnittstelle> holeAktiveSockets() {
        ArrayList<SocketSchnittstelle> sockets = new ArrayList<SocketSchnittstelle>();
        for (SocketSchnittstelle socket : this.portTabelle.values()) {
            if (null == socket) continue;
            sockets.add(socket);
        }
        return sockets;
    }

    public int holeTyp() {
        return this.typ;
    }

    public int reserviereFreienPort() {
        return this.reserviereFreienPort(null);
    }

    public int reserviereFreienPort(Socket socket) {
        int freienPort;
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TransportProtokoll), reserviereFreienPort(" + socket + ")");
        boolean portGefunden = false;
        do {
            if (this.portTabelle.containsKey(freienPort = this.sucheFreienPort())) continue;
            portGefunden = true;
        } while (!portGefunden);
        this.reservierePort(freienPort, socket);
        return freienPort;
    }

    public SocketSchnittstelle holeSocket(int port) throws SocketException {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TransportProtokoll), holeSocket(" + port + ")");
        if (port == -1) {
            throw new SocketException(messages.getString("sw_transportprotokoll_msg3"));
        }
        if (!this.portTabelle.containsKey(port)) {
            throw new SocketException(messages.getString("sw_transportprotokoll_msg1") + " " + port + " " + messages.getString("sw_transportprotokoll_msg2"));
        }
        return this.portTabelle.get(port);
    }

    public boolean isUsed(int port) {
        return this.portTabelle.containsKey(port);
    }

    private int sucheFreienPort() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TransportProtokoll), sucheFreienPort()");
        int spanne = 64511;
        Random random = new Random();
        int zufallsZahl = Math.abs(random.nextInt());
        int zahl = zufallsZahl % spanne;
        return 1024 + zahl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reservierePort(int port, SocketSchnittstelle socket) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TransportProtokoll), reservierePort(" + port + "," + socket + ")");
        boolean portIsSubscribed = false;
        Map<Integer, SocketSchnittstelle> map = this.portTabelle;
        synchronized (map) {
            if (this.portTabelle.containsKey(port) && !this.portTabelle.get(port).equals(socket)) {
                LOG.debug("Port " + port + " cannot be subscribed for. It is already in use.");
            } else if (this.portTabelle.containsKey(port) && this.portTabelle.get(port).equals(socket)) {
                LOG.debug("Port {} already subscribed for the socket. Nothing to do.", (Object)port);
                portIsSubscribed = true;
            } else {
                LOG.debug("Port {} is subscribed for.", (Object)port);
                this.portTabelle.put(port, socket);
                portIsSubscribed = true;
            }
        }
        return portIsSubscribed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean gibPortFrei(int port) {
        LOG.debug("remove port {} from list of registered ports.", (Object)port);
        Map<Integer, SocketSchnittstelle> map = this.portTabelle;
        synchronized (map) {
            if (this.portTabelle.containsKey(port)) {
                this.portTabelle.remove(port);
                return true;
            }
            return false;
        }
    }

    protected void senden(String zielIp, Object segment) {
        this.senden(zielIp, null, segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void senden(String zielIp, String quellIp, Object segment) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TransportProtokoll), senden(" + zielIp + "," + segment + ")");
        LinkedList<Object[]> linkedList = this.segmentListe;
        synchronized (linkedList) {
            this.segmentListe.addLast(new Object[]{zielIp, quellIp, segment});
            this.segmentListe.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TransportProtokoll), run()");
        while (this.running) {
            LinkedList<Object[]> linkedList = this.segmentListe;
            synchronized (linkedList) {
                if (this.segmentListe.size() < 1) {
                    try {
                        this.segmentListe.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.segmentListe.size() > 0) {
                    Object[] temp = this.segmentListe.removeFirst();
                    InternetKnotenBetriebssystem bs = (InternetKnotenBetriebssystem)this.holeSystemSoftware();
                    bs.holeIP().senden((String)temp[0], (String)temp[1], this.holeTyp(), 64, (Segment)temp[2]);
                }
            }
        }
    }

    @Override
    public void starten() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TransportProtokoll), starten()");
        this.thread = new TransportProtokollThread(this);
        this.thread.starten();
        if (!this.running) {
            this.running = true;
            if (this.sendeThread == null || !this.sendeThread.getState().equals((Object)Thread.State.WAITING) && !this.sendeThread.getState().equals((Object)Thread.State.BLOCKED)) {
                this.sendeThread = new Thread(this);
                this.sendeThread.start();
            }
        }
    }

    @Override
    public void beenden() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TransportProtokoll), beenden()");
        this.thread.beenden();
        this.running = false;
        if (this.sendeThread != null && (this.sendeThread.getState().equals((Object)Thread.State.WAITING) || this.sendeThread.getState().equals((Object)Thread.State.BLOCKED))) {
            this.sendeThread.interrupt();
        }
        this.portTabelle.clear();
    }
}

