/*
 * Decompiled with CFR 0.152.
 */
package filius.software.transportschicht;

import filius.exception.SocketException;
import filius.exception.TimeOutException;
import filius.exception.VerbindungsException;
import filius.hardware.Verbindung;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.transportschicht.Socket;
import filius.software.transportschicht.TcpSegment;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPSocket
extends Socket
implements Runnable {
    private static Logger LOG = LoggerFactory.getLogger(TCPSocket.class);
    protected static final int CLOSED = 1;
    protected static final int LISTEN = 2;
    protected static final int SYN_RCVD = 3;
    protected static final int SYN_SENT = 4;
    protected static final int ESTABLISHED = 5;
    protected static final int CLOSE_WAIT = 6;
    protected static final int LAST_ACK = 7;
    protected static final int FIN_WAIT_1 = 8;
    protected static final int FIN_WAIT_2 = 9;
    protected static final int CLOSING = 10;
    protected static final int TIME_WAIT = 11;
    private int zustand = 1;
    private boolean timeout;
    private boolean stopThread;
    private boolean closeSocket;
    protected static final int MAX_SENDEVERSUCHE = 3;
    protected static final int MSS = 1460;
    private LinkedList<TcpSegment> puffer = new LinkedList();
    private LinkedList<String> receivedPayload = new LinkedList();
    private static long synInitValue = 1L;
    private long nextSendSequenceNumber = synInitValue++ % (long)Math.pow(2.0, 32.0) * 1000000L;
    private long lastSentSequenceNumber;
    private long remoteSequenceNumber = 0L;

    public TCPSocket(InternetKnotenBetriebssystem betriebssystem, String zielAdresse, int zielPort) throws VerbindungsException {
        super(betriebssystem, zielAdresse, zielPort, 6);
        LOG.trace("INVOKED-2 (" + this.hashCode() + ") " + this.getClass() + " (TCPSocket), constr: TCPSocket(" + betriebssystem + "," + zielAdresse + "," + zielPort + ")");
    }

    public TCPSocket(InternetKnotenBetriebssystem betriebssystem, int lokalerPort) throws VerbindungsException {
        super(betriebssystem, lokalerPort, 6);
        LOG.trace("INVOKED-2 (" + this.hashCode() + ") " + this.getClass() + " (TCPSocket), constr: TCPSocket(" + betriebssystem + "," + lokalerPort + ")");
    }

    private void sendeSegment(TcpSegment segment, boolean repeat) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TCPSocket), sendeSegment(" + segment + ")");
        segment.setQuellPort(this.lokalerPort);
        segment.setZielPort(this.zielPort);
        if (repeat) {
            segment.setSeqNummer(this.lastSentSequenceNumber);
        } else {
            segment.setSeqNummer(this.nextSendSequenceNumber);
            this.nextSendSequenceNumber = TCPSocket.nextSequenceNumber(segment);
        }
        this.lastSentSequenceNumber = segment.getSeqNummer();
        this.protokoll.senden(this.zielIp, segment);
    }

    @Override
    public synchronized void verbinden() throws VerbindungsException, TimeOutException {
        LOG.debug("initiate new tcp socket connection");
        this.stopThread = false;
        this.closeSocket = false;
        new Thread(this).start();
        while (this.zustand != 5 && !this.closeSocket && !this.stopThread) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.closeSocket) {
            if (this.timeout) {
                throw new TimeOutException(messages.getString("sw_tcpsocket_msg2"));
            }
            if (this.modus == 1) {
                throw new VerbindungsException(messages.getString("sw_tcpsocket_msg3"));
            }
        } else if (this.zustand == 5) {
            LOG.debug("[port={}] connection established.", (Object)this.lokalerPort);
        }
    }

    protected void connect() {
        this.puffer.clear();
        if (this.modus == 2) {
            this.connectServerMode();
        } else {
            this.connectClientMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectServerMode() {
        this.zustand = 2;
        LOG.debug("INFO (" + this.hashCode() + "): verbinden() [passiver Modus], Socket: " + this.toString());
        while (!this.closeSocket && !this.stopThread && this.zustand == 2) {
            LinkedList<TcpSegment> linkedList = this.puffer;
            synchronized (linkedList) {
                if (this.puffer.size() < 1) {
                    try {
                        this.puffer.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    break;
                }
            }
        }
        long sendezeit = Long.MAX_VALUE;
        for (int i = 0; !this.closeSocket && !this.stopThread && i <= 3 && this.zustand != 5; ++i) {
            LinkedList<TcpSegment> linkedList = this.puffer;
            synchronized (linkedList) {
                if (this.puffer.size() < 1) {
                    try {
                        this.puffer.wait(this.defaultTimeout());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.puffer.size() >= 1) {
                sendezeit = System.currentTimeMillis();
                TcpSegment segment = this.puffer.removeFirst();
                if (this.zustand == 2 && segment.isSyn()) {
                    this.remoteSequenceNumber = TCPSocket.nextSequenceNumber(segment);
                    this.zustand = 3;
                    TcpSegment tmp = new TcpSegment();
                    tmp.setSyn(true);
                    this.sendeAck(segment, tmp);
                    continue;
                }
                if (this.zustand == 3 && segment.isAck()) {
                    try {
                        this.eintragenPort();
                        this.zustand = 5;
                    }
                    catch (SocketException e) {
                        LOG.debug("Port for new socket could not be registered.", e);
                        this.closeSocket = true;
                    }
                    continue;
                }
                this.closeSocket = true;
                continue;
            }
            if (System.currentTimeMillis() - sendezeit <= (long)this.defaultTimeout()) continue;
            this.timeout = true;
            this.closeSocket = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectClientMode() {
        try {
            this.eintragenPort();
            LOG.debug("INFO (" + this.hashCode() + "): verbinden() [aktiver Modus], Socket: " + this.toString());
            for (int i = 0; !this.closeSocket && !this.stopThread && this.zustand != 5 && i < 3; ++i) {
                TcpSegment tmp = new TcpSegment();
                tmp.setSyn(true);
                this.sendeSegment(tmp, i > 0);
                this.zustand = 4;
                LinkedList<TcpSegment> linkedList = this.puffer;
                synchronized (linkedList) {
                    if (this.puffer.size() < 1) {
                        try {
                            this.puffer.wait(this.defaultTimeout());
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (!this.closeSocket && !this.stopThread && this.puffer.size() >= 1) {
                    TcpSegment segment = this.puffer.removeFirst();
                    if (this.zustand == 4 && segment.isAck() && segment.isSyn()) {
                        this.remoteSequenceNumber = TCPSocket.nextSequenceNumber(segment);
                        this.zustand = 5;
                        this.sendeAck(segment, null);
                        continue;
                    }
                    this.beenden();
                    continue;
                }
                if (this.zustand == 1) continue;
                this.timeout = true;
                this.closeSocket = true;
            }
            if (this.zustand != 5) {
                this.closeSocket = true;
            }
        }
        catch (SocketException e1) {
            this.closeSocket = true;
            LOG.debug("Port for socket could not be registered.", e1);
        }
    }

    protected LinkedList<TcpSegment> erstelleSegmente(String daten) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TCPSocket), erstelleSegment(" + daten + ")");
        int paketeAnzahl = Math.max(1, (int)Math.ceil((float)daten.length() / 1460.0f));
        LinkedList<TcpSegment> segmenteListe = new LinkedList<TcpSegment>();
        for (int i = 1; i <= paketeAnzahl; ++i) {
            TcpSegment segment = new TcpSegment();
            if (daten.length() < 1460) {
                segment.setDaten(daten);
            } else {
                segment.setDaten(daten.substring(0, 1460));
                daten = daten.substring(1460);
            }
            if (i == paketeAnzahl) {
                segment.setPush(true);
            }
            segmenteListe.add(segment);
        }
        return segmenteListe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void senden(String nachricht) throws VerbindungsException, TimeOutException {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TCPSocket), senden(" + nachricht + ")");
        boolean bestaetigt = true;
        long versendeZeitpunkt = Long.MAX_VALUE;
        if (this.zustand != 5) {
            LOG.debug("EXCEPTION: " + this.getClass() + " (" + this.hashCode() + "); zustand=" + this.zustand);
            this.beenden();
            throw new VerbindungsException(messages.getString("sw_tcpsocket_msg6"));
        }
        LinkedList<TcpSegment> liste = this.erstelleSegmente(nachricht);
        ListIterator it = liste.listIterator();
        while (it.hasNext() && !this.closeSocket && !this.stopThread && this.zustand == 5) {
            bestaetigt = false;
            TcpSegment segment = (TcpSegment)it.next();
            for (int i = 0; !(this.closeSocket || this.stopThread || i >= 3 || bestaetigt); ++i) {
                long rtt;
                if (this.zustand != 5) {
                    this.closeSocket = true;
                    throw new VerbindungsException(messages.getString("sw_tcpsocket_msg7"));
                }
                this.sendeSegment(segment, i > 0);
                versendeZeitpunkt = System.currentTimeMillis();
                do {
                    LinkedList<TcpSegment> linkedList = this.puffer;
                    synchronized (linkedList) {
                        TcpSegment antwort;
                        if (this.puffer.size() < 1) {
                            try {
                                this.puffer.wait(this.defaultTimeout());
                            }
                            catch (InterruptedException e) {
                                LOG.debug("", e);
                            }
                        } else if (!bestaetigt && this.puffer.getFirst().isAck() && (antwort = this.puffer.removeFirst()).getAckNummer() == this.nextSendSequenceNumber) {
                            bestaetigt = true;
                        }
                    }
                    rtt = System.currentTimeMillis() - versendeZeitpunkt;
                } while (!bestaetigt && rtt < (long)this.defaultTimeout() && this.zustand == 5 && !this.closeSocket && !this.stopThread);
            }
            if (bestaetigt || this.zustand == 1 || this.stopThread) continue;
            LOG.debug("[port={}] message '{}' could not be transferred. socket will be closed.", (Object)this.lokalerPort, (Object)nachricht);
            this.schliessen();
            throw new TimeOutException(messages.getString("sw_tcpsocket_msg8"));
        }
    }

    @Override
    public String empfangen() throws VerbindungsException, TimeOutException {
        return this.empfangen(0L);
    }

    protected int defaultTimeout() {
        return 3 * Verbindung.holeRTT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String empfangen(long timeoutMillis) throws VerbindungsException, TimeOutException {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TCPSocket), empfangen()");
        if (this.zustand != 5) {
            throw new VerbindungsException(messages.getString("sw_tcpsocket_msg9"));
        }
        long startTime = System.currentTimeMillis();
        LinkedList<String> linkedList = this.receivedPayload;
        synchronized (linkedList) {
            if (this.receivedPayload.size() < 1) {
                try {
                    this.receivedPayload.wait(timeoutMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        long stopTime = System.currentTimeMillis();
        String data = null;
        if (this.zustand == 5 && !this.receivedPayload.isEmpty()) {
            LinkedList<String> linkedList2 = this.receivedPayload;
            synchronized (linkedList2) {
                data = this.receivedPayload.removeFirst();
            }
        } else if (stopTime - startTime >= timeoutMillis) {
            throw new TimeOutException(messages.getString("sw_tcpsocket_msg10"));
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void listen() {
        StringBuffer nachricht = new StringBuffer();
        while (!this.closeSocket && !this.stopThread && this.zustand == 5) {
            TcpSegment segment = null;
            LinkedList<TcpSegment> linkedList = this.puffer;
            synchronized (linkedList) {
                if (this.puffer.size() < 1) {
                    try {
                        this.puffer.wait(Verbindung.holeRTT());
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    segment = this.puffer.getFirst();
                }
            }
            if (this.closeSocket || this.stopThread || this.zustand != 5 || null == segment || segment.isAck()) continue;
            linkedList = this.puffer;
            synchronized (linkedList) {
                this.puffer.remove(segment);
                this.puffer.notifyAll();
            }
            long ack = TCPSocket.nextSequenceNumber(segment);
            if (ack <= this.remoteSequenceNumber) {
                this.sendeAck(segment, null);
            } else if (ack > this.remoteSequenceNumber) {
                this.sendeAck(segment, null);
                this.remoteSequenceNumber = ack;
                nachricht.append(segment.getDaten());
            }
            if (!segment.isPush()) continue;
            LinkedList<String> linkedList2 = this.receivedPayload;
            synchronized (linkedList2) {
                this.receivedPayload.add(nachricht.toString());
                nachricht = new StringBuffer();
                this.receivedPayload.notifyAll();
            }
        }
        LinkedList<String> linkedList = this.receivedPayload;
        synchronized (linkedList) {
            this.receivedPayload.notifyAll();
        }
        LOG.debug("[port={}] stop listening for incoming data.", (Object)this.lokalerPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schliessen() {
        LOG.debug("close tcp socket");
        this.closeSocket = true;
        LinkedList<TcpSegment> linkedList = this.puffer;
        synchronized (linkedList) {
            this.puffer.notifyAll();
        }
    }

    @Override
    public void run() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TCPSocket), run()");
        LOG.debug("start socket connection mode: {}", (Object)(this.modus == 2 ? "server" : "client"));
        this.connect();
        LOG.debug("[port={}] start listening for incoming messages", (Object)this.lokalerPort);
        this.listen();
        LOG.debug("[port={}] close socket", (Object)this.lokalerPort);
        this.close();
        LOG.debug("[port={}] port closed", (Object)this.lokalerPort);
        this.austragenPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        if (!this.stopThread && this.zustand != 2 && this.zustand != 1) {
            TcpSegment tmp = new TcpSegment();
            tmp.setFin(true);
            switch (this.zustand) {
                case 3: 
                case 5: {
                    this.sendeSegment(tmp, false);
                    this.zustand = 8;
                    break;
                }
                case 4: {
                    this.zustand = 1;
                    LinkedList<TcpSegment> linkedList = this.puffer;
                    synchronized (linkedList) {
                        this.puffer.notifyAll();
                        break;
                    }
                }
                case 6: {
                    this.sendeSegment(tmp, false);
                    this.zustand = 7;
                }
            }
            for (int i = 0; !this.stopThread && this.zustand != 1 && i < 5; ++i) {
                LinkedList<TcpSegment> linkedList = this.puffer;
                synchronized (linkedList) {
                    if (this.puffer.size() < 1) {
                        try {
                            this.puffer.wait(this.defaultTimeout());
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (this.zustand == 11) {
                        this.puffer.clear();
                        this.zustand = 1;
                    } else if (this.puffer.size() >= 1) {
                        tmp = this.puffer.removeFirst();
                        switch (this.zustand) {
                            case 7: {
                                if (!tmp.isAck()) break;
                                this.zustand = 1;
                                break;
                            }
                            case 10: {
                                if (!tmp.isAck()) break;
                                this.zustand = 11;
                                break;
                            }
                            case 9: {
                                if (!tmp.isFin()) break;
                                this.sendeAck(tmp, null);
                                this.zustand = 11;
                                break;
                            }
                            case 8: {
                                if (tmp.isAck() && tmp.isFin()) {
                                    this.sendeAck(tmp, null);
                                    this.zustand = 11;
                                    break;
                                }
                                if (tmp.isAck()) {
                                    this.zustand = 9;
                                    break;
                                }
                                if (!tmp.isFin()) break;
                                this.sendeAck(tmp, null);
                                this.zustand = 10;
                            }
                        }
                    }
                    continue;
                }
            }
        }
    }

    private void sendeAck(TcpSegment empfangSegment, TcpSegment sendeSegment) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TCPSocket), sendeAck(" + empfangSegment + "," + sendeSegment + ")");
        if (sendeSegment == null) {
            sendeSegment = new TcpSegment();
        }
        sendeSegment.setAck(true);
        sendeSegment.setAckNummer(TCPSocket.nextSequenceNumber(empfangSegment));
        this.sendeSegment(sendeSegment, false);
    }

    static long nextSequenceNumber(TcpSegment segment) {
        long nextNumber = segment.getSeqNummer();
        if (segment.isSyn() || segment.isFin()) {
            ++nextNumber;
        }
        nextNumber += (long)StringUtils.length(segment.getDaten());
        return nextNumber %= 0x100000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hinzufuegen(String startIp, int startPort, Object segment) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TCPSocket), hinzufuegen(" + startIp + "," + startPort + "," + segment + ")");
        TcpSegment tcpSegment = (TcpSegment)segment;
        if (this.zustand == 2) {
            this.zielPort = startPort;
            this.zielIp = startIp;
        }
        if (this.zustand == 5 && tcpSegment.isFin()) {
            this.sendeAck(tcpSegment, null);
            this.zustand = 6;
            LinkedList<TcpSegment> linkedList = this.puffer;
            synchronized (linkedList) {
                this.puffer.notifyAll();
            }
        }
        LinkedList<TcpSegment> linkedList = this.puffer;
        synchronized (linkedList) {
            this.puffer.addLast(tcpSegment);
            this.puffer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beenden() {
        LOG.debug("stop tcp socket thread");
        this.stopThread = true;
        LinkedList<TcpSegment> linkedList = this.puffer;
        synchronized (linkedList) {
            this.puffer.notifyAll();
        }
    }

    @Override
    public boolean istVerbunden() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TCPSocket), istVerbunden(), port: " + this.holeLokalenPort());
        return this.zustand == 5;
    }

    public boolean isSortOfConnected() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (TCPSocket), isSortOfConnected(), port: " + this.holeLokalenPort());
        return this.zustand >= 5 && this.zustand <= 11;
    }

    @Override
    public String getStateAsString() {
        switch (this.zustand) {
            case 1: {
                return "CLOSED";
            }
            case 2: {
                return "LISTEN";
            }
            case 3: {
                return "SYN_RCVD";
            }
            case 4: {
                return "SYN_SENT";
            }
            case 5: {
                return "ESTABLISHED";
            }
            case 6: {
                return "CLOSE_WAIT";
            }
            case 7: {
                return "LAST_ACK";
            }
            case 8: {
                return "FIN_WAIT_1";
            }
            case 9: {
                return "FIN_WAIT_2";
            }
            case 10: {
                return "CLOSING";
            }
            case 11: {
                return "TIME_WAIT";
            }
        }
        return "<unknown>";
    }
}

