/*
 * Decompiled with CFR 0.152.
 */
package filius.software.transportschicht;

import filius.exception.SocketException;
import filius.exception.TimeOutException;
import filius.exception.VerbindungsException;
import filius.rahmenprogramm.I18n;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.transportschicht.Segment;
import filius.software.transportschicht.ServerSocket;
import filius.software.transportschicht.SocketSchnittstelle;
import filius.software.transportschicht.TransportProtokoll;
import filius.software.vermittlungsschicht.IP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Socket
implements SocketSchnittstelle,
I18n {
    private static Logger LOG = LoggerFactory.getLogger(Socket.class);
    protected static final int AKTIV = 1;
    protected static final int PASSIV = 2;
    protected int modus;
    protected TransportProtokoll protokoll;
    protected int lokalerPort = -1;
    protected String quellIp;
    protected String zielIp;
    protected int zielPort;

    public Socket(InternetKnotenBetriebssystem betriebssystem, String zielAdresse, int zielPort, int transportProtokoll) throws VerbindungsException {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (Socket), constr: Socket(" + betriebssystem + "," + zielAdresse + "," + zielPort + "," + transportProtokoll + ")");
        this.modus = 1;
        this.protokoll = transportProtokoll == 6 ? betriebssystem.holeTcp() : betriebssystem.holeUdp();
        String ip = this.ipCheck(zielAdresse);
        if (ip != null) {
            this.zielIp = ip;
        } else {
            try {
                this.zielIp = betriebssystem.holeDNSClient().holeIPAdresse(zielAdresse);
            }
            catch (TimeOutException e) {
                LOG.debug("could not resolve destination IP address for new socket to " + zielAdresse, e);
            }
        }
        if (this.zielIp == null) {
            throw new VerbindungsException(messages.getString("sw_socket_msg1"));
        }
        this.zielPort = zielPort;
    }

    public Socket(InternetKnotenBetriebssystem betriebssystem, String zielAdresse, int zielPort, int transportProtokoll, int lokalerPort) throws VerbindungsException {
        this(betriebssystem, zielAdresse, zielPort, transportProtokoll);
        LOG.trace("INVOKED-2 (" + this.hashCode() + ") " + this.getClass() + " (Socket), constr: Socket(" + betriebssystem + "," + zielAdresse + "," + zielPort + "," + transportProtokoll + "," + lokalerPort + ")");
        this.lokalerPort = lokalerPort;
    }

    public Socket(InternetKnotenBetriebssystem betriebssystem, int lokalerPort, int transportProtokoll) throws VerbindungsException {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (Socket), constr: Socket(" + betriebssystem + "," + lokalerPort + "," + transportProtokoll + ")");
        this.modus = 2;
        this.protokoll = transportProtokoll == 6 ? betriebssystem.holeTcp() : betriebssystem.holeUdp();
        this.lokalerPort = lokalerPort;
    }

    public Socket() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (Socket), constr: Socket()");
    }

    public abstract void senden(String var1) throws VerbindungsException, TimeOutException;

    public abstract String empfangen() throws VerbindungsException, TimeOutException;

    public abstract String empfangen(long var1) throws VerbindungsException, TimeOutException;

    protected String ipCheck(String ip) {
        return IP.ipCheck(ip);
    }

    protected void sende(Segment segment) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (Socket), sende(" + segment + ")");
        this.protokoll.senden(this.zielIp, this.quellIp, segment);
    }

    protected void sende(String zielIp, String quellIp, Segment segment) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (Socket), sende(" + segment + ")");
        this.protokoll.senden(zielIp, quellIp, segment);
    }

    @Override
    public abstract void schliessen();

    public abstract void verbinden() throws VerbindungsException, TimeOutException;

    public abstract boolean istVerbunden();

    protected void eintragenPort() throws SocketException {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (Socket), eintragenPort()");
        SocketSchnittstelle socket = null;
        if (this.lokalerPort == -1) {
            this.lokalerPort = this.protokoll.reserviereFreienPort(this);
            LOG.debug("[port={}] new client port registered.", (Object)this.lokalerPort);
        } else {
            if (this.protokoll.isUsed(this.lokalerPort)) {
                socket = this.protokoll.holeSocket(this.lokalerPort);
            }
            if (socket != null && socket instanceof ServerSocket) {
                ServerSocket serverSocket = (ServerSocket)socket;
                serverSocket.eintragenSocket(this);
                LOG.debug("[port={}] new server port registered for remote endpoint {}:{}.", this.lokalerPort, this.holeZielIPAdresse(), this.holeZielPort());
            } else if (!this.protokoll.reservierePort(this.lokalerPort, this)) {
                throw new SocketException();
            }
        }
    }

    protected void austragenPort() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (Socket), austragenPort()");
        SocketSchnittstelle socket = null;
        try {
            socket = this.protokoll.holeSocket(this.lokalerPort);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (socket != null && socket instanceof ServerSocket) {
            ServerSocket serverSocket = (ServerSocket)socket;
            serverSocket.austragenSocket(this);
        } else if (socket != null) {
            this.protokoll.gibPortFrei(this.lokalerPort);
        }
    }

    public String holeZielIPAdresse() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (Socket), holeZielIPAdresse()");
        return this.zielIp;
    }

    public int holeZielPort() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (Socket), holeZielPort()");
        return this.zielPort;
    }

    public int holeLokalenPort() {
        return this.lokalerPort;
    }

    public void bind(String quellIp) {
        this.quellIp = quellIp;
    }

    public abstract String getStateAsString();
}

