/*
 * Decompiled with CFR 0.152.
 */
package filius.software.system;

import filius.hardware.knoten.InternetKnoten;
import filius.hardware.knoten.Knoten;
import filius.rahmenprogramm.Information;
import filius.rahmenprogramm.ResourceUtil;
import filius.software.firewall.Firewall;
import filius.software.firewall.FirewallWebKonfig;
import filius.software.firewall.FirewallWebLog;
import filius.software.rip.RIPBeacon;
import filius.software.rip.RIPServer;
import filius.software.rip.RIPTable;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.vermittlungsschicht.VermittlungWeb;
import filius.software.www.WebServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VermittlungsrechnerBetriebssystem
extends InternetKnotenBetriebssystem {
    private static Logger LOG = LoggerFactory.getLogger(VermittlungsrechnerBetriebssystem.class);
    private static final long serialVersionUID = 1L;
    private boolean ripEnabled;
    private RIPTable riptable;
    private RIPBeacon ripbeacon;
    private RIPServer ripserver;

    public VermittlungsrechnerBetriebssystem() {
        LOG.trace("INVOKED-2 (" + this.hashCode() + ") " + this.getClass() + " (VermittlungsrechnerBetriebssystem), constr: VermittlungsrechnerBetriebssystem()");
        this.setIpForwardingEnabled(true);
        this.initialisiereAnwendungen();
    }

    @Override
    public void setKnoten(Knoten vermittlungsrechner) {
        super.setKnoten(vermittlungsrechner);
    }

    private void initialisiereAnwendungen() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (VermittlungsrechnerBetriebssystem), initialisiereFirewallUndWebserver()");
        WebServer server = null;
        Firewall firewall = null;
        this.installApp("filius.software.firewall.Firewall");
        this.installApp("filius.software.www.WebServer");
        firewall = this.holeFirewall();
        server = this.holeWebServer();
        firewall.setDefaultPolicy((short)0);
        firewall.setActivated(false);
        FirewallWebLog weblog = new FirewallWebLog();
        weblog.setFirewall(firewall);
        weblog.setPfad("log");
        server.setzePlugIn(weblog);
        FirewallWebKonfig webkonfig = new FirewallWebKonfig();
        webkonfig.setWebserver(server);
        webkonfig.setFirewall(firewall);
        webkonfig.setPfad("konfig");
        server.setzePlugIn(webkonfig);
        server.erzeugeIndexDatei(ResourceUtil.getResourcePath("tmpl/vermittlung_index_" + Information.getInformation().getLocaleOrDefault() + ".txt"));
        this.riptable = new RIPTable(this);
        this.ripserver = new RIPServer();
        this.ripserver.setSystemSoftware(this);
        this.ripbeacon = new RIPBeacon();
        this.ripbeacon.setSystemSoftware(this);
        VermittlungWeb ripweb = new VermittlungWeb(this);
        ripweb.setPfad("routes");
        server.setzePlugIn(ripweb);
    }

    @Override
    public void starten() {
        LOG.debug("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (VermittlungsrechnerBetriebssystem), starten()");
        super.starten();
        this.holeWebServer().setAktiv(true);
        if (this.ripEnabled) {
            this.riptable.reset();
            this.riptable.addLocalRoutes((InternetKnoten)this.getKnoten());
            this.ripserver.starten();
            this.ripserver.setAktiv(true);
            this.ripbeacon.starten();
        }
    }

    @Override
    public void beenden() {
        super.beenden();
        if (this.ripEnabled) {
            this.ripbeacon.beenden();
            this.ripserver.beenden();
        }
    }

    @Override
    public RIPTable getRIPTable() {
        if (this.ripEnabled) {
            return this.riptable;
        }
        return null;
    }

    @Override
    public boolean isRipEnabled() {
        return this.ripEnabled;
    }

    public void setRipEnabled(boolean state) {
        this.ripEnabled = state;
    }

    public Firewall holeFirewall() {
        return (Firewall)this.holeSoftware("filius.software.firewall.Firewall");
    }

    public WebServer holeWebServer() {
        return (WebServer)this.holeSoftware("filius.software.www.WebServer");
    }
}

