/*
 * Decompiled with CFR 0.152.
 */
package filius.software.system;

import filius.hardware.NetzwerkInterface;
import filius.hardware.knoten.Gateway;
import filius.hardware.knoten.Knoten;
import filius.rahmenprogramm.Information;
import filius.rahmenprogramm.ResourceUtil;
import filius.software.firewall.Firewall;
import filius.software.firewall.FirewallWebKonfig;
import filius.software.firewall.FirewallWebLog;
import filius.software.nat.NatGateway;
import filius.software.rip.RIPTable;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.www.WebServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayFirmware
extends InternetKnotenBetriebssystem {
    private static Logger LOG = LoggerFactory.getLogger(GatewayFirmware.class);

    public GatewayFirmware() {
        LOG.trace("INVOKED-2 (" + this.hashCode() + ") " + this.getClass() + " (VermittlungsrechnerBetriebssystem), constr: VermittlungsrechnerBetriebssystem()");
        this.setIpForwardingEnabled(true);
        this.initialisiereAnwendungen();
    }

    @Override
    public void setKnoten(Knoten gateway) {
        super.setKnoten(gateway);
    }

    @Override
    public String dhcpEnabledMACAddress() {
        return ((Gateway)this.getKnoten()).holeWANInterface().getMac();
    }

    @Override
    public NetzwerkInterface primaryNetworkInterface() {
        return ((Gateway)this.getKnoten()).holeLANInterface();
    }

    private void initialisiereAnwendungen() {
        WebServer server = null;
        Firewall firewall = null;
        this.installApp("filius.software.nat.NatGateway");
        this.installApp("filius.software.www.WebServer");
        firewall = this.holeFirewall();
        server = this.holeWebServer();
        firewall.setDefaultPolicy((short)0);
        firewall.setActivated(false);
        FirewallWebLog weblog = new FirewallWebLog();
        weblog.setFirewall(firewall);
        weblog.setPfad("log");
        server.setzePlugIn(weblog);
        FirewallWebKonfig webkonfig = new FirewallWebKonfig();
        webkonfig.setWebserver(server);
        webkonfig.setFirewall(firewall);
        webkonfig.setPfad("konfig");
        server.setzePlugIn(webkonfig);
        server.erzeugeIndexDatei(ResourceUtil.getResourcePath("tmpl/gateway_index_" + Information.getInformation().getLocaleOrDefault() + ".txt"));
    }

    @Override
    public void starten() {
        super.starten();
        this.holeWebServer().setAktiv(true);
    }

    @Override
    public void beenden() {
        super.beenden();
    }

    public Firewall holeFirewall() {
        Firewall firewall = (Firewall)this.holeSoftware("filius.software.firewall.Firewall");
        if (null == firewall) {
            firewall = (NatGateway)this.holeSoftware("filius.software.nat.NatGateway");
        }
        return firewall;
    }

    public WebServer holeWebServer() {
        return (WebServer)this.holeSoftware("filius.software.www.WebServer");
    }

    @Override
    public RIPTable getRIPTable() {
        return null;
    }

    @Override
    public boolean isRipEnabled() {
        return false;
    }
}

