/*
 * Decompiled with CFR 0.152.
 */
package filius.software.netzzugangsschicht;

import filius.hardware.Port;
import filius.hardware.knoten.Switch;
import filius.software.ProtokollThread;
import filius.software.netzzugangsschicht.EthernetFrame;
import filius.software.system.SwitchFirmware;
import java.util.Date;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchPortBeobachter
extends ProtokollThread<EthernetFrame> {
    private static Logger LOG = LoggerFactory.getLogger(SwitchPortBeobachter.class);
    private SwitchFirmware switchFirmware;
    private Port anschluss;

    public SwitchPortBeobachter(SwitchFirmware switchFirmware, Port anschluss) {
        super(anschluss.holeEingangsPuffer());
        LOG.trace("INVOKED-2 (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (SwitchPortBeobachter), constr: SwitchPortBeobachter(" + switchFirmware + "," + anschluss + ")");
        this.switchFirmware = switchFirmware;
        this.anschluss = anschluss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verarbeiteDatenEinheit(EthernetFrame etp) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (SwitchPortBeobachter), verarbeiteDatenEinheit(" + etp.toString() + ")");
        if (!this.switchFirmware.holeDurchgelaufeneFrames().contains(etp)) {
            this.switchFirmware.holeDurchgelaufeneFrames().add(etp);
            Date letztes_update = new Date();
            this.switchFirmware.hinzuSatEintrag(etp.getQuellMacAdresse(), this.anschluss, letztes_update);
            Port zielAnschluss = this.switchFirmware.holeAnschlussFuerMAC(etp.getZielMacAdresse());
            if (zielAnschluss != null) {
                LinkedList<EthernetFrame> linkedList = zielAnschluss.holeAusgangsPuffer();
                synchronized (linkedList) {
                    zielAnschluss.holeAusgangsPuffer().add(etp);
                    zielAnschluss.holeAusgangsPuffer().notify();
                }
            } else {
                for (Port aktiverAnschluss : ((Switch)this.switchFirmware.getKnoten()).getAnschluesse()) {
                    if (aktiverAnschluss.isPortFrei() || aktiverAnschluss == this.anschluss) continue;
                    LinkedList<EthernetFrame> linkedList = aktiverAnschluss.holeAusgangsPuffer();
                    synchronized (linkedList) {
                        aktiverAnschluss.holeAusgangsPuffer().add(etp);
                        aktiverAnschluss.holeAusgangsPuffer().notify();
                    }
                }
            }
        }
    }
}

