/*
 * Decompiled with CFR 0.152.
 */
package filius.software.netzzugangsschicht;

import filius.hardware.NetzwerkInterface;
import filius.rahmenprogramm.nachrichten.Lauscher;
import filius.software.ProtokollThread;
import filius.software.netzzugangsschicht.Ethernet;
import filius.software.netzzugangsschicht.EthernetFrame;
import filius.software.vermittlungsschicht.ArpPaket;
import filius.software.vermittlungsschicht.IcmpPaket;
import filius.software.vermittlungsschicht.IpPaket;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EthernetThread
extends ProtokollThread<EthernetFrame> {
    private static Logger LOG = LoggerFactory.getLogger(EthernetThread.class);
    private NetzwerkInterface netzwerkInterface;
    private Ethernet ethernet;

    public EthernetThread(Ethernet ethernet, NetzwerkInterface nic) {
        super(nic.getPort().holeEingangsPuffer());
        LOG.trace("INVOKED-2 (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (EthernetThread), constr: EthernetThread(" + ethernet + "," + nic + ")");
        this.ethernet = ethernet;
        this.netzwerkInterface = nic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void verarbeiteDatenEinheit(EthernetFrame etp) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (EthernetThread), verarbeiteDateneinheit(" + etp.toString() + ")");
        Lauscher.getLauscher().addDatenEinheit(this.netzwerkInterface.getMac(), etp);
        if (!etp.getZielMacAdresse().equalsIgnoreCase("FF:FF:FF:FF:FF:FF") && !etp.getZielMacAdresse().equals(this.netzwerkInterface.getMac())) {
            return;
        }
        if (etp.getTyp().equals("0x800")) {
            IpPaket ipPacket = (IpPaket)etp.getDaten();
            if (ipPacket.getProtocol() == 1) {
                LinkedList<IcmpPaket> linkedList = this.ethernet.holeICMPPuffer();
                synchronized (linkedList) {
                    this.ethernet.holeICMPPuffer().add((IcmpPaket)ipPacket);
                    this.ethernet.holeICMPPuffer().notifyAll();
                }
            } else {
                LinkedList<IpPaket> linkedList = this.ethernet.holeIPPuffer();
                synchronized (linkedList) {
                    this.ethernet.holeIPPuffer().add(ipPacket);
                    this.ethernet.holeIPPuffer().notify();
                }
            }
        } else if (etp.getTyp().equals("0x806")) {
            String zielIp = ((ArpPaket)etp.getDaten()).getTargetIP();
            if (!zielIp.equals(this.netzwerkInterface.getIp()) && !"0.0.0.0".equals(this.netzwerkInterface.getIp())) {
                LOG.debug("received ARP packet from (" + ((ArpPaket)etp.getDaten()).getSenderIP() + "," + ((ArpPaket)etp.getDaten()).getSenderMAC() + ") is not addressed to this NIC (" + this.netzwerkInterface.getIp() + "," + this.netzwerkInterface.getMac() + ") and will be discarded");
                return;
            }
            LinkedList<ArpPaket> linkedList = this.ethernet.holeARPPuffer();
            synchronized (linkedList) {
                this.ethernet.holeARPPuffer().add((ArpPaket)etp.getDaten());
                this.ethernet.holeARPPuffer().notify();
            }
        } else {
            LOG.debug("ERROR (" + this.hashCode() + "): Paket konnte nicht zugeordnet werden");
        }
    }
}

