/*
 * Decompiled with CFR 0.152.
 */
package filius.software.netzzugangsschicht;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EthernetFrame
implements Serializable {
    private static Logger LOG = LoggerFactory.getLogger(EthernetFrame.class);
    private static final long serialVersionUID = 1L;
    public static final String IP = "0x800";
    public static final String ARP = "0x806";
    private String zielMacAdresse;
    private String quellMacAdresse;
    private String typ;
    private Object daten;
    private Set<String> readByLauscherForMac = new HashSet<String>();

    public EthernetFrame(Object daten, String quellMacAdresse, String zielMacAdresse, String typ) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (EthernetFrame), constr: EthernetFrame(" + daten + "," + quellMacAdresse + "," + zielMacAdresse + "," + typ + ")");
        this.zielMacAdresse = zielMacAdresse;
        this.quellMacAdresse = quellMacAdresse;
        this.typ = typ;
        this.daten = daten;
    }

    public void setReadByLauscherForMac(String mac) {
        this.readByLauscherForMac.add(mac);
    }

    public boolean isReadByLauscherForMac(String mac) {
        return this.readByLauscherForMac.contains(mac);
    }

    public Object getDaten() {
        return this.daten;
    }

    public String getQuellMacAdresse() {
        return this.quellMacAdresse;
    }

    public String getTyp() {
        return this.typ;
    }

    public String getZielMacAdresse() {
        return this.zielMacAdresse;
    }

    public String toString() {
        return "[src=" + this.quellMacAdresse + ", dest=" + this.zielMacAdresse + ", type=" + this.typ + (this.daten != null ? " | " + this.daten : "") + "]";
    }
}

