/*
 * Decompiled with CFR 0.152.
 */
package filius.software.nat;

import filius.software.nat.InetAddress;
import filius.software.nat.PortProtocolPair;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAddressTranslationTable {
    private static Logger LOG = LoggerFactory.getLogger(NetworkAddressTranslationTable.class);
    private Map<PortProtocolPair, InetAddress> dynamicNATTable = new HashMap<PortProtocolPair, InetAddress>();
    private Map<PortProtocolPair, InetAddress> staticNATTable = new HashMap<PortProtocolPair, InetAddress>();

    public Map<PortProtocolPair, InetAddress> getStaticNATTable() {
        return Collections.unmodifiableMap(this.staticNATTable);
    }

    public void setStaticNATTable(Map<PortProtocolPair, InetAddress> staticNATTable) {
        this.staticNATTable = new HashMap<PortProtocolPair, InetAddress>(staticNATTable);
    }

    void addDynamic(int port, int protocol, InetAddress address) {
        this.dynamicNATTable.put(new PortProtocolPair(port, protocol), address);
    }

    public InetAddress find(int port, int protocol) {
        PortProtocolPair lookup = new PortProtocolPair(port, protocol);
        return this.dynamicNATTable.get(lookup);
    }

    public boolean hasConnection(InetAddress lanAddress) {
        boolean exists = false;
        for (PortProtocolPair key : this.dynamicNATTable.keySet()) {
            if (!this.dynamicNATTable.get(key).equals(lanAddress)) continue;
            exists = true;
            break;
        }
        return exists;
    }

    public int findPort(InetAddress lanAddress) {
        int port = 0;
        for (PortProtocolPair key : this.dynamicNATTable.keySet()) {
            if (!this.dynamicNATTable.get(key).equals(lanAddress)) continue;
            port = key.getPort();
            break;
        }
        return port;
    }

    public void print() {
        for (Map.Entry<PortProtocolPair, InetAddress> entry : this.dynamicNATTable.entrySet()) {
            LOG.debug("{} -> {}", (Object)entry.getKey(), (Object)entry.getValue());
        }
    }
}

