/*
 * Decompiled with CFR 0.152.
 */
package filius.software.nat;

import filius.hardware.NetzwerkInterface;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.nachrichten.Lauscher;
import filius.software.firewall.FirewallThread;
import filius.software.nat.NatGateway;
import filius.software.netzzugangsschicht.EthernetFrame;
import filius.software.vermittlungsschicht.IpPaket;
import filius.software.vermittlungsschicht.VermittlungsProtokoll;

public class NatGatewayWANThread
extends FirewallThread
implements I18n {
    private NatGateway natGateway;
    private NetzwerkInterface lanNic;
    private NetzwerkInterface wanNic;

    public NatGatewayWANThread(NatGateway natGateway, NetzwerkInterface nic, NetzwerkInterface lanNic) {
        super(natGateway, nic);
        this.natGateway = natGateway;
        this.wanNic = nic;
        this.lanNic = lanNic;
    }

    @Override
    protected void verarbeiteDatenEinheit(EthernetFrame frame) {
        Lauscher.getLauscher().addDatenEinheit(this.wanNic.getMac(), frame);
        if (!this.checkToLANAddress(frame) && !this.checkDiscardByFirewall(frame)) {
            this.modifyIncomingFrame(frame);
            this.forwardFrame(frame);
        }
    }

    private void modifyIncomingFrame(EthernetFrame frame) {
        IpPaket packet;
        if (frame.getDaten() instanceof IpPaket && (packet = (IpPaket)frame.getDaten()).getEmpfaenger().contentEquals(this.wanNic.getIp())) {
            this.natGateway.replaceDestination(packet);
        }
    }

    private boolean checkToLANAddress(EthernetFrame frame) {
        IpPaket packet;
        boolean toLANAddress = false;
        if (null != this.lanNic && frame.getDaten() instanceof IpPaket && VermittlungsProtokoll.gleichesRechnernetz((packet = (IpPaket)frame.getDaten()).getEmpfaenger(), this.lanNic.getIp(), this.lanNic.getSubnetzMaske())) {
            toLANAddress = true;
        }
        return toLANAddress;
    }
}

