/*
 * Decompiled with CFR 0.152.
 */
package filius.software.firewall;

import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.Information;
import filius.software.firewall.Firewall;
import filius.software.firewall.FirewallRule;
import filius.software.www.WebServer;
import filius.software.www.WebServerPlugIn;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirewallWebKonfig
extends WebServerPlugIn
implements I18n {
    private static Logger LOG = LoggerFactory.getLogger(FirewallWebKonfig.class);
    private WebServer webserver;
    private Firewall firewall;
    private String srcIP = "";
    private String srcMask = "";
    private String destIP = "";
    private String destMask = "";
    private short protocol = (short)-1;
    private int port = -1;
    private String portStr = "";
    private short action = 0;
    private String errMsg = "";

    public void setFirewall(Firewall firewall) {
        this.firewall = firewall;
    }

    public Firewall getFirewall() {
        return this.firewall;
    }

    public void setWebserver(WebServer server) {
        this.webserver = server;
    }

    public WebServer getWebserver() {
        return this.webserver;
    }

    @Override
    public String holeHtmlSeite(String postDaten) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (FirewallWebKonfig), holeHtmlSeite(" + postDaten + ")");
        String seite = "";
        if (postDaten != null && !postDaten.isEmpty()) {
            this.processParameters(postDaten);
        }
        seite = this.konfigSeiteErstellen();
        return seite;
    }

    private String[][] postStringZerlegen(String post) {
        String[] submitTeile;
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (FirewallWebKonfig), postStringZerlegen(" + post + ")");
        try {
            submitTeile = URLDecoder.decode(post, "UTF-8").split("&");
        }
        catch (UnsupportedEncodingException e) {
            submitTeile = post.split("&");
        }
        String[][] tupel = new String[submitTeile.length][2];
        for (int i = 0; i < submitTeile.length; ++i) {
            String[] tmp = submitTeile[i].split("=");
            String[] element = new String[]{"", ""};
            for (int j = 0; j < tmp.length && j < element.length; ++j) {
                element[j] = tmp[j].trim();
            }
            tupel[i] = element;
        }
        return tupel;
    }

    private void processParameters(String postString) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (FirewallWebKonfig), processParameters(" + postString + ")");
        this.srcIP = "";
        this.srcMask = "";
        this.destIP = "";
        this.destMask = "";
        this.protocol = (short)-1;
        this.port = -1;
        this.portStr = "";
        this.action = 0;
        this.errMsg = "";
        int radioRule = -1;
        short defaultPolicy = 0;
        boolean cbActive = false;
        boolean cbDropIcmp = false;
        boolean cbOnlySyn = false;
        boolean doSaveState = false;
        boolean doSaveDefPol = false;
        boolean doMoveUp = false;
        boolean doMoveDown = false;
        boolean doDelRule = false;
        boolean doAddRule = false;
        if (this.webserver.getSystemSoftware() != null) {
            String[][] postContent = this.postStringZerlegen(postString);
            for (int i = 0; i < postContent.length; ++i) {
                if (postContent[i][0].equals("btnSave")) {
                    doSaveState = true;
                    continue;
                }
                if (postContent[i][0].equals("defPolSet")) {
                    doSaveDefPol = true;
                    continue;
                }
                if (postContent[i][0].equals("moveup")) {
                    doMoveUp = true;
                    continue;
                }
                if (postContent[i][0].equals("movedown")) {
                    doMoveDown = true;
                    continue;
                }
                if (postContent[i][0].equals("delrule")) {
                    doDelRule = true;
                    continue;
                }
                if (postContent[i][0].equals("addrule")) {
                    doAddRule = true;
                    continue;
                }
                if (postContent[i][0].equals("defaultPolicy")) {
                    if (postContent[i][1].equals("accept")) {
                        defaultPolicy = 1;
                        continue;
                    }
                    defaultPolicy = 0;
                    continue;
                }
                if (postContent[i][0].equals("srcIP")) {
                    this.srcIP = postContent[i][1];
                    if (this.srcIP.isEmpty()) continue;
                    if (!EingabenUeberpruefung.isGueltig(this.srcIP, EingabenUeberpruefung.musterIpAdresse)) {
                        this.errMsg = this.errMsg + "<li>" + messages.getString("firewallwebkonfig_msg2") + "</li>";
                    }
                    if (!this.srcMask.isEmpty() && EingabenUeberpruefung.isValidSubnetmask(this.srcMask)) continue;
                    this.errMsg = this.errMsg + "<li>" + messages.getString("firewallwebkonfig_msg3") + "</li>";
                    continue;
                }
                if (postContent[i][0].equals("srcMask")) {
                    this.srcMask = postContent[i][1];
                    if (this.srcMask.isEmpty()) continue;
                    if (!EingabenUeberpruefung.isValidSubnetmask(this.srcMask)) {
                        this.errMsg = this.errMsg + "<li>" + messages.getString("firewallwebkonfig_msg3") + "</li>";
                    }
                    if (!this.srcIP.isEmpty()) continue;
                    this.errMsg = this.errMsg + "<li>" + messages.getString("firewallwebkonfig_msg7") + "</li>";
                    continue;
                }
                if (postContent[i][0].equals("destIP")) {
                    this.destIP = postContent[i][1];
                    if (this.destIP.isEmpty()) continue;
                    if (!EingabenUeberpruefung.isGueltig(this.destIP, EingabenUeberpruefung.musterIpAdresse)) {
                        this.errMsg = this.errMsg + "<li>" + messages.getString("firewallwebkonfig_msg4") + "</li>";
                    }
                    if (!this.destMask.isEmpty() && EingabenUeberpruefung.isValidSubnetmask(this.destMask)) continue;
                    this.errMsg = this.errMsg + "<li>" + messages.getString("firewallwebkonfig_msg5") + "</li>";
                    continue;
                }
                if (postContent[i][0].equals("destMask")) {
                    this.destMask = postContent[i][1];
                    if (this.destMask.isEmpty()) continue;
                    if (!EingabenUeberpruefung.isValidSubnetmask(this.destMask)) {
                        this.errMsg = this.errMsg + "<li>" + messages.getString("firewallwebkonfig_msg5") + "</li>";
                    }
                    if (!this.destIP.isEmpty()) continue;
                    this.errMsg = this.errMsg + "<li>" + messages.getString("firewallwebkonfig_msg7") + "</li>";
                    continue;
                }
                if (postContent[i][0].equals("protocol")) {
                    if (postContent[i][1].equals("TCP")) {
                        this.protocol = (short)6;
                        continue;
                    }
                    if (!postContent[i][1].equals("UDP")) continue;
                    this.protocol = (short)17;
                    continue;
                }
                if (postContent[i][0].equals("port")) {
                    this.portStr = postContent[i][1];
                    try {
                        this.port = Integer.parseInt(this.portStr);
                        if (this.port == -1 || EingabenUeberpruefung.isGueltig(this.portStr, EingabenUeberpruefung.musterPort)) continue;
                        this.errMsg = this.errMsg + "<li>" + messages.getString("firewallwebkonfig_msg6") + "</li>";
                    }
                    catch (Exception e) {
                        if (postContent[i][1].isEmpty()) continue;
                        this.errMsg = this.errMsg + "<li>" + messages.getString("firewallwebkonfig_msg6") + "</li>";
                    }
                    continue;
                }
                if (postContent[i][0].equals("action")) {
                    if (postContent[i][1].equals("accept")) {
                        this.action = 1;
                        continue;
                    }
                    this.action = 0;
                    continue;
                }
                if (postContent[i][0].equals("radioRule")) {
                    try {
                        radioRule = Integer.parseInt(postContent[i][1]);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (postContent[i][0].equals("firewallActivate")) {
                    cbActive = true;
                    continue;
                }
                if (postContent[i][0].equals("dropICMP")) {
                    cbDropIcmp = true;
                    continue;
                }
                if (!postContent[i][0].equals("onlySYN")) continue;
                cbOnlySyn = true;
            }
            if (doSaveState) {
                this.firewall.setActivated(cbActive);
                this.firewall.setDropICMP(cbDropIcmp);
                this.firewall.setFilterSYNSegmentsOnly(cbOnlySyn);
            } else if (doSaveDefPol) {
                this.firewall.setDefaultPolicy(defaultPolicy);
            } else if (doMoveUp) {
                this.firewall.moveUp(radioRule);
            } else if (doMoveDown) {
                this.firewall.moveDown(radioRule);
            } else if (doDelRule) {
                this.firewall.deleteRule(radioRule - 1);
            } else if (doAddRule) {
                if (this.errMsg.isEmpty()) {
                    this.firewall.addRule(new FirewallRule(this.srcIP, this.srcMask, this.destIP, this.destMask, this.port, this.protocol, this.action));
                } else {
                    this.errMsg = "<font color=\"red\">" + messages.getString("firewallwebkonfig_msg1") + "<ul>" + this.errMsg + "</ul></font><br>";
                }
            }
            if (!doAddRule) {
                this.errMsg = "";
            }
        }
    }

    private String konfigSeiteErstellen() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (FirewallWebKonfig), konfigSeiteErstellen()");
        if (this.firewall != null) {
            String html;
            try {
                html = this.textDateiEinlesen("tmpl/firewall_konfig_webseite_" + Information.getInformation().getLocaleOrDefault().toString() + ".txt");
                html = html.replaceAll(":action_pfad:", this.getPfad());
                StringBuffer cbFwActivate = new StringBuffer();
                cbFwActivate.append("\t\t<input name=\"firewallActivate\" type=\"checkbox\"");
                cbFwActivate.append(" value=\"1\" size=\"30\" maxlength=\"40\"");
                if (this.firewall.isActivated()) {
                    cbFwActivate.append(" checked=\"checked\"");
                }
                cbFwActivate.append(" />");
                html = html.replaceAll(":firewallActivate:", cbFwActivate.toString());
                StringBuffer cbDropIcmp = new StringBuffer();
                cbDropIcmp.append("\t\t<input name=\"dropICMP\" type=\"checkbox\"");
                cbDropIcmp.append(" value=\"1\" size=\"30\" maxlength=\"40\"");
                if (this.firewall.getDropICMP()) {
                    cbDropIcmp.append(" checked=\"checked\"");
                }
                cbDropIcmp.append(" />");
                html = html.replaceAll(":dropICMP:", cbDropIcmp.toString());
                StringBuffer cbOnlySyn = new StringBuffer();
                cbOnlySyn.append("\t\t<input name=\"onlySYN\" type=\"checkbox\"");
                cbOnlySyn.append(" value=\"1\" size=\"30\" maxlength=\"40\"");
                if (this.firewall.getFilterSYNSegmentsOnly()) {
                    cbOnlySyn.append(" checked=\"checked\"");
                }
                cbOnlySyn.append(" />");
                html = html.replaceAll(":onlySYN:", cbOnlySyn.toString());
                if (this.firewall.getDefaultPolicy() == 1) {
                    html = html.replaceAll(":defPolDropSelected:", "");
                    html = html.replaceAll(":defPolAcceptSelected:", " selected=\"selected\"");
                } else {
                    html = html.replaceAll(":defPolAcceptSelected:", "");
                    html = html.replaceAll(":defPolDropSelected:", " selected=\"selected\"");
                }
                StringBuffer ruleTable = new StringBuffer();
                Vector<FirewallRule> ruleset = this.firewall.getRuleset();
                for (int i = 0; i < ruleset.size(); ++i) {
                    ruleTable.append("<tr>");
                    ruleTable.append("<td><input name=\"radioRule\" type=\"radio\"");
                    ruleTable.append(" value=\"");
                    ruleTable.append(i + 1);
                    ruleTable.append("\" size=\"10\" maxlength=\"40\"");
                    ruleTable.append(" />&nbsp;");
                    ruleTable.append(i + 1 + "</td>");
                    ruleTable.append("<td>" + ruleset.get((int)i).srcIP + "</td>");
                    ruleTable.append("<td>" + ruleset.get((int)i).srcMask + "</td>");
                    ruleTable.append("<td>" + ruleset.get((int)i).destIP + "</td>");
                    ruleTable.append("<td>" + ruleset.get((int)i).destMask + "</td>");
                    ruleTable.append("<td>");
                    if (ruleset.get((int)i).protocol == 6) {
                        ruleTable.append("TCP");
                    } else if (ruleset.get((int)i).protocol == 17) {
                        ruleTable.append("UDP");
                    }
                    ruleTable.append("</td>");
                    ruleTable.append("<td>");
                    if (ruleset.get((int)i).port >= 0) {
                        ruleTable.append(ruleset.get((int)i).port);
                    }
                    ruleTable.append("</td>");
                    ruleTable.append("<td>");
                    if (ruleset.get((int)i).action == 1) {
                        ruleTable.append(messages.getString("jfirewalldialog_msg33"));
                    } else {
                        ruleTable.append(messages.getString("jfirewalldialog_msg34"));
                    }
                    ruleTable.append("</td>");
                    ruleTable.append("</tr>");
                }
                html = html.replaceAll(":ruleset:", ruleTable.toString());
                if (this.errMsg.isEmpty()) {
                    html = html.replaceAll(":errorMsg:", "");
                    html = html.replaceAll(":srcIP:", "");
                    html = html.replaceAll(":srcMask:", "");
                    html = html.replaceAll(":destIP:", "");
                    html = html.replaceAll(":destMask:", "");
                    html = html.replaceAll(":port:", "");
                    html = html.replaceAll(":optionProtAll:", "");
                    html = html.replaceAll(":optionProtTCP:", "");
                    html = html.replaceAll(":optionProtUDP:", "");
                    html = html.replaceAll(":optionActionDrop:", "");
                    html = html.replaceAll(":optionActionAccept:", "");
                } else {
                    html = html.replaceAll(":errorMsg:", this.errMsg);
                    html = html.replaceAll(":srcIP:", this.srcIP);
                    html = html.replaceAll(":srcMask:", this.srcMask);
                    html = html.replaceAll(":destIP:", this.destIP);
                    html = html.replaceAll(":destMask:", this.destMask);
                    html = this.port > 0 ? html.replaceAll(":port:", this.portStr) : html.replaceAll(":port:", this.portStr);
                    if (this.protocol == -1) {
                        html = html.replaceAll(":optionProtAll:", " selected");
                        html = html.replaceAll(":optionProtTCP:", "");
                        html = html.replaceAll(":optionProtUDP:", "");
                    } else if (this.protocol == 6) {
                        html = html.replaceAll(":optionProtAll:", "");
                        html = html.replaceAll(":optionProtTCP:", " selected");
                        html = html.replaceAll(":optionProtUDP:", "");
                    } else if (this.protocol == 17) {
                        html = html.replaceAll(":optionProtAll:", "");
                        html = html.replaceAll(":optionProtTCP:", "");
                        html = html.replaceAll(":optionProtUDP:", " selected");
                    } else {
                        html = html.replaceAll(":optionProtAll:", "");
                        html = html.replaceAll(":optionProtTCP:", "");
                        html = html.replaceAll(":optionProtUDP:", "");
                    }
                    if (this.action == 0) {
                        html = html.replaceAll(":optionActionDrop:", " selected");
                        html = html.replaceAll(":optionActionAccept:", "");
                    } else if (this.action == 1) {
                        html = html.replaceAll(":optionActionDrop:", "");
                        html = html.replaceAll(":optionActionAccept:", " selected");
                    }
                }
            }
            catch (Exception f) {
                LOG.debug("", f);
                return null;
            }
            return html;
        }
        return null;
    }
}

