/*
 * Decompiled with CFR 0.152.
 */
package filius.software.firewall;

import filius.hardware.NetzwerkInterface;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.software.vermittlungsschicht.VermittlungsProtokoll;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FirewallRule {
    public static String SAME_NETWORK = "999.999.999.999";
    public static final short ALL_PROTOCOLS = -1;
    public static final short ICMP = 1;
    public static final short TCP = 6;
    public static final short UDP = 17;
    public static final int ALL_PORTS = -1;
    public static final short DROP = 0;
    public static final short ACCEPT = 1;
    public String srcIP = "";
    public String srcMask = "";
    public String destIP = "";
    public String destMask = "";
    public int port = -1;
    public short protocol = (short)6;
    public short action = 0;

    public FirewallRule(String srcIP, String srcMask, String destIP, String destMask, int port, short protocol, short action) {
        this.srcIP = srcIP;
        this.srcMask = srcMask;
        this.destIP = destIP;
        this.destMask = destMask;
        this.port = port;
        this.protocol = protocol;
        this.action = action;
    }

    public FirewallRule() {
    }

    public boolean validateExistingAttributes() {
        boolean result = true;
        if (StringUtils.isNoneBlank(this.srcIP) && !EingabenUeberpruefung.isGueltig(this.srcIP, EingabenUeberpruefung.musterIpAdresse) && !SAME_NETWORK.equals(this.srcIP)) {
            result = false;
        }
        if (StringUtils.isNoneBlank(this.srcMask) && !EingabenUeberpruefung.isValidSubnetmask(this.srcMask)) {
            result = false;
        }
        if (StringUtils.isNoneBlank(this.destIP) && !EingabenUeberpruefung.isGueltig(this.destIP, EingabenUeberpruefung.musterIpAdresse)) {
            result = false;
        }
        if (StringUtils.isNoneBlank(this.destMask) && !EingabenUeberpruefung.isValidSubnetmask(this.destMask)) {
            result = false;
        }
        if (this.port != -1 && !EingabenUeberpruefung.isGueltig(String.valueOf(this.port), EingabenUeberpruefung.musterPort)) {
            result = false;
        }
        if (this.protocol != 6 && this.protocol != 1 && this.protocol != 17 && this.protocol != -1) {
            result = false;
        }
        if (this.action != 0 && this.action != 1) {
            return false;
        }
        return result;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(List<NetzwerkInterface> nics) {
        String ip = null;
        String mask = null;
        String result = "";
        boolean sameNet = false;
        if (nics != null) {
            ip = nics.get(0).getIp();
            mask = nics.get(0).getSubnetzMaske();
            if (this.srcIP.equals(SAME_NETWORK) && ip != null && mask != null) {
                sameNet = true;
            }
        }
        result = StringUtils.isEmpty(this.srcIP) ? result + "*/" : (sameNet ? result + VermittlungsProtokoll.getSubnetForIp(ip, mask) + "/" + mask + " -> " : result + this.srcIP + "/");
        if (!sameNet) {
            result = StringUtils.isEmpty(this.srcMask) ? result + "* -> " : result + this.srcMask + " -> ";
        }
        result = StringUtils.isEmpty(this.destIP) ? result + "*/" : result + this.destIP + "/";
        result = StringUtils.isEmpty(this.destMask) ? result + "*; " : result + this.destMask + "; ";
        result = this.protocol >= 0 ? (this.protocol == 6 ? result + "TCP:" : (this.protocol == 17 ? result + "UDP:" : result + "?:")) : result + "*:";
        result = this.port >= 0 ? result + this.port + "  => " : result + "*  => ";
        result = this.action == 1 ? result + "ACCEPT" : (this.action == 0 ? result + "DROP" : result + this.action);
        return result;
    }
}

