/*
 * Decompiled with CFR 0.152.
 */
package filius.software.email;

import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.software.Anwendung;
import filius.software.email.Email;
import filius.software.email.EmailKonto;
import filius.software.email.EmailUtils;
import filius.software.email.Kontakt;
import filius.software.email.POP3Client;
import filius.software.email.SMTPClient;
import filius.software.system.Datei;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailAnwendung
extends Anwendung {
    private static Logger LOG = LoggerFactory.getLogger(EmailAnwendung.class);
    private Vector<Kontakt> adressbuch = new Vector();
    private List<Email> erstellteNachrichten = new ArrayList<Email>();
    private List<Email> empfangeneNachrichten = new ArrayList<Email>();
    private List<Email> gesendeteNachrichten = new ArrayList<Email>();
    private POP3Client pop3client;
    private SMTPClient smtpclient;
    private EmailKonto konto;

    @Override
    public void starten() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (EmailAnwendung), starten()");
        super.starten();
        this.pop3client = new POP3Client(this);
        this.pop3client.starten();
        this.smtpclient = new SMTPClient(this);
        this.smtpclient.starten();
    }

    @Override
    public void beenden() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (EmailAnwendung), beenden()");
        super.beenden();
        if (this.pop3client != null) {
            this.pop3client.beenden();
        }
        if (this.smtpclient != null) {
            this.smtpclient.beenden();
        }
    }

    public void versendeEmail(String remoteServerIP, Email email, String absender) {
        String rcpts = EmailUtils.addressEntryListToString(email.getEmpfaenger());
        if (email.getCc().size() > 0) {
            rcpts = rcpts + ",";
            rcpts = rcpts + EmailUtils.addressEntryListToString(email.getCc());
        }
        if (email.getBcc().size() > 0) {
            rcpts = rcpts + ",";
            rcpts = rcpts + EmailUtils.addressEntryListToString(email.getBcc());
        }
        this.smtpclient.versendeEmail(remoteServerIP, email, absender, rcpts);
    }

    public void emailsAbholenEmails(String benutzername, String passwort, String pop3Port, String pop3Server) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (EmailAnwendung), emailsAbholenEmails(" + benutzername + "," + passwort + "," + pop3Port + "," + pop3Server + ")");
        this.pop3client.emailsHolen(pop3Server, pop3Port, benutzername, passwort);
    }

    public boolean kontaktHinzufuegen(String name, String vorname, String strasse, int hausnr, int plz, String wohnort, String email, String telefon) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (EmailAnwendung), kontaktHinzufuegen(" + name + "," + vorname + "," + strasse + "," + hausnr + "," + plz + "," + wohnort + "," + email + "," + telefon + ")");
        if (EingabenUeberpruefung.isGueltig(name, EingabenUeberpruefung.musterMindEinZeichen) && EingabenUeberpruefung.isGueltig(vorname, EingabenUeberpruefung.musterMindEinZeichen) && EingabenUeberpruefung.isGueltig(email, EingabenUeberpruefung.musterEmailAdresse)) {
            try {
                Kontakt kontaktNeu = new Kontakt();
                kontaktNeu.setName(name);
                kontaktNeu.setVorname(vorname);
                kontaktNeu.setStrasse(strasse);
                kontaktNeu.setHausnr(hausnr);
                kontaktNeu.setPlz(plz);
                kontaktNeu.setWohnort(wohnort);
                kontaktNeu.setEmail(email);
                kontaktNeu.setTelefon(telefon);
                this.getAdressbuch().add(kontaktNeu);
            }
            catch (Exception e) {
                LOG.debug("", e);
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean kontaktLoeschen(String name, String vorname, String email) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (EmailAnwendung), kontaktLoeschen(" + name + "," + vorname + "," + email + ")");
        if (EingabenUeberpruefung.isGueltig(name, EingabenUeberpruefung.musterMindEinZeichen) && EingabenUeberpruefung.isGueltig(vorname, EingabenUeberpruefung.musterMindEinZeichen) && EingabenUeberpruefung.isGueltig(email, EingabenUeberpruefung.musterEmailAdresse)) {
            for (Kontakt kontakt : this.adressbuch) {
                if (!email.equalsIgnoreCase(kontakt.getEmail()) || !name.equals(kontakt.getName()) || !vorname.equals(kontakt.getVorname())) continue;
                this.adressbuch.remove(kontakt);
                return true;
            }
        }
        return false;
    }

    public void speichern() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (EmailAnwendung), speichern()");
        Datei datei = new Datei();
        datei.setDateiInhalt(this.konto.toString());
        datei.setName("konten.txt");
        datei.setDateiTyp("text/txt");
        this.getSystemSoftware().getDateisystem().speicherDatei(this.getSystemSoftware().getDateisystem().getRoot(), datei);
    }

    public void laden() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (EmailAnwendung), laden()");
        Datei datei = this.getSystemSoftware().getDateisystem().holeDatei(this.getSystemSoftware().getDateisystem().getRoot(), "konten.txt");
        if (datei != null) {
            String kontenString = datei.getDateiInhalt();
            String[] konten = kontenString.split("\n");
            for (int i = 0; i < konten.length; ++i) {
                this.konto = new EmailKonto(konten[i]);
            }
        }
    }

    public POP3Client holePOP3Client() {
        return this.pop3client;
    }

    public Vector<Kontakt> getAdressbuch() {
        return this.adressbuch;
    }

    public void setAdressbuch(Vector<Kontakt> adressbuch) {
        this.adressbuch = adressbuch;
    }

    public List<Email> getEmpfangeneNachrichten() {
        return this.empfangeneNachrichten;
    }

    public void removeReceivedMail(int index) {
        if (this.empfangeneNachrichten.size() > index && 0 <= index) {
            this.empfangeneNachrichten.remove(index);
        }
    }

    public void setEmpfangeneNachrichten(List<Email> empfangeneNachrichten) {
        this.empfangeneNachrichten = empfangeneNachrichten;
    }

    public List<Email> getErstellteNachrichten() {
        return this.erstellteNachrichten;
    }

    public void setErstellteNachrichten(List<Email> erstellteNachrichten) {
        this.erstellteNachrichten = erstellteNachrichten;
    }

    public List<Email> getGesendeteNachrichten() {
        return this.gesendeteNachrichten;
    }

    public void addGesendeteNachricht(Email gesendeteNachricht) {
        if (!this.gesendeteNachrichten.contains(gesendeteNachricht)) {
            this.gesendeteNachrichten.add(gesendeteNachricht);
        }
    }

    public void removeSentMail(int index) {
        if (this.gesendeteNachrichten.size() > index && 0 <= index) {
            this.gesendeteNachrichten.remove(index);
        }
    }

    public void setGesendeteNachrichten(List<Email> gesendeteNachrichten) {
        this.gesendeteNachrichten = gesendeteNachrichten;
    }

    public Map<String, EmailKonto> holeKontoListe() {
        if (this.konto != null) {
            return Collections.singletonMap(this.konto.getBenutzername(), this.konto);
        }
        return Collections.emptyMap();
    }

    public void setzeKonto(EmailKonto konto) {
        this.konto = konto;
    }

    public void setzeKontoListe(Map<String, EmailKonto> kontoListe) {
        if (!kontoListe.isEmpty()) {
            this.konto = kontoListe.values().toArray(new EmailKonto[kontoListe.size()])[0];
        }
    }
}

