/*
 * Decompiled with CFR 0.152.
 */
package filius.software.email;

import filius.software.email.AddressEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Email
implements Serializable {
    private static Logger LOG = LoggerFactory.getLogger(Email.class);
    private AddressEntry absender;
    private List<AddressEntry> empfaenger = new ArrayList<AddressEntry>();
    private List<AddressEntry> cc = new ArrayList<AddressEntry>();
    private List<AddressEntry> bcc = new ArrayList<AddressEntry>();
    private String betreff;
    private String text = "";
    private boolean neu = true;
    private String dateReceived = "";
    private boolean delete = false;
    private boolean versendet = false;

    public Email() {
    }

    public Email(String nachricht) {
        String[] emaildaten = nachricht.split("\n");
        boolean header = true;
        for (int i = 0; i < emaildaten.length; ++i) {
            String fieldData;
            String fieldName;
            int pos1 = 0;
            int pos2 = emaildaten[i].indexOf(":");
            if (pos2 > pos1) {
                fieldName = emaildaten[i].substring(pos1, pos2).trim();
                fieldData = emaildaten[i].substring(pos2 + 1).trim();
            } else {
                fieldName = null;
                fieldData = null;
            }
            if (header) {
                int j;
                String[] liste;
                if ("from".equalsIgnoreCase(fieldName)) {
                    this.absender = new AddressEntry(fieldData);
                    continue;
                }
                if ("to".equalsIgnoreCase(fieldName)) {
                    this.empfaenger.clear();
                    liste = fieldData.split(",");
                    for (j = 0; j < liste.length; ++j) {
                        this.empfaenger.add(new AddressEntry(liste[j]));
                    }
                    continue;
                }
                if ("cc".equalsIgnoreCase(fieldName)) {
                    this.cc.clear();
                    liste = fieldData.split(",");
                    for (j = 0; j < liste.length; ++j) {
                        this.cc.add(new AddressEntry(liste[j]));
                    }
                    continue;
                }
                if ("bcc".equalsIgnoreCase(fieldName)) {
                    this.bcc.clear();
                    liste = fieldData.split(",");
                    for (j = 0; j < liste.length; ++j) {
                        this.bcc.add(new AddressEntry(liste[j]));
                    }
                    continue;
                }
                if ("subject".equalsIgnoreCase(fieldName)) {
                    this.betreff = fieldData;
                    continue;
                }
                if (!this.text.equals("")) continue;
                header = false;
                continue;
            }
            this.text = this.text + emaildaten[i] + "\n";
        }
    }

    public String toString() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (Email), toString()");
        String toListe = "";
        String ccListe = "";
        toListe = this.holeEmpfaengerListe();
        for (AddressEntry rcpt : this.cc) {
            ccListe = ccListe + ((Object)rcpt).toString() + ", ";
        }
        if (!ccListe.isEmpty()) {
            ccListe = ccListe.substring(0, ccListe.length() - 2);
        }
        String ergebnis = "";
        if (this.absender != null) {
            ergebnis = ergebnis + "From: " + this.absender.toString() + "\n";
        }
        if (!toListe.equals("")) {
            ergebnis = ergebnis + "To: " + toListe + "\n";
        }
        if (!ccListe.equals("")) {
            ergebnis = ergebnis + "Cc: " + ccListe + "\n";
        }
        if (this.betreff != null) {
            ergebnis = ergebnis + "Subject: " + this.betreff.trim() + "\n";
        }
        if (!this.dateReceived.equals("")) {
            ergebnis = ergebnis + "Date Received: " + this.dateReceived + "\n";
        }
        if (this.text != null) {
            ergebnis = ergebnis + "\n" + this.text.trim();
        }
        return ergebnis;
    }

    public String holeEmpfaengerListe() {
        String toListe = "";
        for (AddressEntry rcpt : this.empfaenger) {
            toListe = toListe + ((Object)rcpt).toString() + ", ";
        }
        if (!toListe.isEmpty()) {
            toListe = toListe.substring(0, toListe.length() - 2);
        }
        return toListe;
    }

    public boolean getDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public boolean getNeu() {
        return this.neu;
    }

    public void setNeu(boolean neu) {
        this.neu = neu;
    }

    public AddressEntry getAbsender() {
        return new AddressEntry(this.absender);
    }

    public List<AddressEntry> getEmpfaenger() {
        return this.empfaenger;
    }

    public String getBetreff() {
        return this.betreff;
    }

    public String getText() {
        return this.text;
    }

    public void setAbsender(String absender) {
        this.absender = new AddressEntry(absender);
    }

    public void setAbsender(AddressEntry absender) {
        this.absender = absender;
    }

    public void setBetreff(String betreff) {
        this.betreff = betreff;
    }

    public void setEmpfaenger(List<AddressEntry> empfaenger) {
        this.empfaenger = empfaenger;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getDateReceived() {
        return this.dateReceived;
    }

    public void setDateReceived(String dateReceived) {
        this.dateReceived = dateReceived;
    }

    public boolean isVersendet() {
        return this.versendet;
    }

    public void setVersendet(boolean versendet) {
        this.versendet = versendet;
    }

    public List<AddressEntry> getBcc() {
        return this.bcc;
    }

    public void setBcc(List<AddressEntry> bcc) {
        this.bcc = bcc;
    }

    public List<AddressEntry> getCc() {
        return this.cc;
    }

    public void setCc(List<AddressEntry> cc) {
        this.cc = cc;
    }
}

