/*
 * Decompiled with CFR 0.152.
 */
package filius.software.dns;

import filius.rahmenprogramm.EingabenUeberpruefung;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRecord {
    private static Logger LOG = LoggerFactory.getLogger(ResourceRecord.class);
    public static final String ADDRESS = "A";
    public static final String MAIL_EXCHANGE = "MX";
    public static final String NAME_SERVER = "NS";
    public static ResourceRecord LOCALHOST_ADDRESS = new ResourceRecord("localhost", "A", "127.0.0.1");
    private String domainname = "";
    private String type = "A";
    private int ttl = 3600;
    private String rdata = "";

    public ResourceRecord(String domainname, String typ, String rdata) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (ResourceRecord), constr: ResourceRecord(" + domainname + "," + typ + "," + rdata + ")");
        this.setDomainname(domainname);
        this.type = typ;
        this.setRdata(rdata);
    }

    public ResourceRecord(String rr) {
        String token;
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (ResourceRecord), constr: ResourceRecord(" + rr + ")");
        StringTokenizer tokenizer = new StringTokenizer(rr, " ");
        if (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken().trim();
            this.setDomainname(token);
        }
        if (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken().trim();
            this.setType(token);
        }
        if (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken().trim();
            try {
                this.setTtl(Integer.parseInt(token));
            }
            catch (NumberFormatException e) {
                LOG.debug("EXCEPTION: NumberFormatException, TTL field: '" + token + "'");
                LOG.debug("", e);
            }
        }
        if (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken().trim();
            this.setRdata(token);
        }
    }

    public String toString() {
        return this.getDomainname() + " " + this.type + " " + this.ttl + " " + this.getRdata();
    }

    public String getDomainname() {
        return this.domainname;
    }

    public void setDomainname(String domainname) {
        if (EingabenUeberpruefung.isGueltig(domainname, EingabenUeberpruefung.musterDomain)) {
            this.domainname = domainname.matches(".*\\.$") ? domainname : domainname + ".";
        }
    }

    public String getRdata() {
        if ((this.type.equals(NAME_SERVER) || this.type.equals(MAIL_EXCHANGE)) && !this.rdata.matches(".*\\.")) {
            return this.rdata + ".";
        }
        return this.rdata;
    }

    public void setRdata(String rdata) {
        this.rdata = (this.type.equals(NAME_SERVER) || this.type.equals(MAIL_EXCHANGE)) && !rdata.matches(".*\\.") ? rdata + "." : rdata;
    }

    public static ResourceRecord findRecord(String domainname, String typ, List<ResourceRecord> recordList) {
        for (ResourceRecord rr : recordList) {
            if (!rr.getDomainname().equalsIgnoreCase(domainname) || !rr.getType().equals(typ)) continue;
            return rr;
        }
        return null;
    }

    public static List<ResourceRecord> findRecords(String domainname, String typ, List<ResourceRecord> recordList) {
        ArrayList<ResourceRecord> matchingRecords = new ArrayList<ResourceRecord>();
        for (ResourceRecord rr : recordList) {
            if (!rr.getDomainname().equalsIgnoreCase(domainname) || !rr.getType().equals(typ)) continue;
            matchingRecords.add(rr);
        }
        return matchingRecords;
    }

    public static ResourceRecord findApplicableNSRecord(String domainname, List<ResourceRecord> recordList) {
        String[] parts = domainname.split("\\.");
        for (int i = 0; i < parts.length; ++i) {
            String domain = ResourceRecord.implodeDomain(parts, i);
            for (ResourceRecord rr : recordList) {
                if (!domain.equalsIgnoreCase(rr.getDomainname()) || !NAME_SERVER.equals(rr.getType())) continue;
                return rr;
            }
        }
        for (ResourceRecord rr : recordList) {
            if (!".".equalsIgnoreCase(rr.getDomainname()) || !NAME_SERVER.equals(rr.getType())) continue;
            return rr;
        }
        return null;
    }

    private static String implodeDomain(String[] parts, int start) {
        StringBuffer domain = new StringBuffer();
        for (int i = start; i < parts.length; ++i) {
            domain.append(parts[i]);
            domain.append(".");
        }
        return domain.toString();
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

