/*
 * Decompiled with CFR 0.152.
 */
package filius.software.dns;

import filius.exception.TimeOutException;
import filius.software.clientserver.ClientAnwendung;
import filius.software.dns.DNSNachricht;
import filius.software.dns.DNSQueryAgent;
import filius.software.dns.ResourceRecord;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resolver
extends ClientAnwendung {
    private static Logger LOG = LoggerFactory.getLogger(Resolver.class);
    private static Pattern LOCALHOST_PATTERN = Pattern.compile("localhost\\.?", 2);
    private DNSQueryAgent queryAgent = new DNSQueryAgent();

    public String holeIPAdresse(String domainname) throws TimeOutException {
        return this.holeIPAdresse(domainname, this.getSystemSoftware().getDNSServer());
    }

    public String holeIPAdresse(String domainname, String dnsServer) throws TimeOutException {
        DNSNachricht data;
        ResourceRecord rr;
        if (!domainname.matches(".*\\.$")) {
            domainname = domainname + ".";
        }
        return null != (rr = ResourceRecord.findRecord(domainname, "A", (data = this.resolveA(domainname, dnsServer)).holeResourceRecords())) ? rr.getRdata() : null;
    }

    public DNSNachricht resolveA(String domainname, String dnsServer) throws TimeOutException {
        return this.resolve(domainname, "A", dnsServer);
    }

    public DNSNachricht resolveA(String domainname) throws TimeOutException {
        return this.resolve(domainname, "A", this.getSystemSoftware().getDNSServer());
    }

    public String holeIPAdresseMailServer(String domainname) throws TimeOutException {
        List<ResourceRecord> dataRecords;
        ResourceRecord mxRecord;
        if (!domainname.matches(".*\\.$")) {
            domainname = domainname + ".";
        }
        ResourceRecord aRecord = null == (mxRecord = ResourceRecord.findRecord(domainname, "MX", dataRecords = this.resolveMX(domainname, this.getSystemSoftware().getDNSServer()).holeResourceRecords())) ? null : ResourceRecord.findRecord(mxRecord.getRdata(), "A", dataRecords);
        return aRecord == null ? null : aRecord.getRdata();
    }

    protected List<ResourceRecord> extractRankedResourceRecordList(DNSNachricht antwort, String type, String domainname) {
        ArrayList<ResourceRecord> relevantResourceRecords = new ArrayList<ResourceRecord>();
        if (antwort != null) {
            relevantResourceRecords.addAll(this.extractResourceRecords(antwort.holeAntwortResourceRecords(), type, domainname));
            relevantResourceRecords.addAll(this.extractResourceRecords(antwort.holeAuthoritativeResourceRecords(), type, domainname));
            relevantResourceRecords.addAll(this.extractResourceRecords(antwort.holeZusatzResourceRecords(), type, domainname));
        }
        return relevantResourceRecords;
    }

    public DNSNachricht resolveMX(String domainname) throws TimeOutException {
        return this.resolve(domainname, "MX", this.getSystemSoftware().getDNSServer());
    }

    public DNSNachricht resolveMX(String domainname, String dnsServerAddress) throws TimeOutException {
        return this.resolve(domainname, "MX", dnsServerAddress);
    }

    public DNSNachricht resolve(String domainname, String type, String dnsServerAddress) throws TimeOutException {
        DNSNachricht remoteResponse;
        if (!domainname.matches(".*\\.$")) {
            domainname = domainname + ".";
        }
        DNSNachricht response = new DNSNachricht(1);
        String serverToQuery = null;
        if (LOCALHOST_PATTERN.matcher(domainname).matches()) {
            response.setLocal();
            response.hinzuAntwortResourceRecord(ResourceRecord.LOCALHOST_ADDRESS);
        } else {
            serverToQuery = dnsServerAddress;
        }
        HashSet<String> queriedDnsServer = new HashSet<String>();
        while (serverToQuery != null && (remoteResponse = this.queryAgent.query(type, domainname, serverToQuery, this.getSystemSoftware())) != null) {
            this.copyResourceRecords(remoteResponse, response, domainname, type);
            List<ResourceRecord> data = this.extractRankedResourceRecordList(remoteResponse, type, domainname);
            if (!data.isEmpty()) {
                if (!"MX".equals(type) && !"NS".equals(type)) break;
                this.copyResourceRecords(remoteResponse, response, data.get(0).getRdata(), "A");
                break;
            }
            String nextServerToQuery = this.extractAddressForNameServer(remoteResponse.holeResourceRecords(), domainname);
            serverToQuery = queriedDnsServer.add(nextServerToQuery) ? nextServerToQuery : null;
        }
        LOG.debug("resolved dns query for {} {}: {}", domainname, type, response.holeResourceRecords());
        return response;
    }

    private void copyResourceRecords(DNSNachricht source, DNSNachricht target, String domainname, String type) {
        target.hinzuAntwortResourceRecords(this.extractResourceRecords(source.holeAntwortResourceRecords(), type, domainname));
        target.hinzuAuthoritativeResourceRecords(this.extractResourceRecords(source.holeAuthoritativeResourceRecords(), type, domainname));
    }

    public DNSNachricht resolveNS(String domainname) throws TimeOutException {
        return this.resolve(domainname, "NS", this.getSystemSoftware().getDNSServer());
    }

    protected String extractAddressForNameServer(List<ResourceRecord> rrList, String domain) {
        ResourceRecord aRecord;
        String dnsServerAddress = null;
        ResourceRecord nsRecord = ResourceRecord.findApplicableNSRecord(domain, rrList);
        if (null != nsRecord && null != (aRecord = ResourceRecord.findRecord(nsRecord.getRdata(), "A", rrList))) {
            dnsServerAddress = aRecord.getRdata();
        }
        return dnsServerAddress;
    }

    protected List<ResourceRecord> extractResourceRecords(List<ResourceRecord> liste, String typ, String domainname) {
        ArrayList<ResourceRecord> relevantRR = new ArrayList<ResourceRecord>();
        for (ResourceRecord rr : liste) {
            if (!rr.getDomainname().equalsIgnoreCase(domainname) || !rr.getType().equals(typ)) continue;
            relevantRR.add(rr);
        }
        return relevantRR;
    }
}

