/*
 * Decompiled with CFR 0.152.
 */
package filius.software.dns;

import filius.exception.TimeOutException;
import filius.software.clientserver.UDPServerAnwendung;
import filius.software.dns.DNSNachricht;
import filius.software.dns.DNSServerMitarbeiter;
import filius.software.dns.Query;
import filius.software.dns.Resolver;
import filius.software.dns.ResourceRecord;
import filius.software.system.Datei;
import filius.software.system.Dateisystem;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.transportschicht.Socket;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNSServer
extends UDPServerAnwendung {
    private static Logger LOG = LoggerFactory.getLogger(DNSServer.class);
    private boolean recursiveResolutionEnabled = false;
    private Resolver resolver;

    public boolean isRecursiveResolutionEnabled() {
        return this.recursiveResolutionEnabled;
    }

    public void setRecursiveResolutionEnabled(boolean recursiveResolutionEnabled) {
        this.recursiveResolutionEnabled = recursiveResolutionEnabled;
    }

    public DNSServer() {
        LOG.trace("INVOKED-2 (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (DNSServer), constr: DNSServer()");
        this.setPort(53);
    }

    @Override
    public void setSystemSoftware(InternetKnotenBetriebssystem bs) {
        super.setSystemSoftware(bs);
        this.resolver = bs.holeDNSClient();
    }

    @Override
    public void starten() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (DNSServer), starten()");
        super.starten();
        Dateisystem dateisystem = this.getSystemSoftware().getDateisystem();
        if (!dateisystem.dateiVorhanden("/dns", "hosts")) {
            dateisystem.erstelleVerzeichnis(dateisystem.getRoot(), "dns");
            Datei hostsFile = new Datei();
            hostsFile.setName("hosts");
            hostsFile.setDateiInhalt("");
            dateisystem.speicherDatei("/dns", hostsFile);
        }
    }

    @Override
    public void beenden() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (DNSServer), beenden()");
        super.beenden();
    }

    public List<ResourceRecord> holeResourceRecords() {
        return this.leseRecordListe();
    }

    public void hinzuRecord(String domainname, String typ, String rdata) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (DNSServer), hinzuRecord(" + domainname + "," + typ + "," + rdata + ")");
        ResourceRecord rr = new ResourceRecord(domainname, typ, rdata);
        List<ResourceRecord> rrList = this.leseRecordListe();
        rrList.add(rr);
        this.schreibeRecordListe(rrList);
    }

    private List<ResourceRecord> leseRecordListe() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + ", initialisiereRecordListe()");
        Dateisystem dateisystem = this.getSystemSoftware().getDateisystem();
        Datei hosts = dateisystem.holeDatei("/dns/hosts");
        LinkedList<ResourceRecord> resourceRecords = new LinkedList<ResourceRecord>();
        if (hosts != null) {
            StringTokenizer tokenizer = new StringTokenizer(hosts.getDateiInhalt(), "\n");
            while (tokenizer.hasMoreTokens()) {
                String line = tokenizer.nextToken().trim();
                if (line.equals("") || line.split(" ", 5).length < 4) continue;
                ResourceRecord rr = new ResourceRecord(line);
                resourceRecords.add(rr);
            }
        }
        return resourceRecords;
    }

    private void schreibeRecordListe(List<ResourceRecord> records) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (DNSServer), schreibeRecordListe()");
        StringBuffer text = new StringBuffer();
        for (ResourceRecord resourceRecord : records) {
            text.append(resourceRecord.toString() + "\n");
        }
        Dateisystem dateisystem = this.getSystemSoftware().getDateisystem();
        Datei hostsFile = dateisystem.holeDatei(dateisystem.holeRootPfad() + "/" + "dns", "hosts");
        if (hostsFile == null) {
            hostsFile = new Datei();
            hostsFile.setName("hosts");
            dateisystem.erstelleVerzeichnis(dateisystem.getRoot(), "dns");
            dateisystem.speicherDatei(dateisystem.holeRootPfad() + "/" + "dns", hostsFile);
        }
        hostsFile.setDateiInhalt(text.toString());
    }

    public void changeSingleEntry(int recordIdx, int partIdx, String type, String newValue) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", changeSingleEntry(" + recordIdx + "," + partIdx + "," + type + "," + newValue + ")");
        List<ResourceRecord> rrList = this.leseRecordListe();
        int countA = 0;
        for (ResourceRecord rrec : rrList) {
            if (rrec.getType().equals(type)) {
                ++countA;
            }
            if (countA - 1 != recordIdx) continue;
            if (partIdx == 0) {
                rrec.setDomainname(newValue);
                continue;
            }
            if (partIdx != 3) continue;
            rrec.setRdata(newValue);
        }
        this.schreibeRecordListe(rrList);
        this.benachrichtigeBeobachter(type);
    }

    public DNSNachricht answer(Query query) {
        this.benachrichtigeBeobachter(messages.getString("sw_dnsservermitarbeiter_msg1") + query);
        DNSNachricht antwort = new DNSNachricht(1);
        antwort.hinzuAntwortResourceRecords(this.answerWithLocalData(query));
        if (antwort.holeAntwortResourceRecords().isEmpty() && this.isRecursiveResolutionEnabled()) {
            antwort.hinzuAntwortResourceRecords(this.answerWithRemoteData(query));
        }
        if (antwort.holeAntwortResourceRecords().isEmpty()) {
            antwort.hinzuAntwortResourceRecords(this.defineNameserverRecords(query));
        }
        return antwort;
    }

    private List<ResourceRecord> defineNameserverRecords(Query query) {
        ArrayList<ResourceRecord> answerResourceRecords = new ArrayList<ResourceRecord>();
        List<ResourceRecord> records = this.leseRecordListe();
        ResourceRecord nameserverNSRecord = ResourceRecord.findApplicableNSRecord(query.holeDomainname(), records);
        if (null != nameserverNSRecord) {
            answerResourceRecords.add(nameserverNSRecord);
            ResourceRecord nameserverARecord = ResourceRecord.findRecord(nameserverNSRecord.getRdata(), "A", records);
            if (null != nameserverARecord) {
                answerResourceRecords.add(nameserverARecord);
            }
        }
        return answerResourceRecords;
    }

    List<ResourceRecord> answerWithRemoteData(Query query) {
        String dnsServerAddress;
        ResourceRecord addressNsRecord;
        ArrayList<ResourceRecord> answerResourceRecords = new ArrayList<ResourceRecord>();
        List<ResourceRecord> recordList = this.leseRecordListe();
        ResourceRecord nsRecord = ResourceRecord.findApplicableNSRecord(query.holeDomainname(), recordList);
        if (null != nsRecord && null != (addressNsRecord = ResourceRecord.findRecord(nsRecord.getRdata(), "A", recordList))) {
            dnsServerAddress = addressNsRecord.getRdata();
            answerResourceRecords.addAll(this.resolveWithNameserver(query, dnsServerAddress));
        }
        if (answerResourceRecords.isEmpty() && !this.getSystemSoftware().getDNSServer().equals(this.getSystemSoftware().primaryIPAdresse())) {
            dnsServerAddress = this.getSystemSoftware().getDNSServer();
            answerResourceRecords.addAll(this.resolveWithNameserver(query, dnsServerAddress));
        }
        return answerResourceRecords;
    }

    private List<ResourceRecord> resolveWithNameserver(Query query, String dnsServerAddress) {
        ArrayList<ResourceRecord> answerResourceRecords = new ArrayList<ResourceRecord>();
        if (StringUtils.isNoneBlank(dnsServerAddress)) {
            try {
                DNSNachricht remoteResponse = this.resolver.resolve(query.holeDomainname(), query.holeTyp(), dnsServerAddress);
                answerResourceRecords.addAll(remoteResponse.holeAntwortResourceRecords());
                answerResourceRecords.addAll(remoteResponse.holeAuthoritativeResourceRecords());
            }
            catch (TimeOutException e) {
                LOG.debug("Could not retrieve answer for DNS query: " + query, e);
            }
        }
        return answerResourceRecords;
    }

    List<ResourceRecord> answerWithLocalData(Query query) {
        ArrayList<ResourceRecord> answerResourceRecords = new ArrayList<ResourceRecord>();
        List<ResourceRecord> recordList = this.leseRecordListe();
        List<ResourceRecord> matchingRecordList = ResourceRecord.findRecords(query.holeDomainname(), query.holeTyp(), recordList);
        for (ResourceRecord responseRecord : matchingRecordList) {
            ResourceRecord addressForMxOrNsRecord;
            answerResourceRecords.add(responseRecord);
            if (!responseRecord.getType().equals("MX") && !responseRecord.getType().equals("NS") || (addressForMxOrNsRecord = ResourceRecord.findRecord(responseRecord.getRdata(), "A", recordList)) == null) continue;
            answerResourceRecords.add(addressForMxOrNsRecord);
        }
        return answerResourceRecords;
    }

    public void loescheResourceRecord(String domainname, String typ) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (DNSServer), loescheResourceRecord(" + domainname + "," + typ + ")");
        List<ResourceRecord> rrList = this.leseRecordListe();
        for (ResourceRecord rr : rrList) {
            if (!rr.getDomainname().equalsIgnoreCase(domainname) || !rr.getType().equals(typ)) continue;
            rrList.remove(rr);
            break;
        }
        this.schreibeRecordListe(rrList);
    }

    @Override
    protected void neuerMitarbeiter(Socket socket) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (DNSServer), neuerMitarbeiter(" + socket + ")");
        DNSServerMitarbeiter dnsMitarbeiter = new DNSServerMitarbeiter(this, socket);
        dnsMitarbeiter.starten();
        this.mitarbeiter.add(dnsMitarbeiter);
    }
}

