/*
 * Decompiled with CFR 0.152.
 */
package filius.software.dns;

import filius.software.dns.Query;
import filius.software.dns.ResourceRecord;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNSNachricht {
    private static Logger LOG = LoggerFactory.getLogger(DNSNachricht.class);
    public static final int QUERY = 0;
    public static final int RESPONSE = 1;
    public static final int NO_ERROR = 0;
    public static final int FORMAT_ERROR = 1;
    public static final int SERVER_FAILURE = 2;
    public static final int NAME_ERROR = 3;
    public static final int NOT_IMPLEMENTED = 4;
    public static final int REFUSED = 5;
    private int id = (int)(Math.random() * 65536.0);
    private boolean isLocal = false;
    private int queryResponse = 0;
    private int opcode = 0;
    private boolean authoritativeAnswer = false;
    private boolean truncated = false;
    private boolean recursionDesired = true;
    private boolean recursionAvailable = true;
    private int responseCode = 0;
    private int queryCount = 0;
    private int answerCount = 0;
    private int authoritativeAnswerCount = 0;
    private int additionalCount = 0;
    private LinkedList<Query> queries = new LinkedList();
    private LinkedList<ResourceRecord> answerRecords = new LinkedList();
    private LinkedList<ResourceRecord> authoratativeRecords = new LinkedList();
    private LinkedList<ResourceRecord> additionalRecords = new LinkedList();

    public DNSNachricht(int queryResponse) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", DNSNachricht(" + queryResponse + ")");
        this.queryResponse = queryResponse;
    }

    public DNSNachricht(String nachricht) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (DNSNachricht), constr: DNSNachricht(" + nachricht + ")");
        if (nachricht != null) {
            int i;
            StringTokenizer lineTokenizer = new StringTokenizer(nachricht, "\n");
            String line = lineTokenizer.nextToken();
            StringTokenizer tokenizer = new StringTokenizer(line, " ");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                if (token.startsWith("ID")) {
                    this.id = Integer.parseInt(token.substring(3));
                    continue;
                }
                if (token.startsWith("QR")) {
                    this.queryResponse = Integer.parseInt(token.substring(3));
                    continue;
                }
                if (token.startsWith("RCODE")) {
                    this.responseCode = Integer.parseInt(token.substring(6));
                    continue;
                }
                if (token.startsWith("QDCOUNT")) {
                    this.queryCount = Integer.parseInt(token.substring(8));
                    continue;
                }
                if (token.startsWith("ANCOUNT")) {
                    this.answerCount = Integer.parseInt(token.substring(8));
                    continue;
                }
                if (token.startsWith("NSCOUNT")) {
                    this.authoritativeAnswerCount = Integer.parseInt(token.substring(8));
                    continue;
                }
                if (!token.startsWith("ARCOUNT")) continue;
                this.additionalCount = Integer.parseInt(token.substring(8));
            }
            for (i = 0; i < this.queryCount && lineTokenizer.hasMoreTokens(); ++i) {
                line = lineTokenizer.nextToken();
                this.queries.add(new Query(line));
            }
            for (i = 0; i < this.answerCount && lineTokenizer.hasMoreTokens(); ++i) {
                line = lineTokenizer.nextToken();
                this.answerRecords.add(new ResourceRecord(line));
            }
            for (i = 0; i < this.authoritativeAnswerCount && lineTokenizer.hasMoreTokens(); ++i) {
                line = lineTokenizer.nextToken();
                this.authoratativeRecords.add(new ResourceRecord(line));
            }
            for (i = 0; i < this.additionalCount && lineTokenizer.hasMoreTokens(); ++i) {
                line = lineTokenizer.nextToken();
                this.additionalRecords.add(new ResourceRecord(line));
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ID=" + this.id + " ");
        buffer.append("QR=" + this.queryResponse + " ");
        buffer.append("RCODE=" + this.responseCode + " ");
        buffer.append("QDCOUNT=" + this.queryCount + " ");
        buffer.append("ANCOUNT=" + this.answerCount + " ");
        buffer.append("NSCOUNT=" + this.authoritativeAnswerCount + " ");
        buffer.append("ARCOUNT=" + this.additionalCount + " ");
        buffer.append("\n");
        ListIterator it = this.queries.listIterator();
        while (it.hasNext()) {
            buffer.append(it.next().toString() + "\n");
        }
        it = this.answerRecords.listIterator();
        while (it.hasNext()) {
            buffer.append(it.next().toString() + "\n");
        }
        it = this.authoratativeRecords.listIterator();
        while (it.hasNext()) {
            buffer.append(it.next().toString() + "\n");
        }
        it = this.additionalRecords.listIterator();
        while (it.hasNext()) {
            buffer.append(it.next().toString() + "\n");
        }
        return buffer.toString();
    }

    public void hinzuQuery(String anfrage) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (DNSNachricht), hinzuQuery(" + anfrage + ")");
        this.queries.add(new Query(anfrage));
        ++this.queryCount;
    }

    public LinkedList<Query> holeQueries() {
        return this.queries;
    }

    public LinkedList<ResourceRecord> holeAntwortResourceRecords() {
        return this.answerRecords;
    }

    public LinkedList<ResourceRecord> holeAuthoritativeResourceRecords() {
        return this.authoratativeRecords;
    }

    public LinkedList<ResourceRecord> holeZusatzResourceRecords() {
        return this.additionalRecords;
    }

    public List<ResourceRecord> holeResourceRecords() {
        ArrayList<ResourceRecord> list = new ArrayList<ResourceRecord>();
        list.addAll(this.answerRecords);
        list.addAll(this.authoratativeRecords);
        list.addAll(this.additionalRecords);
        return list;
    }

    public void hinzuAntwortResourceRecord(String record) {
        this.hinzuAntwortResourceRecord(new ResourceRecord(record));
    }

    public void hinzuAntwortResourceRecords(List<ResourceRecord> rrList) {
        this.answerRecords.addAll(rrList);
        this.answerCount += rrList.size();
    }

    public void hinzuAntwortResourceRecord(ResourceRecord rr) {
        this.answerRecords.add(rr);
        ++this.answerCount;
    }

    public void hinzuAuthoritativeResourceRecord(String record) {
        this.authoratativeRecords.add(new ResourceRecord(record));
        ++this.authoritativeAnswerCount;
    }

    public void hinzuAuthoritativeResourceRecords(List<ResourceRecord> rrList) {
        this.authoratativeRecords.addAll(rrList);
        this.authoritativeAnswerCount += rrList.size();
    }

    public boolean isAuthoritativeAnswer() {
        return this.authoritativeAnswer;
    }

    public void setAuthoritativeAnswer(boolean authoritativeAnswer) {
        this.authoritativeAnswer = authoritativeAnswer;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public void setOpcode(int opcode) {
        this.opcode = opcode;
    }

    public int getQueryResponse() {
        return this.queryResponse;
    }

    public void setQueryResponse(int queryResponse) {
        this.queryResponse = queryResponse;
    }

    public boolean isRecursionAvailable() {
        return this.recursionAvailable;
    }

    public void setRecursionAvailable(boolean recursionAvailable) {
        this.recursionAvailable = recursionAvailable;
    }

    public boolean isRecursionDesired() {
        return this.recursionDesired;
    }

    public void setRecursionDesired(boolean recursionDesired) {
        this.recursionDesired = recursionDesired;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public void setTruncated(boolean truncated) {
        this.truncated = truncated;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public void setLocal() {
        this.isLocal = true;
    }
}

