/*
 * Decompiled with CFR 0.152.
 */
package filius.software.dateiaustausch;

import filius.software.Anwendung;
import filius.software.dateiaustausch.PeerToPeerAnwendung;
import filius.software.dateiaustausch.PeerToPeerClientMitarbeiter;
import filius.software.dateiaustausch.PingPaket;
import filius.software.dateiaustausch.QueryPaket;
import java.util.LinkedList;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PeerToPeerClient
extends Anwendung {
    private static Logger LOG = LoggerFactory.getLogger(PeerToPeerClient.class);
    private PeerToPeerAnwendung peerToPeerAnwendung;
    private LinkedList<PeerToPeerClientMitarbeiter> mitarbeiterEigeneAnfragen = new LinkedList();
    private LinkedList<PeerToPeerClientMitarbeiter> mitarbeiterFremdeAnfragen = new LinkedList();

    PeerToPeerClient(PeerToPeerAnwendung peerToPeerAnwendung) {
        LOG.trace("INVOKED-2 (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerClient), constr: PeerToPeerClient(" + peerToPeerAnwendung + ")");
        this.peerToPeerAnwendung = peerToPeerAnwendung;
    }

    @Override
    public void beenden() {
        PeerToPeerClientMitarbeiter m;
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerClient), beenden()");
        super.beenden();
        ListIterator it = this.mitarbeiterEigeneAnfragen.listIterator();
        while (it.hasNext()) {
            m = (PeerToPeerClientMitarbeiter)it.next();
            m.beenden();
        }
        it = this.mitarbeiterFremdeAnfragen.listIterator();
        while (it.hasNext()) {
            m = (PeerToPeerClientMitarbeiter)it.next();
            m.beenden();
        }
    }

    void sendePing(String wohinZuerst, PingPaket pingPaket, String nichtIP) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerClient), sendePing(" + wohinZuerst + "," + pingPaket + "," + nichtIP + ")");
        if (!wohinZuerst.equals("")) {
            PeerToPeerClientMitarbeiter lauscher = new PeerToPeerClientMitarbeiter(this.peerToPeerAnwendung, wohinZuerst, pingPaket);
            this.mitarbeiterEigeneAnfragen.add(lauscher);
            lauscher.start();
        } else {
            for (int i = 0; i < this.peerToPeerAnwendung.holeBekanntePeerToPeerTeilnehmer().size(); ++i) {
                String aktuelle = this.peerToPeerAnwendung.holeBekanntePeerToPeerTeilnehmer().get(i);
                if (aktuelle.equals(nichtIP) || aktuelle.equals(pingPaket.getIp())) continue;
                PeerToPeerClientMitarbeiter lauscher = new PeerToPeerClientMitarbeiter(this.peerToPeerAnwendung, aktuelle, pingPaket);
                this.mitarbeiterFremdeAnfragen.add(lauscher);
                lauscher.start();
            }
        }
    }

    void abbrechenSuche() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerClient), abbrechenSuche()");
        ListIterator it = this.mitarbeiterEigeneAnfragen.listIterator();
        while (it.hasNext()) {
            PeerToPeerClientMitarbeiter mitarbeiter = (PeerToPeerClientMitarbeiter)it.next();
            mitarbeiter.beenden();
        }
    }

    void dateiVomTeilnehmerAnfordern(String teilnehmerIp, String dateiName) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerClient), dateiVomTeilnehmerAnfordern(" + teilnehmerIp + "," + dateiName + ")");
        PeerToPeerClientMitarbeiter m = new PeerToPeerClientMitarbeiter(this.peerToPeerAnwendung, teilnehmerIp, dateiName);
        m.start();
        this.mitarbeiterEigeneAnfragen.add(m);
    }

    void sendeAnfrage(QueryPaket anfragePaket, String absenderIP) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (PeerToPeerClient), sendeAnfrage(" + anfragePaket + "," + absenderIP + ")");
        LinkedList<String> dieNachbarn = this.peerToPeerAnwendung.holeBekanntePeerToPeerTeilnehmer();
        for (int i = 0; i < dieNachbarn.size(); ++i) {
            String nachbar = dieNachbarn.get(i);
            if (nachbar.equals(absenderIP)) continue;
            PeerToPeerClientMitarbeiter lauscher = new PeerToPeerClientMitarbeiter(this.peerToPeerAnwendung, nachbar, anfragePaket);
            if (this.peerToPeerAnwendung.holeEigeneAnfragen().contains(anfragePaket.getGuid())) {
                this.mitarbeiterEigeneAnfragen.add(lauscher);
            } else {
                this.mitarbeiterFremdeAnfragen.add(lauscher);
            }
            lauscher.start();
        }
    }
}

