/*
 * Decompiled with CFR 0.152.
 */
package filius.software.clientserver;

import filius.rahmenprogramm.I18n;
import filius.software.clientserver.ClientAnwendung;
import filius.software.transportschicht.TCPSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientBaustein
extends ClientAnwendung
implements I18n {
    private static Logger LOG = LoggerFactory.getLogger(ClientBaustein.class);
    private int zielPort = 55555;
    private String zielIPAdresse;

    public void verbinden() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (ClientBaustein), verbinden()");
        Object[] args = new Object[]{this.zielIPAdresse, this.zielPort};
        this.ausfuehren("initialisiereSocket", args);
        this.ausfuehren("empfangeNachricht", null);
    }

    public synchronized void initialisiereSocket(String zielAdresse, Integer port) {
        LOG.debug("connect client {}:{}", (Object)zielAdresse, (Object)port);
        if (!this.istVerbunden()) {
            try {
                this.socket = new TCPSocket(this.getSystemSoftware(), zielAdresse, (int)port);
                this.socket.verbinden();
                this.benachrichtigeBeobachter(messages.getString("sw_clientbaustein_msg2"));
            }
            catch (Exception e) {
                LOG.debug("", e);
                this.socket = null;
                this.benachrichtigeBeobachter(messages.getString("sw_clientbaustein_msg1") + e.getMessage());
            }
        }
    }

    public void trennen() {
        LOG.debug("disconnect client");
        if (this.socket != null) {
            this.socket.schliessen();
            this.benachrichtigeBeobachter(messages.getString("sw_clientbaustein_msg3"));
        }
    }

    public void senden(String nachricht) {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (ClientBaustein), versendeNachricht(" + nachricht + ")");
        if (this.socket != null && this.socket.istVerbunden()) {
            try {
                this.socket.senden(nachricht);
                this.benachrichtigeBeobachter("<<" + nachricht);
            }
            catch (Exception e) {
                this.benachrichtigeBeobachter(e.getMessage());
                LOG.debug("", e);
            }
        } else {
            this.benachrichtigeBeobachter(messages.getString("sw_clientbaustein_msg4"));
        }
    }

    public void empfangeNachricht() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (ClientBaustein), empfangeNachricht()");
        while (this.socket != null && this.socket.istVerbunden()) {
            try {
                String nachricht = this.socket.empfangen(Long.MAX_VALUE);
                if (nachricht != null) {
                    this.benachrichtigeBeobachter(">>" + nachricht);
                    continue;
                }
                this.socket.schliessen();
                this.benachrichtigeBeobachter(messages.getString("sw_clientbaustein_msg5") + " " + this.socket.holeZielIPAdresse() + ":" + this.socket.holeZielPort() + " " + messages.getString("sw_clientbaustein_msg6"));
            }
            catch (Exception e) {
                this.benachrichtigeBeobachter(e.getMessage());
                LOG.debug("", e);
                this.socket = null;
            }
        }
    }

    public String getZielIPAdresse() {
        return this.zielIPAdresse;
    }

    public void setZielIPAdresse(String zielIPAdresse) {
        this.zielIPAdresse = zielIPAdresse;
    }

    public int getZielPort() {
        return this.zielPort;
    }

    public void setZielPort(int zielPort) {
        this.zielPort = zielPort;
    }
}

