/*
 * Decompiled with CFR 0.152.
 */
package filius.software;

import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProtokollThread<T>
extends Thread {
    private static Logger LOG = LoggerFactory.getLogger(ProtokollThread.class);
    protected boolean running = false;
    private LinkedList<T> puffer;

    public ProtokollThread() {
    }

    public ProtokollThread(LinkedList<T> puffer) {
        this.puffer = puffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.debug("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (ProtkollThread), run()");
        while (this.running) {
            LinkedList<T> linkedList = this.puffer;
            synchronized (linkedList) {
                if (this.puffer.size() < 1) {
                    try {
                        this.puffer.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.puffer.size() > 0) {
                    this.verarbeiteDatenEinheit(this.puffer.removeFirst());
                }
            }
        }
    }

    protected abstract void verarbeiteDatenEinheit(T var1);

    protected LinkedList<T> holeEingangsPuffer() {
        return this.puffer;
    }

    public void starten() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (ProtokollThread), starten()");
        if (!this.running) {
            this.running = true;
            if (!this.getState().equals((Object)Thread.State.WAITING) && !this.getState().equals((Object)Thread.State.BLOCKED)) {
                this.start();
            }
        }
    }

    public void beenden() {
        LOG.trace("INVOKED (" + this.hashCode() + ", T" + this.getId() + ") " + this.getClass() + " (ProtokollThread), beenden()");
        this.running = false;
        if (this.getState().equals((Object)Thread.State.WAITING) || this.getState().equals((Object)Thread.State.BLOCKED)) {
            this.interrupt();
        }
        if (this.puffer != null) {
            this.puffer.clear();
        }
    }
}

