/*
 * Decompiled with CFR 0.152.
 */
package filius.rahmenprogramm;

import de.skuzzle.semantic.Version;
import filius.gui.GUIErrorHandler;
import filius.gui.netzwerksicht.GUIDocuItem;
import filius.gui.netzwerksicht.GUIKabelItem;
import filius.gui.netzwerksicht.GUIKnotenItem;
import filius.gui.netzwerksicht.JSidebarButton;
import filius.rahmenprogramm.FiliusClassLoader;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.Information;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Observable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SzenarioVerwaltung
extends Observable
implements I18n {
    private static Logger LOG = LoggerFactory.getLogger(SzenarioVerwaltung.class);
    private boolean geaendert = false;
    private String pfad = null;
    private static SzenarioVerwaltung verwaltung = null;

    private SzenarioVerwaltung() {
    }

    public static SzenarioVerwaltung getInstance() {
        LOG.trace("INVOKED (static) filius.rahmenprogramm.SzenarioVerwaltung, getInstance()");
        if (verwaltung == null) {
            verwaltung = new SzenarioVerwaltung();
        }
        return verwaltung;
    }

    public void reset() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", reset()");
        this.pfad = null;
        this.geaendert = false;
        this.setChanged();
        this.notifyObservers();
    }

    public void setzeGeaendert() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", setzeGeaendert()");
        this.geaendert = true;
        this.setChanged();
        this.notifyObservers();
    }

    public boolean istGeaendert() {
        return this.geaendert;
    }

    public String holePfad() {
        return this.pfad;
    }

    public boolean speichern(String datei, List<GUIKnotenItem> hardwareItems, List<GUIKabelItem> kabelItems, List<GUIDocuItem> docuItems) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", speichern(" + datei + "," + hardwareItems + "," + kabelItems + ")");
        boolean erfolg = true;
        String tmpDir = Information.getInformation().getTempPfad() + "projekt" + System.getProperty("file.separator");
        new File(tmpDir).mkdirs();
        if (!SzenarioVerwaltung.kopiereVerzeichnis(Information.getInformation().getAnwendungenPfad(), tmpDir + "anwendungen")) {
            LOG.debug("ERROR (" + this.hashCode() + "): Speicherung der eigenen Anwendungen fehlgeschlagen!");
            erfolg = false;
        }
        if (!SzenarioVerwaltung.netzwerkSpeichern(tmpDir + "konfiguration.xml", hardwareItems, kabelItems, docuItems)) {
            LOG.debug("ERROR (" + this.hashCode() + "): Speicherung des Netzwerks fehlgeschlagen!");
            erfolg = false;
        }
        if (!SzenarioVerwaltung.erzeugeZipArchiv(tmpDir, datei)) {
            LOG.debug("ERROR (" + this.hashCode() + "): Speicherung der Projektdatei fehlgeschlagen!");
            erfolg = false;
        }
        if (erfolg) {
            this.pfad = datei;
            this.geaendert = false;
            this.setChanged();
            this.notifyObservers();
        }
        SzenarioVerwaltung.loescheDateien(tmpDir);
        return erfolg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean netzwerkSpeichern(String datei, List<GUIKnotenItem> hardwareItems, List<GUIKabelItem> kabelItems, List<GUIDocuItem> docuItems) {
        LOG.trace("INVOKED (static) filius.rahmenprogramm.SzenarioVerwaltung, netzwerkSpeichern(" + datei + "," + hardwareItems + "," + kabelItems + ")");
        XMLEncoder mx = null;
        FileOutputStream fos = null;
        if (Thread.currentThread().getContextClassLoader() != FiliusClassLoader.getInstance(Thread.currentThread().getContextClassLoader())) {
            Thread.currentThread().setContextClassLoader(FiliusClassLoader.getInstance(Thread.currentThread().getContextClassLoader()));
        }
        try {
            fos = new FileOutputStream(datei);
            mx = new XMLEncoder(new BufferedOutputStream(fos));
            mx.setExceptionListener(new ExceptionListener(){

                @Override
                public void exceptionThrown(Exception e) {
                    LOG.trace("Error in XML Encoder fetched.", e);
                }
            });
            mx.writeObject(new String("Filius version: " + Information.getVersion()));
            mx.writeObject(hardwareItems);
            mx.writeObject(kabelItems);
            mx.writeObject(docuItems);
            boolean bl = true;
            return bl;
        }
        catch (RuntimeException e) {
            LOG.debug("EXCEPTION: java.lang.RuntimeException raised; Java internal problem, not Filius related!");
            boolean bl = false;
            return bl;
        }
        catch (FileNotFoundException e2) {
            LOG.debug("File to store could not be found.", e2);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (mx != null) {
                mx.close();
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean laden(String datei, List<GUIKnotenItem> hardwareItems, List<GUIKabelItem> kabelItems, List<GUIDocuItem> docuItems) throws FileNotFoundException {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", laden(" + datei + "," + hardwareItems + "," + kabelItems + ")");
        boolean erfolg = true;
        String tmpDir = Information.getInformation().getTempPfad();
        SzenarioVerwaltung.loescheDateien(tmpDir + "projekt");
        if (erfolg && !SzenarioVerwaltung.loescheVerzeichnisInhalt(Information.getInformation().getAnwendungenPfad())) {
            LOG.debug("ERROR (" + this.hashCode() + "): Loeschen vorhandener Anwendungen fehlgeschlagen");
        }
        if (!SzenarioVerwaltung.entpackeZipArchiv(datei, tmpDir)) {
            LOG.debug("ERROR (" + this.hashCode() + "): Entpacken des Zip-Archivs fehlgeschlagen");
            erfolg = false;
        }
        if (erfolg && !SzenarioVerwaltung.kopiereVerzeichnis(tmpDir + "projekt/anwendungen", Information.getInformation().getAnwendungenPfad())) {
            LOG.debug("ERROR (" + this.hashCode() + "): Kopieren der Anwendungen fehlgeschlagen");
        }
        if (erfolg && !SzenarioVerwaltung.netzwerkLaden(tmpDir + "projekt/konfiguration.xml", hardwareItems, kabelItems, docuItems)) {
            LOG.debug("ERROR (" + this.hashCode() + "): Laden der Netzwerkkonfiguration fehlgeschlagen");
            erfolg = false;
        }
        if (erfolg) {
            this.pfad = datei;
            this.geaendert = false;
            this.setChanged();
            this.notifyObservers();
        }
        return erfolg;
    }

    private static boolean netzwerkLaden(String datei, List<GUIKnotenItem> hardwareItems, List<GUIKabelItem> kabelItems, List<GUIDocuItem> docuItems) {
        LOG.trace("INVOKED (static) filius.rahmenprogramm.SzenarioVerwaltung, netzwerkLaden(" + datei + "," + hardwareItems + "," + kabelItems + ")");
        Object tmpObject = null;
        if (Thread.currentThread().getContextClassLoader() != FiliusClassLoader.getInstance(Thread.currentThread().getContextClassLoader())) {
            Thread.currentThread().setContextClassLoader(FiliusClassLoader.getInstance(Thread.currentThread().getContextClassLoader()));
        }
        boolean success = false;
        try (XMLDecoder xmldec = new XMLDecoder(new BufferedInputStream(new FileInputStream(datei)));){
            List tempList;
            xmldec.setExceptionListener(new ExceptionListener(){

                @Override
                public void exceptionThrown(Exception e) {
                    LOG.debug("", e);
                }
            });
            Information.getInformation().reset();
            tmpObject = xmldec.readObject();
            if (tmpObject instanceof String) {
                String versionInfo = (String)tmpObject;
                int startIdx = versionInfo.indexOf(":") + 2;
                String versionString = versionInfo.substring(startIdx, versionInfo.indexOf(" ", startIdx));
                LOG.debug("File saved by Filius in version '" + versionString + "'");
                Version fileVersion = null;
                try {
                    fileVersion = Version.parseVersion(versionString.trim());
                }
                catch (Version.VersionFormatException e) {
                    LOG.debug("Version string of project file is not a valid semantic version.");
                }
                Version programVersion = Version.parseVersion(Information.getVersion().substring(0, versionInfo.indexOf(" ")).trim());
                if (fileVersion == null) {
                    LOG.debug("WARNING: version of scenario file could not be evaluated. Certain elements might not be rendered correctly any more!");
                } else if (fileVersion.compareTo(programVersion) < 0) {
                    LOG.debug("WARNING: current Filius version is newer (" + Information.getVersion() + ") than version of scenario file, such that certain elements might not be rendered correctly any more!");
                } else if (fileVersion.compareTo(programVersion) > 0) {
                    LOG.debug("WARNING: current Filius version is older (" + Information.getVersion() + ") than version of scenario file, such that certain elements might not be rendered correctly!");
                } else {
                    LOG.debug("\t...good, current version of Filius is equal to version of scenario file");
                }
                tmpObject = null;
            } else {
                LOG.debug("WARNING: Version information of Filius scenario file could not be determined!");
                LOG.debug("WARNING: This usually means, the scenario file was created with Filius before version 1.3.0.");
                LOG.debug("WARNING: Certain elements might not be rendered correctly any more!");
            }
            hardwareItems.clear();
            kabelItems.clear();
            docuItems.clear();
            if (tmpObject == null) {
                tmpObject = xmldec.readObject();
            }
            if (tmpObject instanceof List && !((List)tmpObject).isEmpty() && ((List)tmpObject).get(0) instanceof GUIKnotenItem) {
                tempList = (List)tmpObject;
                for (GUIKnotenItem tmpNode : tempList) {
                    if (tmpNode.getImageLabel() == null) {
                        JSidebarButton imageLabel = new JSidebarButton();
                        tmpNode.setImageLabel(imageLabel);
                    }
                    tmpNode.getImageLabel().setTyp(tmpNode.getKnoten().holeHardwareTyp());
                    hardwareItems.add(tmpNode);
                }
            }
            if ((tmpObject = xmldec.readObject()) instanceof List && !((List)tmpObject).isEmpty() && ((List)tmpObject).get(0) instanceof GUIKabelItem) {
                tempList = (List)tmpObject;
                for (GUIKabelItem cable : tempList) {
                    kabelItems.add(cable);
                }
            }
            if ((tmpObject = xmldec.readObject()) instanceof List && !((List)tmpObject).isEmpty() && ((List)tmpObject).get(0) instanceof GUIDocuItem) {
                tempList = (List)tmpObject;
                for (GUIDocuItem docuItem : tempList) {
                    docuItems.add(docuItem);
                }
            }
            success = true;
        }
        catch (FileNotFoundException e) {
            GUIErrorHandler.getGUIErrorHandler().DisplayError(messages.getString("rp_szenarioverwaltung_msg5"));
            LOG.debug("", e);
            success = false;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOG.debug("Incomplete project file " + datei);
            success = true;
        }
        return success;
    }

    public static boolean erzeugeZipArchiv(String datenOrdner, String archivDatei) {
        LOG.trace("INVOKED (static) filius.rahmenprogramm.SzenarioVerwaltung, erzeugeZipArchiv(" + datenOrdner + "," + archivDatei + ")");
        File zipDatei = new File(archivDatei);
        new File(zipDatei.getParent()).mkdirs();
        File ordner = new File(datenOrdner);
        if (!ordner.exists()) {
            return false;
        }
        try {
            zipDatei.createNewFile();
        }
        catch (IOException e) {
            LOG.debug("", e);
            return false;
        }
        try {
            FileOutputStream out = new FileOutputStream(zipDatei);
            ZipOutputStream zipOut = new ZipOutputStream(out);
            SzenarioVerwaltung.schreibeZipDatei(zipOut, ordner.getName() + "/", ordner.getAbsolutePath());
            try {
                zipOut.close();
                out.close();
            }
            catch (IOException e) {
                LOG.debug("", e);
                return false;
            }
        }
        catch (FileNotFoundException e) {
            LOG.debug("", e);
            return false;
        }
        return true;
    }

    private static boolean schreibeZipDatei(ZipOutputStream out, String relPfad, String datei) {
        LOG.trace("INVOKED (static) filius.rahmenprogramm.SzenarioVerwaltung, schreibeZipDatei(" + out + "," + relPfad + "," + datei + ")");
        boolean result = true;
        File path = new File(datei);
        if (path.isFile()) {
            return SzenarioVerwaltung.schreibeZipEntry(out, relPfad, datei);
        }
        for (File file : path.listFiles()) {
            result = file.isDirectory() ? SzenarioVerwaltung.schreibeZipDatei(out, relPfad + file.getName() + "/", file.getAbsolutePath() + "/") : SzenarioVerwaltung.schreibeZipEntry(out, relPfad + file.getName(), file.getAbsolutePath());
            if (result) continue;
            return result;
        }
        return result;
    }

    private static boolean schreibeZipEntry(ZipOutputStream out, String relPfad, String datei) {
        LOG.trace("INVOKED (static) filius.rahmenprogramm.SzenarioVerwaltung, schreibeZipEntry(" + out + "," + relPfad + "," + datei + ")");
        byte[] buffer = new byte[65535];
        File quelldatei = new File(datei);
        if (!quelldatei.exists()) {
            return false;
        }
        ZipEntry zipEntry = new ZipEntry(relPfad);
        try (FileInputStream fis = new FileInputStream(quelldatei);){
            int len;
            out.putNextEntry(zipEntry);
            while ((len = fis.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            out.closeEntry();
        }
        catch (Exception e) {
            LOG.debug("ERROR (static): Datei " + datei + " konnte nicht zu zip-Archiv hinzugefuegt werden.");
            LOG.debug("", e);
            return false;
        }
        return true;
    }

    public static boolean entpackeZipArchiv(String archivDatei, String zielOrdner) {
        LOG.trace("INVOKED (static) filius.rahmenprogramm.SzenarioVerwaltung, entpackeZipArchiv(" + archivDatei + "," + zielOrdner + ")");
        File file = new File(archivDatei);
        if (!file.exists()) {
            LOG.debug("ERROR (static): " + archivDatei + " existiert nicht. Entpacken ist fehlgeschlagen!");
            return false;
        }
        file = new File(zielOrdner);
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            ZipFile zf = new ZipFile(archivDatei);
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                int c;
                ZipEntry target = e.nextElement();
                file = new File(zielOrdner + target.getName());
                if (target.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                InputStream is = zf.getInputStream(target);
                BufferedInputStream bis = new BufferedInputStream(is);
                new File(file.getParent()).mkdirs();
                FileOutputStream fos = new FileOutputStream(file);
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                int EOF = -1;
                while ((c = bis.read()) != -1) {
                    bos.write((byte)c);
                }
                bos.close();
                fos.close();
                is.close();
                bis.close();
            }
            zf.close();
        }
        catch (FileNotFoundException e) {
            LOG.debug("EXCEPTION (static): zipfile not found");
            return false;
        }
        catch (ZipException e) {
            LOG.debug("EXCEPTION (static): zip error...");
            return false;
        }
        catch (IOException e) {
            LOG.debug("EXCEPTION (static): IO error...");
            return false;
        }
        return true;
    }

    public static boolean loescheVerzeichnisInhalt(String verzeichnis) {
        File path = new File(verzeichnis);
        if (path.exists()) {
            File[] fileListe = path.listFiles();
            for (int i = 0; i < fileListe.length; ++i) {
                File file = fileListe[i];
                if (file.isDirectory()) {
                    if (SzenarioVerwaltung.loescheDateien(file.getAbsolutePath())) continue;
                    LOG.debug("ERROR (static): Ordner " + file.getAbsolutePath() + " konnte nicht geloescht werden.");
                    return false;
                }
                if (file.delete()) continue;
                LOG.debug("ERROR (static): Datei " + file.getAbsolutePath() + " konnte nicht geloescht werden.");
                return false;
            }
        }
        return true;
    }

    public static boolean loescheDateien(String datei) {
        LOG.trace("INVOKED (static) filius.rahmenprogramm.SzenarioVerwaltung, loescheDateien(" + datei + ")");
        File path = new File(datei);
        if (!SzenarioVerwaltung.loescheVerzeichnisInhalt(datei)) {
            return false;
        }
        return path.delete();
    }

    public static boolean kopiereVerzeichnis(String quelle, String ziel) {
        LOG.trace("INVOKED (static) filius.rahmenprogramm.SzenarioVerwaltung, kopiereVerzeichnis(" + quelle + "," + ziel + ")");
        File quellOrdner = new File(quelle);
        File zielOrdner = new File(ziel);
        if (!quellOrdner.exists()) {
            return false;
        }
        if (!zielOrdner.exists()) {
            zielOrdner.mkdirs();
        }
        for (File file : quellOrdner.listFiles()) {
            if (file.isDirectory()) {
                File tmp = new File(zielOrdner.getAbsolutePath() + "/" + file.getName());
                SzenarioVerwaltung.kopiereVerzeichnis(file.getAbsolutePath(), tmp.getAbsolutePath());
                continue;
            }
            SzenarioVerwaltung.kopiereDatei(file.getAbsolutePath(), zielOrdner.getAbsolutePath() + "/" + file.getName());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveStream(InputStream source, String zieldatei) {
        LOG.trace("INVOKED (static) filius.rahmenprogramm.SzenarioVerwaltung, saveStream(" + source + "," + zieldatei + ")");
        FileOutputStream fos = null;
        boolean result = true;
        File destfile = new File(zieldatei);
        if (source == null || destfile.exists()) {
            result = false;
        } else {
            try {
                int len;
                fos = new FileOutputStream(destfile);
                byte[] buffer = new byte[65535];
                while ((len = source.read(buffer)) != -1) {
                    fos.write(buffer, 0, len);
                }
            }
            catch (IOException e) {
                LOG.debug("", e);
                result = false;
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean kopiereDatei(String quelldatei, String zieldatei) {
        LOG.trace("INVOKED (static) filius.rahmenprogramm.SzenarioVerwaltung, kopiereDatei(" + quelldatei + "," + zieldatei + ")");
        FileInputStream fis = null;
        FileOutputStream fos = null;
        boolean result = true;
        File srcfile = new File(quelldatei);
        File destfile = new File(zieldatei);
        if (!srcfile.exists() || destfile.exists()) {
            result = false;
        } else {
            try {
                int len;
                fis = new FileInputStream(srcfile);
                fos = new FileOutputStream(destfile);
                byte[] buffer = new byte[65535];
                while ((len = fis.read(buffer)) != -1) {
                    fos.write(buffer, 0, len);
                }
            }
            catch (IOException e) {
                LOG.debug("", e);
                result = false;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return result;
    }
}

