/*
 * Decompiled with CFR 0.152.
 */
package filius.rahmenprogramm;

import filius.Main;
import filius.gui.GUIContainer;
import filius.gui.anwendungssicht.GUIDesktopWindow;
import filius.hardware.Verbindung;
import filius.rahmenprogramm.ResourceUtil;
import filius.rahmenprogramm.SzenarioVerwaltung;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Information
implements Serializable {
    private static Logger LOG = LoggerFactory.getLogger(Information.class);
    private static final long serialVersionUID = 1L;
    private static Information information = null;
    private static boolean lowResolution = false;
    private static boolean posixCommandLineToolBehaviour = false;
    private static GUIDesktopWindow.Mode desktopWindowMode = GUIDesktopWindow.Mode.STACK;
    private static String version = null;
    public boolean initOk = false;
    private Vector<String> macAdressen = new Vector();
    private int maxVermittlungsStellen;
    private String programmPfad = null;
    public static String initArbeitsbereichPfad = Information.getHomeDir() + System.getProperty("file.separator");
    private String arbeitsbereichPfad = Information.getHomeDir() + System.getProperty("file.separator") + ".filius" + System.getProperty("file.separator");
    private Locale locale;
    private String lastOpenedDirectory;
    private boolean oldExchangeDialog = true;
    private FeatureMode softwareWizardMode = FeatureMode.FORCE_ENABLE;
    private boolean gatewayAvailable = true;

    public static GUIDesktopWindow.Mode getDesktopWindowMode() {
        return desktopWindowMode;
    }

    public static boolean isPosixCommandLineToolBehaviour() {
        return posixCommandLineToolBehaviour;
    }

    public static boolean isLowResolution() {
        return lowResolution;
    }

    public static void setLowResolution(boolean smallResolution) {
        lowResolution = smallResolution;
    }

    public boolean isGatewayAvailable() {
        return this.gatewayAvailable;
    }

    public FeatureMode getSoftwareWizardMode() {
        return this.softwareWizardMode;
    }

    public boolean isOldExchangeDialog() {
        return this.oldExchangeDialog;
    }

    private static String getHomeDir() {
        return System.getProperty("user.home");
    }

    private boolean checkWD(String currPath) {
        boolean nowrite = true;
        Random rnd = new Random();
        String randomString = Long.toString(rnd.nextLong());
        File testFile = null;
        do {
            String directoryPath = currPath + ".filius" + System.getProperty("file.separator");
            try {
                testFile = new File(directoryPath);
                testFile.mkdirs();
                testFile = new File(directoryPath + randomString);
                testFile.createNewFile();
                if (!testFile.delete()) {
                    throw new Exception("EXCEPTION: Error on deleting test file in write-check");
                }
                nowrite = false;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Fehler: Verzeichnis ist nicht schreibbar. Filius ben\u00f6tigt aber Schreibrechte.\nBitte w\u00e4hlen Sie ein Verzeichnis, f\u00fcr das Sie Schreibrechte besitzen.\n\nError: Directory is not writeable. But Filius needs write permissions.\nPlease choose a directory where you have write permissions.", "Fehler / Error", 0);
                JFileChooser fc = new JFileChooser();
                fc.setFileSelectionMode(1);
                if (fc.showOpenDialog(new Frame()) == 0) {
                    currPath = fc.getSelectedFile().getAbsolutePath() + System.getProperty("file.separator");
                    continue;
                }
                return false;
            }
        } while (nowrite);
        this.arbeitsbereichPfad = currPath + ".filius" + System.getProperty("file.separator");
        return true;
    }

    private Information() {
        if (this.checkWD(initArbeitsbereichPfad)) {
            this.init();
            this.initOk = true;
        }
    }

    private Information(String path) {
        if (this.checkWD(path)) {
            this.init();
            this.initOk = true;
        }
    }

    public static Information getInformation() {
        return Information.getInformation(null);
    }

    public static Information getInformation(String path) {
        if (information == null) {
            information = path != null ? new Information(path) : new Information();
        }
        if (Information.information.initOk) {
            return information;
        }
        return null;
    }

    public static String getVersion() {
        if (version == null) {
            Properties properties = new Properties();
            try {
                InputStream in = Information.class.getClassLoader().getResourceAsStream("application.properties");
                properties.load(in);
                in.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            version = properties.getProperty("application.version") + " (" + properties.getProperty("application.buildDate") + ")";
        }
        return version;
    }

    public ResourceBundle holeResourceBundle() {
        ResourceBundle bundle = ResourceBundle.getBundle("filius.messages.MessagesBundle", this.getLocaleOrDefault());
        return bundle;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Locale getLocaleOrDefault() {
        if (this.locale == null) {
            return Locale.GERMANY;
        }
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void reset() {
        this.macAdressen.clear();
        GUIContainer.getGUIContainer().getExchangeDialog().reset();
        this.init();
    }

    private void init() {
        this.maxVermittlungsStellen = 48;
        try {
            this.initialisiereVerzeichnisse();
        }
        catch (Exception e) {
            LOG.debug("", e);
        }
        SzenarioVerwaltung.loescheVerzeichnisInhalt(this.getTempPfad());
    }

    private void initialisiereVerzeichnisse() throws FileNotFoundException, IOException {
        String pfad = this.getArbeitsbereichPfad();
        if (!new File(pfad).exists() && !new File(pfad).mkdirs()) {
            LOG.debug("ERROR (" + this.hashCode() + ") " + this.getClass() + "\n\t" + pfad + " konnte nicht erzeugt werden");
        }
        if (!new File(pfad = this.getTempPfad()).exists() && !new File(pfad).mkdirs()) {
            LOG.debug("ERROR (" + this.hashCode() + ") " + this.getClass() + "\n\t" + pfad + " konnte nicht erzeugt werden");
        }
        if (!new File(pfad = this.getAnwendungenPfad()).exists() && !new File(pfad).mkdirs()) {
            LOG.debug("ERROR (" + this.hashCode() + ") " + this.getClass() + "\n\t" + pfad + " konnte nicht erzeugt werden");
        }
        if (!new File(pfad = this.getAnwendungenPfad() + "filius" + System.getProperty("file.separator") + "software" + System.getProperty("file.separator") + "clientserver" + System.getProperty("file.separator")).exists() && !new File(pfad).mkdirs()) {
            LOG.debug("ERROR (" + this.hashCode() + ") " + this.getClass() + "\n\t" + pfad + " konnte nicht erzeugt werden");
        }
        if (!new File(pfad = this.getAnwendungenPfad() + "filius" + System.getProperty("file.separator") + "gui" + System.getProperty("file.separator") + "anwendungssicht" + System.getProperty("file.separator")).exists() && !new File(pfad).mkdirs()) {
            LOG.debug("ERROR (" + this.hashCode() + ") " + this.getClass() + "\n\t" + pfad + " konnte nicht erzeugt werden");
        }
        if (!new File(pfad = this.getAnwendungenPfad() + "EigeneAnwendungen.txt").exists()) {
            new File(this.getAnwendungenPfad() + "EigeneAnwendungen.txt").createNewFile();
        }
    }

    public List<Map<String, String>> ladeProgrammListe() {
        LinkedList<Map<String, String>> tmpList = new LinkedList<Map<String, String>>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.holeAnwendungenDateipfad()), Charset.forName("UTF-8")));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.trim().startsWith("#") || line.trim().equals("")) continue;
                HashMap<String, String> tmpMap = new HashMap<String, String>();
                StringTokenizer st = new StringTokenizer(line, ";");
                tmpMap.put("Anwendung", st.nextToken());
                tmpMap.put("Klasse", st.nextToken());
                tmpMap.put("GUI-Klasse", st.nextToken());
                tmpMap.put("gfxFile", st.nextToken());
                tmpList.add(tmpMap);
            }
        }
        catch (IOException e) {
            LOG.debug("could not read list of available applications", e);
        }
        tmpList.addAll(this.ladePersoenlicheProgrammListe());
        return tmpList;
    }

    public LinkedList<HashMap<String, String>> ladePersoenlicheProgrammListe() {
        LinkedList<HashMap<String, String>> tmpList = new LinkedList<HashMap<String, String>>();
        try (RandomAccessFile desktopFile = new RandomAccessFile(Information.getInformation().getAnwendungenPfad() + "EigeneAnwendungen.txt", "r");){
            String line;
            while ((line = desktopFile.readLine()) != null) {
                HashMap<String, String> tmpMap = new HashMap<String, String>();
                if (line.trim().equals("")) continue;
                StringTokenizer st = new StringTokenizer(line, ";");
                tmpMap.put("Anwendung", st.nextToken());
                tmpMap.put("Klasse", st.nextToken());
                tmpMap.put("GUI-Klasse", st.nextToken());
                tmpMap.put("gfxFile", st.nextToken());
                tmpList.add(tmpMap);
            }
        }
        catch (IOException e) {
            LOG.debug("could not read list of available applications", e);
        }
        return tmpList;
    }

    private String holeAnwendungenDateipfad() {
        String pfad = "config/Desktop";
        File desktopResource = ResourceUtil.getResourceFile(pfad + "_" + this.locale.toString() + ".txt");
        return desktopResource.getAbsolutePath();
    }

    public String getProgrammPfad() {
        if (this.programmPfad != null) {
            return this.programmPfad;
        }
        String str = System.getProperty("java.class.path");
        this.programmPfad = System.getProperty("user.dir") + System.getProperty("file.separator");
        if (str.indexOf("filius.jar") >= 0) {
            if (new File(str).isAbsolute()) {
                this.programmPfad = "";
            }
            if (str.indexOf("/") >= 0) {
                this.programmPfad = this.programmPfad + str.substring(0, str.lastIndexOf("/")) + System.getProperty("file.separator");
            } else if (str.indexOf("\\") >= 0) {
                this.programmPfad = this.programmPfad + str.substring(0, str.lastIndexOf("\\")) + System.getProperty("file.separator");
            }
        }
        return this.programmPfad;
    }

    public String getRelativePathToProgramDir() {
        String workPath = System.getProperty("user.dir") + File.separator;
        String progPath = this.getProgrammPfad();
        if (File.separator.equals("\\")) {
            if (progPath.substring(1, 3).equals(workPath.substring(1, 3))) {
                progPath = progPath.substring(2);
                workPath = workPath.substring(2);
            } else {
                return progPath;
            }
        }
        progPath = progPath.substring(1);
        workPath = workPath.substring(1);
        String relativePath = "";
        int slashIdx = -1;
        boolean finished = false;
        if (progPath.indexOf(workPath) == 0) {
            progPath = progPath.length() <= workPath.length() ? "" : progPath.substring(workPath.length());
            workPath = "";
        } else if (workPath.indexOf(progPath) == 0) {
            workPath = workPath.length() <= progPath.length() ? "" : workPath.substring(progPath.length());
            progPath = "";
        }
        while (!finished) {
            slashIdx = workPath.indexOf(File.separator);
            if (slashIdx >= 0) {
                relativePath = relativePath + ".." + File.separator;
                if (workPath.length() <= slashIdx + 2) {
                    workPath = "";
                    continue;
                }
                workPath = workPath.substring(slashIdx + 1);
                continue;
            }
            finished = true;
            relativePath = relativePath + progPath;
            return relativePath;
        }
        return null;
    }

    public String getArbeitsbereichPfad() {
        return this.arbeitsbereichPfad;
    }

    public void setArbeitsbereichPfad(String otherWD) {
        StringTokenizer tokenizer = null;
        String token = null;
        if (otherWD.indexOf("/") >= 0) {
            tokenizer = new StringTokenizer(otherWD, "/");
        } else if (otherWD.indexOf("\\\\") >= 0) {
            tokenizer = new StringTokenizer(otherWD, "\\\\");
        }
        this.arbeitsbereichPfad = otherWD.startsWith("/") || otherWD.startsWith("\\\\") ? System.getProperty("file.separator") : "";
        if (tokenizer != null) {
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken().trim();
                if (token.isEmpty()) continue;
                this.arbeitsbereichPfad = this.arbeitsbereichPfad + token + System.getProperty("file.separator");
            }
        } else {
            this.arbeitsbereichPfad = otherWD + System.getProperty("file.separator");
        }
        this.arbeitsbereichPfad = this.arbeitsbereichPfad + ".filius" + System.getProperty("file.separator");
    }

    public String getTempPfad() {
        return this.getArbeitsbereichPfad() + "temp" + System.getProperty("file.separator");
    }

    public String getAnwendungenPfad() {
        return this.getArbeitsbereichPfad() + "anwendungen" + System.getProperty("file.separator");
    }

    public String holeFreieMACAdresse() {
        Random r = new Random();
        String[] mac = new String[6];
        for (int i = 0; i < mac.length; ++i) {
            mac[i] = Integer.toHexString(r.nextInt(255));
            if (mac[i].length() != 1) continue;
            mac[i] = "0" + mac[i];
        }
        String neueMac = mac[0] + ":" + mac[1] + ":" + mac[2] + ":" + mac[3] + ":" + mac[4] + ":" + mac[5];
        if (this.macPruefen(neueMac)) {
            return neueMac;
        }
        return this.holeFreieMACAdresse();
    }

    public void macHinzufuegen(String mac) {
        this.macAdressen.addElement(mac);
    }

    private boolean macPruefen(String mac) {
        boolean macOK = true;
        for (int i = 0; i < this.macAdressen.size(); ++i) {
            if (!mac.equals(this.macAdressen.elementAt(i))) continue;
            macOK = false;
        }
        if (mac.equalsIgnoreCase("ff:ff:ff:ff:ff:ff")) {
            macOK = false;
        }
        return macOK;
    }

    public int getMaxVermittlungsStellen() {
        return this.maxVermittlungsStellen;
    }

    public void setMaxVermittlungsStellen(int maxVermittlungsStellen) {
        this.maxVermittlungsStellen = maxVermittlungsStellen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadIni() throws IOException {
        File tmpFile = ResourceUtil.getResourceFile("config/filius.ini");
        if (tmpFile.exists()) {
            try (RandomAccessFile iniFile = null;){
                String line;
                iniFile = new RandomAccessFile(tmpFile.getAbsolutePath(), "r");
                int width = 0;
                int height = 0;
                while ((line = iniFile.readLine()) != null) {
                    StringTokenizer st;
                    if (line.trim().equals("") || line.trim().startsWith("#") || !(st = new StringTokenizer(line, "=")).hasMoreTokens()) continue;
                    String configKey = st.nextToken().trim();
                    if (!st.hasMoreTokens()) continue;
                    String configValue = st.nextToken();
                    if (configKey.equalsIgnoreCase("locale")) {
                        String language = configValue.substring(0, configValue.indexOf("_"));
                        String country = configValue.substring(configValue.indexOf("_") + 1);
                        this.setLocale(new Locale(language, country));
                        continue;
                    }
                    if (configKey.equalsIgnoreCase("rtt")) {
                        if (Verbindung.getRTTfactor() != 1) continue;
                        Verbindung.setRTTfactor(Integer.parseInt(configValue));
                        continue;
                    }
                    if (configKey.equalsIgnoreCase("native-look-n-feel")) {
                        if (!configValue.trim().equals("1")) continue;
                        Main.activateNativeLookAndFeel();
                        continue;
                    }
                    if (configKey.equalsIgnoreCase("posix-behaviour")) {
                        if (!configValue.trim().equals("1")) continue;
                        posixCommandLineToolBehaviour = true;
                        continue;
                    }
                    if (configKey.equalsIgnoreCase("desktop-mode")) {
                        desktopWindowMode = GUIDesktopWindow.Mode.getMode(Integer.parseInt(configValue.trim()));
                        continue;
                    }
                    if (configKey.equalsIgnoreCase("old-exchange-dialog")) {
                        if (configValue.trim().equals("1")) {
                            this.oldExchangeDialog = true;
                            continue;
                        }
                        if (!configValue.trim().equals("0")) continue;
                        this.oldExchangeDialog = false;
                        continue;
                    }
                    if (configKey.equalsIgnoreCase("software-wizard")) {
                        if (configValue.trim().equals("1")) {
                            this.softwareWizardMode = FeatureMode.FORCE_ENABLE;
                            continue;
                        }
                        if (configValue.trim().equals("0")) {
                            this.softwareWizardMode = FeatureMode.FORCE_DISABLE;
                            continue;
                        }
                        if (!configValue.trim().equals("2")) continue;
                        this.softwareWizardMode = FeatureMode.AUTO;
                        continue;
                    }
                    if (configKey.equalsIgnoreCase("pane-width")) {
                        try {
                            width = Integer.parseInt(configValue);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (configKey.equalsIgnoreCase("pane-height")) {
                        try {
                            height = Integer.parseInt(configValue);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (!configKey.equalsIgnoreCase("gateway")) continue;
                    if (configValue.trim().equals("1")) {
                        this.gatewayAvailable = true;
                        continue;
                    }
                    if (!configValue.trim().equals("0")) continue;
                    this.gatewayAvailable = false;
                }
                if (width > 0 && height > 0) {
                    GUIContainer.getGUIContainer(width, height);
                }
            }
        }
    }

    public String getLastOpenedDirectory() {
        return this.lastOpenedDirectory;
    }

    public void setLastOpenedDirectory(String lastOpenedDirectory) {
        this.lastOpenedDirectory = lastOpenedDirectory;
    }

    public static enum FeatureMode {
        FORCE_DISABLE,
        FORCE_ENABLE,
        AUTO;

    }
}

