/*
 * Decompiled with CFR 0.152.
 */
package filius.hardware;

import filius.exception.VerbindungsException;
import filius.hardware.Hardware;
import filius.hardware.Port;
import filius.hardware.SimplexVerbindung;
import filius.rahmenprogramm.I18n;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Verbindung
extends Hardware
implements Serializable,
I18n {
    private static Logger LOG = LoggerFactory.getLogger(Verbindung.class);
    private static final long serialVersionUID = 1L;
    private static final int MIN_VERZOEGERUNG_IN_MILLIS = 5;
    private static int verzoegerungsFaktor = 10;
    private static boolean drop = false;
    private static final int MAX_HOPS = 50;
    private static int extendRTTfactor = 1;
    private Port[] anschluesse = null;
    private SimplexVerbindung simplexEins;
    private SimplexVerbindung simplexZwei;
    private Thread threadSimplexEins;
    private Thread threadSimplexZwei;

    public static boolean isDrop() {
        return drop;
    }

    public static void setDrop(boolean drop) {
        LOG.debug("Drop data: {}", (Object)drop);
        Verbindung.drop = drop;
    }

    public void setAnschluesse(Port[] anschluesse) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (Verbindung), setAnschluesse(" + anschluesse + ")");
        this.anschluesse = anschluesse;
        try {
            this.verbinde();
        }
        catch (VerbindungsException e) {
            LOG.debug("Unexpected error when connectiong two ports", e);
        }
    }

    private void verbinde() throws VerbindungsException {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (Verbindung), verbinde()\t" + this.anschluesse[0].hashCode() + " <-> " + this.anschluesse[1].hashCode());
        try {
            this.simplexEins = new SimplexVerbindung(this.anschluesse[0], this.anschluesse[1], this);
            this.simplexZwei = new SimplexVerbindung(this.anschluesse[1], this.anschluesse[0], this);
            this.anschluesse[0].setVerbindung(this);
            this.anschluesse[1].setVerbindung(this);
            this.threadSimplexEins = new Thread(this.simplexEins);
            this.threadSimplexZwei = new Thread(this.simplexZwei);
            this.threadSimplexEins.start();
            this.threadSimplexZwei.start();
        }
        catch (NullPointerException e) {
            this.simplexEins = null;
            this.simplexZwei = null;
            this.anschluesse[0].setVerbindung(null);
            this.anschluesse[1].setVerbindung(null);
            throw new VerbindungsException("EXCEPTION: " + messages.getString("verbindung_msg1"));
        }
    }

    public Port[] getAnschluesse() {
        return this.anschluesse;
    }

    public Port findConnectedPort(Port port) throws Exception {
        Port connectedPort = null;
        if (port == this.anschluesse[0]) {
            connectedPort = this.anschluesse[1];
        } else if (port == this.anschluesse[1]) {
            connectedPort = this.anschluesse[0];
        } else {
            throw new Exception("Invalid Parameter");
        }
        return connectedPort;
    }

    public void anschluesseTrennen() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (Verbindung), anschluesseTrennen()");
        this.simplexEins.anschluesseTrennen();
        this.simplexZwei.anschluesseTrennen();
        this.threadSimplexEins.interrupt();
        this.threadSimplexZwei.interrupt();
    }

    public static int holeVerzoegerungsFaktor() {
        return verzoegerungsFaktor;
    }

    public static void setzeVerzoegerungsFaktor(int verzoegerungsFaktor) {
        LOG.trace("INVOKED (static) filius.hardware.Verbindung, setzeVerzoegerungsFaktor(" + verzoegerungsFaktor + ")");
        Verbindung.verzoegerungsFaktor = verzoegerungsFaktor < 1 ? 1 : (verzoegerungsFaktor > 100 ? 100 : verzoegerungsFaktor);
    }

    public static int holeVerzoegerung() {
        return verzoegerungsFaktor * 5;
    }

    public static void setRTTfactor(int factor) {
        if (factor >= 1 && factor <= 5) {
            extendRTTfactor = factor;
        }
    }

    public static int getRTTfactor() {
        return extendRTTfactor;
    }

    public static int holeRTT() {
        return 50 * Verbindung.holeVerzoegerung() * extendRTTfactor;
    }
}

