/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.quelltextsicht;

import filius.gui.quelltextsicht.AnwendungsTabelle;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.Information;
import filius.rahmenprogramm.ResourceUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanelVerwaltung
extends JPanel
implements I18n {
    private static Logger LOG = LoggerFactory.getLogger(PanelVerwaltung.class);
    private static final long serialVersionUID = 1L;
    private ButtonGroup buttonGroupModus;
    private ButtonGroup buttonGroupAnwendungstyp;
    private JButton buttonLoeschen;
    private JButton buttonSpeichern;
    private JTable tabelle;
    private JTextField anwendungsName;
    private JTextField klassenName;

    public PanelVerwaltung() {
        this.setPreferredSize(new Dimension(700, 460));
        this.setMaximumSize(new Dimension(700, 460));
        this.initKomponenten();
    }

    public String[] holeAnwendung() {
        String[] array = new String[2];
        if (this.buttonGroupModus.getSelection().getActionCommand().equals("neu")) {
            array[0] = this.anwendungsName.getText().trim();
            array[1] = this.klassenName.getText().trim();
            if (!array[0].equals("") && !array[1].equals("")) {
                return array;
            }
            return null;
        }
        if (this.tabelle.getSelectedRow() == -1) {
            return null;
        }
        array[0] = (String)this.tabelle.getValueAt(this.tabelle.getSelectedRow(), 0);
        array[1] = (String)this.tabelle.getValueAt(this.tabelle.getSelectedRow(), 1);
        if (!array[0].equals("") && !array[1].equals("")) {
            array[1] = array[1].substring(array[1].lastIndexOf(".") + 1);
            return array;
        }
        return null;
    }

    public String[] initQuelltextDateien() {
        String quelltext = "";
        String[] dateien = null;
        if (this.buttonGroupModus.getSelection().getActionCommand().equals("neu")) {
            String klasse = this.klassenName.getText();
            if (this.buttonGroupAnwendungstyp.getSelection().getActionCommand().equals("client")) {
                dateien = new String[2];
                dateien[0] = Information.getInformation().getAnwendungenPfad() + "filius/software/clientserver/" + klasse + ".java";
                quelltext = this.ladeQuelltext(ResourceUtil.getResourcePath("tmpl/quelltext_vorlagen/client.txt"));
                quelltext = quelltext.replaceAll("ClientBaustein", klasse);
                this.speicherQuelltext(quelltext, dateien[0]);
                dateien[1] = Information.getInformation().getAnwendungenPfad() + "filius/gui/anwendungssicht/GUIApplication" + klasse + "Window.java";
                quelltext = this.ladeQuelltext(ResourceUtil.getResourcePath("tmpl/quelltext_vorlagen/client_gui.txt"));
                quelltext = quelltext.replaceAll("ClientBaustein", klasse);
                this.speicherQuelltext(quelltext, dateien[1]);
            } else {
                dateien = new String[3];
                dateien[0] = Information.getInformation().getAnwendungenPfad() + "filius/software/clientserver/" + klasse + "Mitarbeiter.java";
                quelltext = this.ladeQuelltext(ResourceUtil.getResourcePath("tmpl/quelltext_vorlagen/server_mitarbeiter.txt"));
                quelltext = quelltext.replaceAll("ServerBaustein", klasse);
                this.speicherQuelltext(quelltext, dateien[0]);
                dateien[1] = Information.getInformation().getAnwendungenPfad() + "filius/software/clientserver/" + klasse + ".java";
                quelltext = this.ladeQuelltext(ResourceUtil.getResourcePath("tmpl/quelltext_vorlagen/server.txt"));
                quelltext = quelltext.replaceAll("ServerBaustein", klasse);
                this.speicherQuelltext(quelltext, dateien[1]);
                dateien[2] = Information.getInformation().getAnwendungenPfad() + "filius/gui/anwendungssicht/GUIApplication" + klasse + "Window.java";
                quelltext = this.ladeQuelltext(ResourceUtil.getResourcePath("tmpl/quelltext_vorlagen/server_gui.txt"));
                quelltext = quelltext.replaceAll("ServerBaustein", klasse);
                this.speicherQuelltext(quelltext, dateien[2]);
            }
        } else if (this.tabelle.getSelectedRow() != -1) {
            String klasse = (String)this.tabelle.getValueAt(this.tabelle.getSelectedRow(), 1);
            klasse = klasse.substring(klasse.lastIndexOf(".") + 1);
            File file = new File(Information.getInformation().getAnwendungenPfad() + "filius/software/clientserver/" + klasse + "Mitarbeiter.java");
            dateien = file.exists() ? new String[]{Information.getInformation().getAnwendungenPfad() + "filius/software/clientserver/" + klasse + "Mitarbeiter.java", Information.getInformation().getAnwendungenPfad() + "filius/software/clientserver/" + klasse + ".java", Information.getInformation().getAnwendungenPfad() + "filius/gui/anwendungssicht/GUIApplication" + klasse + "Window.java"} : new String[]{Information.getInformation().getAnwendungenPfad() + "filius/software/clientserver/" + klasse + ".java", Information.getInformation().getAnwendungenPfad() + "filius/gui/anwendungssicht/GUIApplication" + klasse + "Window.java"};
        }
        return dateien;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String ladeQuelltext(String datei) {
        String quellText = "";
        RandomAccessFile quellDatei = null;
        try {
            String line;
            quellDatei = new RandomAccessFile(datei, "r");
            while ((line = quellDatei.readLine()) != null) {
                quellText = quellText + line + "\n";
            }
        }
        catch (Exception e1) {
            LOG.debug("", e1);
        }
        finally {
            try {
                quellDatei.close();
            }
            catch (Exception e) {
                LOG.debug("", e);
            }
        }
        return quellText;
    }

    private void speicherQuelltext(String quelltext, String datei) {
        String verzeichnis = datei.substring(0, datei.lastIndexOf(System.getProperty("file.separator")));
        File file = new File(verzeichnis);
        file.mkdirs();
        try {
            FileWriter writer = new FileWriter(datei, false);
            writer.write(quelltext);
            writer.close();
        }
        catch (IOException e2) {
            LOG.debug("", e2);
        }
    }

    private void initKomponenten() {
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(700, 160));
        panel.setMaximumSize(new Dimension(700, 160));
        panel.setMinimumSize(new Dimension(700, 160));
        GridBagLayout gridBag = new GridBagLayout();
        panel.setLayout(gridBag);
        panel.setBorder(new EtchedBorder());
        this.buttonGroupModus = new ButtonGroup();
        this.buttonGroupAnwendungstyp = new ButtonGroup();
        JRadioButton radioButton = new JRadioButton();
        radioButton.setText(messages.getString("panelverwaltung_msg1"));
        radioButton.setActionCommand("neu");
        radioButton.setSelected(true);
        radioButton.setAlignmentX(0.0f);
        this.buttonGroupModus.add(radioButton);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gridBag.setConstraints(radioButton, gbc);
        panel.add(radioButton);
        JLabel label = new JLabel();
        label.setPreferredSize(new Dimension(10, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gridBag.setConstraints(label, gbc);
        panel.add(label);
        radioButton = new JRadioButton();
        radioButton.setText(messages.getString("panelverwaltung_msg2"));
        radioButton.setActionCommand("client");
        radioButton.setSelected(true);
        this.buttonGroupAnwendungstyp.add(radioButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gridBag.setConstraints(radioButton, gbc);
        panel.add(radioButton);
        radioButton = new JRadioButton();
        radioButton.setText(messages.getString("panelverwaltung_msg3"));
        radioButton.setActionCommand("server");
        radioButton.setSelected(false);
        this.buttonGroupAnwendungstyp.add(radioButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridwidth = 2;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gridBag.setConstraints(radioButton, gbc);
        panel.add(radioButton);
        label = new JLabel(messages.getString("panelverwaltung_msg4"));
        label.setPreferredSize(new Dimension(150, 20));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gridBag.setConstraints(label, gbc);
        panel.add(label);
        this.anwendungsName = new JTextField();
        this.anwendungsName.setPreferredSize(new Dimension(200, 20));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridwidth = 2;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gridBag.setConstraints(this.anwendungsName, gbc);
        panel.add(this.anwendungsName);
        label = new JLabel(messages.getString("panelverwaltung_msg5"));
        label.setPreferredSize(new Dimension(150, 20));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gridBag.setConstraints(label, gbc);
        panel.add(label);
        JTextField text = new JTextField("filius.software.clientserver.");
        text.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.insets = new Insets(5, 5, 5, 0);
        gbc.anchor = 18;
        gridBag.setConstraints(text, gbc);
        panel.add(text);
        this.klassenName = new JTextField();
        this.klassenName.setPreferredSize(new Dimension(200, 20));
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.anchor = 18;
        gridBag.setConstraints(this.klassenName, gbc);
        panel.add(this.klassenName);
        this.add((Component)panel, "North");
        label = new JLabel();
        label.setPreferredSize(new Dimension(680, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.gridwidth = 5;
        gridBag.setConstraints(label, gbc);
        panel.add(label);
        panel = new JPanel();
        panel.setPreferredSize(new Dimension(700, 300));
        panel.setMaximumSize(new Dimension(700, 300));
        panel.setMinimumSize(new Dimension(700, 300));
        gridBag = new GridBagLayout();
        panel.setLayout(gridBag);
        panel.setBorder(new EtchedBorder());
        radioButton = new JRadioButton();
        radioButton.setText(messages.getString("panelverwaltung_msg7"));
        radioButton.setActionCommand("modifizieren");
        radioButton.setSelected(false);
        radioButton.setAlignmentX(0.0f);
        this.buttonGroupModus.add(radioButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.gridy = 4;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gridBag.setConstraints(radioButton, gbc);
        panel.add(radioButton);
        label = new JLabel();
        label.setPreferredSize(new Dimension(10, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gridBag.setConstraints(label, gbc);
        panel.add(label);
        this.initTabelle();
        JScrollPane scrollPane = new JScrollPane(this.tabelle);
        scrollPane.setPreferredSize(new Dimension(620, 180));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridwidth = 3;
        gbc.gridy = 5;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gridBag.setConstraints(scrollPane, gbc);
        panel.add(scrollPane);
        JPanel tmp = new JPanel();
        tmp.setLayout(new FlowLayout());
        this.buttonLoeschen = new JButton(messages.getString("panelverwaltung_msg8"));
        this.buttonLoeschen.setPreferredSize(new Dimension(200, 30));
        this.buttonLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (PanelVerwaltung.this.tabelle.getSelectedRow() != -1) {
                    ((DefaultTableModel)PanelVerwaltung.this.tabelle.getModel()).removeRow(PanelVerwaltung.this.tabelle.getSelectedRow());
                    PanelVerwaltung.this.tabelleSpeichern();
                    PanelVerwaltung.this.updateTabelle();
                }
            }
        });
        tmp.add(this.buttonLoeschen);
        this.buttonSpeichern = new JButton(messages.getString("panelverwaltung_msg9"));
        this.buttonSpeichern.setPreferredSize(new Dimension(200, 30));
        this.buttonSpeichern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelVerwaltung.this.tabelleSpeichern();
                PanelVerwaltung.this.updateTabelle();
            }
        });
        tmp.add(this.buttonSpeichern);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 4;
        gbc.gridy = 6;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 10;
        gridBag.setConstraints(tmp, gbc);
        panel.add(tmp);
        label = new JLabel();
        label.setPreferredSize(new Dimension(680, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.gridwidth = 6;
        gridBag.setConstraints(label, gbc);
        panel.add(label);
        this.add((Component)panel, "South");
        this.updateTabelle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tabelleSpeichern() {
        FileWriter fw = null;
        DefaultTableModel dtm = (DefaultTableModel)this.tabelle.getModel();
        String dateiname = Information.getInformation().getAnwendungenPfad() + "EigeneAnwendungen.txt";
        try {
            fw = new FileWriter(dateiname, false);
            for (int i = 0; i < dtm.getRowCount(); ++i) {
                String[] zeile = new String[4];
                for (int j = 0; j < zeile.length; ++j) {
                    zeile[j] = (String)dtm.getValueAt(i, j);
                }
                fw.write(zeile[0] + ";" + zeile[1] + ";" + zeile[2] + ";" + zeile[3] + "\n");
            }
        }
        catch (IOException e) {
            LOG.debug("", e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void initTabelle() {
        DefaultTableModel model = new DefaultTableModel(0, 4);
        this.tabelle = new AnwendungsTabelle(model);
        this.tabelle.setDragEnabled(false);
        this.tabelle.setSelectionMode(0);
        this.tabelle.setIntercellSpacing(new Dimension(10, 10));
        this.tabelle.setRowHeight(30);
        this.tabelle.setShowGrid(false);
        this.tabelle.setFillsViewportHeight(true);
        this.tabelle.setBackground(Color.WHITE);
        this.tabelle.setShowHorizontalLines(true);
        TableColumnModel tcm = this.tabelle.getColumnModel();
        tcm.getColumn(0).setHeaderValue(messages.getString("panelverwaltung_msg10"));
        tcm.getColumn(0).setPreferredWidth(100);
        tcm.getColumn(1).setHeaderValue(messages.getString("panelverwaltung_msg11"));
        tcm.getColumn(1).setPreferredWidth(100);
        tcm.getColumn(2).setHeaderValue(messages.getString("panelverwaltung_msg12"));
        tcm.getColumn(2).setPreferredWidth(100);
        tcm.getColumn(3).setHeaderValue(messages.getString("panelverwaltung_msg13"));
        tcm.getColumn(3).setPreferredWidth(100);
    }

    private void updateTabelle() {
        DefaultTableModel dtm = (DefaultTableModel)this.tabelle.getModel();
        dtm.setRowCount(0);
        ListIterator it = Information.getInformation().ladePersoenlicheProgrammListe().listIterator();
        while (it.hasNext()) {
            HashMap map = (HashMap)it.next();
            Vector<String> zeile = new Vector<String>();
            zeile.addElement((String)map.get("Anwendung"));
            zeile.addElement((String)map.get("Klasse"));
            zeile.addElement((String)map.get("GUI-Klasse"));
            zeile.addElement((String)map.get("gfxFile"));
            dtm.addRow(zeile);
        }
        this.tabelle.updateUI();
    }
}

