/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.quelltextsicht;

import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.Information;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanelCompiler
extends JPanel
implements I18n,
Runnable {
    private static Logger LOG = LoggerFactory.getLogger(PanelCompiler.class);
    private static final long serialVersionUID = 1L;
    private String[] quelltextDateien;
    private String anwendungsKlasse;
    private String anwendungsName;
    private JEditorPane ausgabe;
    private JProgressBar progressBar;
    private boolean fehlerfreiKompiliert = false;

    public PanelCompiler(String[] quelltextDateien, String anwendungsName, String anwendungsKlasse) {
        LOG.trace("INVOKED-2 (" + this.hashCode() + ") " + this.getClass() + ", constr: PanelCompiler(" + quelltextDateien + "," + anwendungsName + "," + anwendungsKlasse + ")");
        this.quelltextDateien = quelltextDateien;
        this.anwendungsKlasse = anwendungsKlasse;
        this.anwendungsName = anwendungsName;
        this.setPreferredSize(new Dimension(700, 480));
        this.setMaximumSize(new Dimension(700, 480));
        this.initKomponenten();
    }

    private void initKomponenten() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", initKomponenten()");
        this.setBorder(new EtchedBorder());
        this.ausgabe = new JEditorPane();
        JScrollPane scrollPane = new JScrollPane(this.ausgabe);
        scrollPane.setPreferredSize(new Dimension(600, 400));
        this.add((Component)scrollPane, "Center");
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setIndeterminate(true);
        this.progressBar.setStringPainted(true);
        this.progressBar.setPreferredSize(new Dimension(600, 20));
        this.add((Component)this.progressBar, "South");
    }

    @Override
    public void run() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", run()");
        this.progressBar.setString(messages.getString("panelcompiler_msg1") + " " + this.anwendungsName);
        if (!this.kompilieren(this.quelltextDateien)) {
            this.ausgabe.setContentType("text/html");
            this.ausgabe.setText(messages.getString("panelcompiler_msg2"));
        } else if (this.fehlerfreiKompiliert) {
            this.ausgabe.setContentType("text/html");
            this.ausgabe.setText(messages.getString("panelcompiler_msg3"));
        }
        this.remove(this.progressBar);
        this.updateUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void speichern() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", speichern()");
        boolean vorhanden = false;
        OutputStreamWriter fw = null;
        if (this.fehlerfreiKompiliert) {
            ListIterator<Map<String, String>> it = Information.getInformation().ladeProgrammListe().listIterator();
            while (it.hasNext() && !vorhanden) {
                HashMap map = (HashMap)it.next();
                if (!map.get("Klasse").equals("filius.software.clientserver." + this.anwendungsKlasse)) continue;
                vorhanden = true;
            }
            if (!vorhanden) {
                try {
                    fw = new FileWriter(Information.getInformation().getAnwendungenPfad() + "EigeneAnwendungen.txt", true);
                    fw.write("\n" + this.anwendungsName + ";filius.software.clientserver." + this.anwendungsKlasse + ";filius.gui.anwendungssicht.GUIApplication" + this.anwendungsKlasse + "Window;gfx/desktop/icon_clientbaustein.png");
                }
                catch (IOException e) {
                    LOG.debug("EXCEPTION (" + this.hashCode() + "): Konnte Datei nicht erstellen");
                    this.ausgabe.setContentType("text/html");
                    this.ausgabe.setText(this.ausgabe.getText() + messages.getString("panelcompiler_msg4"));
                }
                finally {
                    if (fw != null) {
                        try {
                            fw.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    private boolean kompilieren(String[] quelltextDateien) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + ", kompilieren()");
        StringWriter strWriter = new StringWriter();
        JavaCompiler jc = ToolProvider.getSystemJavaCompiler();
        if (jc == null) {
            LOG.debug("ERROR (" + this.hashCode() + "): Kein Java-Compiler erzeugt!");
            this.fehlerfreiKompiliert = false;
            return false;
        }
        StandardJavaFileManager fileManager = jc.getStandardFileManager(null, null, null);
        File[] dateien = new File[quelltextDateien.length];
        for (int i = 0; i < dateien.length; ++i) {
            dateien[i] = new File(quelltextDateien[i]);
        }
        Iterable<? extends JavaFileObject> kompilierEinheiten = fileManager.getJavaFileObjectsFromFiles(Arrays.asList(dateien));
        this.fehlerfreiKompiliert = jc.getTask(strWriter, fileManager, null, null, null, kompilierEinheiten).call();
        if (!this.fehlerfreiKompiliert) {
            this.ausgabe.setContentType("text/plain");
            this.ausgabe.setText(strWriter.toString());
        }
        return true;
    }
}

