/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.quelltextsicht;

import filius.gui.JMainFrame;
import filius.gui.quelltextsicht.PanelCompiler;
import filius.gui.quelltextsicht.PanelQuelltext;
import filius.gui.quelltextsicht.PanelVerwaltung;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.SzenarioVerwaltung;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FrameSoftwareWizard
extends JDialog
implements I18n {
    private static final long serialVersionUID = 1L;
    public static final int VERWALTUNG = 1;
    public static final int QUELLTEXT = 2;
    public static final int COMPILER = 3;
    private int zustand;
    private PanelCompiler pCompiler = null;
    private PanelVerwaltung pVerwaltung = null;
    private PanelQuelltext pQuelltext = null;
    private JLabel untertitel;
    private JButton vorButton;
    private JButton zurueckButton;
    private String anwendungsName;
    private String klassenName;
    private String[] quelltextDateien;

    public FrameSoftwareWizard() {
        super(JMainFrame.getJMainFrame(), messages.getString("framesoftwarewizard_msg1"), true);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(720, 600);
        this.setLocation(screenSize.width / 2 - this.getWidth() / 2, screenSize.height / 2 - this.getHeight() / 2);
        this.initKomponenten();
        SzenarioVerwaltung.getInstance().setzeGeaendert();
        this.setzeVerwaltung();
    }

    private void initKomponenten() {
        this.getContentPane().removeAll();
        this.untertitel = new JLabel();
        this.untertitel.setBackground(Color.WHITE);
        this.untertitel.setOpaque(true);
        this.untertitel.setFont(new Font("Dialog", 1, 14));
        this.untertitel.setHorizontalAlignment(0);
        this.getContentPane().add((Component)this.untertitel, "North");
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        this.zurueckButton = new JButton(messages.getString("framesoftwarewizard_msg2"));
        this.zurueckButton.setPreferredSize(new Dimension(150, 30));
        this.zurueckButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSoftwareWizard.this.zurueck();
            }
        });
        panel.add(this.zurueckButton);
        this.vorButton = new JButton(messages.getString("framesoftwarewizard_msg3"));
        this.vorButton.setPreferredSize(new Dimension(150, 30));
        this.vorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSoftwareWizard.this.weiter();
            }
        });
        panel.add(this.vorButton);
        this.getContentPane().add((Component)panel, "South");
    }

    private void setzeVerwaltung() {
        if (this.pVerwaltung == null) {
            this.pVerwaltung = new PanelVerwaltung();
        }
        JScrollPane scrollPane = new JScrollPane(this.pVerwaltung);
        this.getContentPane().add((Component)scrollPane, "Center");
        this.validate();
        this.untertitel.setText(messages.getString("framesoftwarewizard_msg4"));
        this.zurueckButton.setText(messages.getString("framesoftwarewizard_msg5"));
        this.vorButton.setText(messages.getString("framesoftwarewizard_msg3"));
        this.zustand = 1;
    }

    private void setzeEditor() {
        if (this.pQuelltext == null) {
            this.pQuelltext = new PanelQuelltext();
            if (this.quelltextDateien.length == 2) {
                this.pQuelltext.hinzuEditor(this.klassenName, this.quelltextDateien[0]);
                this.pQuelltext.hinzuEditor("GUIApplication" + this.klassenName + "Window", this.quelltextDateien[1]);
            } else {
                this.pQuelltext.hinzuEditor(this.klassenName + "Mitarbeiter", this.quelltextDateien[0]);
                this.pQuelltext.hinzuEditor(this.klassenName, this.quelltextDateien[1]);
                this.pQuelltext.hinzuEditor("GUIApplication" + this.klassenName + "Window", this.quelltextDateien[2]);
            }
        }
        this.getContentPane().add((Component)this.pQuelltext, "Center");
        this.validate();
        this.untertitel.setText(messages.getString("framesoftwarewizard_msg6"));
        this.zurueckButton.setText(messages.getString("framesoftwarewizard_msg2"));
        this.vorButton.setText(messages.getString("framesoftwarewizard_msg3"));
        this.zustand = 2;
    }

    private void setzeCompiler() {
        if (this.pCompiler == null) {
            this.pCompiler = new PanelCompiler(this.quelltextDateien, this.anwendungsName, this.klassenName);
        }
        JScrollPane scrollPane = new JScrollPane(this.pCompiler);
        this.getContentPane().add((Component)scrollPane, "Center");
        this.validate();
        this.untertitel.setText(messages.getString("framesoftwarewizard_msg7"));
        this.zurueckButton.setText(messages.getString("framesoftwarewizard_msg2"));
        this.vorButton.setText(messages.getString("framesoftwarewizard_msg8"));
        new Thread(this.pCompiler).start();
        this.zustand = 3;
    }

    private void weiter() {
        switch (this.zustand) {
            case 1: {
                String[] array = this.pVerwaltung.holeAnwendung();
                if (array == null) break;
                this.anwendungsName = array[0];
                this.klassenName = array[1];
                this.quelltextDateien = this.pVerwaltung.initQuelltextDateien();
                this.initKomponenten();
                this.pQuelltext = null;
                this.setzeEditor();
                break;
            }
            case 2: {
                this.pQuelltext.speicherQuelltexte();
                this.initKomponenten();
                this.pCompiler = null;
                this.setzeCompiler();
                break;
            }
            case 3: {
                this.pCompiler.speichern();
                this.setVisible(false);
            }
        }
    }

    private void zurueck() {
        switch (this.zustand) {
            case 1: {
                this.setVisible(false);
                break;
            }
            case 2: {
                this.initKomponenten();
                this.setzeVerwaltung();
                break;
            }
            case 3: {
                this.initKomponenten();
                this.setzeEditor();
            }
        }
    }
}

