/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import filius.gui.GUIContainer;
import filius.gui.GUIEvents;
import filius.gui.netzwerksicht.GUIKabelItem;
import filius.gui.netzwerksicht.JKonfiguration;
import filius.hardware.Hardware;
import filius.hardware.knoten.Switch;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.rahmenprogramm.I18n;
import filius.software.system.SwitchFirmware;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSwitchKonfiguration
extends JKonfiguration
implements I18n {
    private static Logger LOG = LoggerFactory.getLogger(JSwitchKonfiguration.class);
    private static final long serialVersionUID = 1L;
    private JTextField name;
    private JTextField ssid;
    private JTextField retentionTime;
    private JCheckBox checkCloud;

    protected JSwitchKonfiguration(Hardware hardware) {
        super(hardware);
    }

    public void aenderungenAnnehmen() {
        Switch switchWAP = (Switch)this.holeHardware();
        switchWAP.setName(this.name.getText());
        SwitchFirmware switchFirmware = (SwitchFirmware)switchWAP.getSystemSoftware();
        String ssidBeforeChange = switchFirmware.getSSID();
        if (this.checkSSID()) {
            switchFirmware.setSSID(this.ssid.getText());
        }
        if (!StringUtils.equals(ssidBeforeChange, switchFirmware.getSSID())) {
            for (GUIKabelItem cable : GUIContainer.getGUIContainer().getCableItems()) {
                if (!cable.getDasKabel().getWireless() || !switchWAP.equals(cable.getKabelpanel().getZiel1().getKnoten()) && !switchWAP.equals(cable.getKabelpanel().getZiel2().getKnoten())) continue;
                GUIEvents.getGUIEvents().removeConnection(cable);
            }
        }
        try {
            ((SwitchFirmware)((Switch)this.holeHardware()).getSystemSoftware()).setRetentionTime(Long.parseLong(this.retentionTime.getText()) * 1000L);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        GUIContainer.getGUIContainer().updateViewport();
        this.updateAttribute();
    }

    public void changeAppearance() {
        LOG.debug("DEBUG: changeAppearance invoked for Switch");
        if (this.checkCloud.isSelected()) {
            GUIContainer.getGUIContainer().getLabelforKnoten((Switch)this.holeHardware()).setIcon(new ImageIcon(this.getClass().getResource("/gfx/hardware/cloud.png")));
            ((Switch)this.holeHardware()).setCloud(true);
        } else {
            GUIContainer.getGUIContainer().getLabelforKnoten((Switch)this.holeHardware()).setIcon(new ImageIcon(this.getClass().getResource("/gfx/hardware/switch.png")));
            ((Switch)this.holeHardware()).setCloud(false);
        }
    }

    @Override
    protected void initContents() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSwitchKonfiguration.this.aenderungenAnnehmen();
            }
        };
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JSwitchKonfiguration.this.changeAppearance();
            }
        };
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                JSwitchKonfiguration.this.aenderungenAnnehmen();
            }
        };
        Box tempBox2 = Box.createVerticalBox();
        JLabel tempLabel = new JLabel(messages.getString("jswitchkonfiguration_msg1"));
        tempLabel.setPreferredSize(new Dimension(140, 10));
        tempLabel.setVisible(true);
        tempLabel.setAlignmentX(1.0f);
        this.name = new JTextField(messages.getString("jswitchkonfiguration_msg2"));
        this.name.addActionListener(actionListener);
        this.name.addFocusListener(focusListener);
        Box tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setMaximumSize(new Dimension(400, 40));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(tempLabel);
        tempBox.add(Box.createHorizontalStrut(5));
        tempBox.add(this.name);
        tempBox2.add(tempBox);
        tempBox2.add(Box.createVerticalStrut(10));
        tempLabel = new JLabel(messages.getString("jswitchkonfiguration_msg4"));
        tempLabel.setPreferredSize(new Dimension(140, 10));
        tempLabel.setVisible(true);
        tempLabel.setAlignmentX(1.0f);
        this.ssid = new JTextField();
        this.ssid.addActionListener(actionListener);
        this.ssid.addFocusListener(focusListener);
        this.ssid.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JSwitchKonfiguration.this.checkSSID();
            }
        });
        tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setMaximumSize(new Dimension(400, 40));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(tempLabel);
        tempBox.add(Box.createHorizontalStrut(5));
        tempBox.add(this.ssid);
        tempBox2.add(tempBox);
        tempBox2.add(Box.createVerticalStrut(10));
        this.checkCloud = new JCheckBox(messages.getString("jswitchkonfiguration_msg3"));
        this.checkCloud.setPreferredSize(new Dimension(160, 10));
        this.checkCloud.setVisible(true);
        this.checkCloud.setOpaque(false);
        this.checkCloud.addItemListener(itemListener);
        tempLabel = new JLabel(messages.getString("jswitchkonfiguration_msg5"));
        tempLabel.setPreferredSize(new Dimension(300, 10));
        tempLabel.setVisible(true);
        tempLabel.setAlignmentX(1.0f);
        this.retentionTime = new JTextField();
        this.retentionTime.setPreferredSize(new Dimension(100, 10));
        this.retentionTime.addActionListener(actionListener);
        this.retentionTime.addFocusListener(focusListener);
        this.retentionTime.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JSwitchKonfiguration.this.checkRetentionTime();
            }
        });
        tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setPreferredSize(new Dimension(400, 40));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(tempLabel);
        tempBox.add(Box.createHorizontalStrut(5));
        tempBox.add(this.retentionTime);
        this.rightBox.add(tempBox);
        this.rightBox.add(Box.createVerticalStrut(190));
        tempBox2.add(this.checkCloud);
        this.box.add((Component)tempBox2, "North");
    }

    @Override
    public void updateAttribute() {
        Switch switchWAP = (Switch)this.holeHardware();
        this.name.setText(switchWAP.holeAnzeigeName());
        this.ssid.setText(((SwitchFirmware)switchWAP.getSystemSoftware()).getSSID());
        this.checkSSID();
        this.retentionTime.setText(Long.toString(((SwitchFirmware)((Switch)this.holeHardware()).getSystemSoftware()).getRetentionTime() / 1000L));
        this.checkRetentionTime();
        this.checkCloud.setSelected(switchWAP.isCloud());
    }

    private boolean checkSSID() {
        return this.ueberpruefen(EingabenUeberpruefung.musterServiceSetIdentifier, this.ssid);
    }

    private boolean checkRetentionTime() {
        return this.ueberpruefen(EingabenUeberpruefung.musterNurZahlen, this.retentionTime);
    }
}

