/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import filius.gui.GUIContainer;
import filius.gui.netzwerksicht.JKonfiguration;
import filius.hardware.Hardware;
import filius.hardware.knoten.Modem;
import filius.rahmenprogramm.I18n;
import filius.software.system.ModemFirmware;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JModemKonfiguration
extends JKonfiguration
implements I18n,
Observer {
    private static Logger LOG = LoggerFactory.getLogger(JModemKonfiguration.class);
    private static final String CMD_DISCONNECT = "Trennen";
    private static final String CMD_START_SERVER = "ServerStarten";
    private static final String CMD_START_CLIENT = "ClientStarten";
    private JTextField name;
    private JCheckBox cbServerModus;
    private JTextField tfIpAdresse;
    private JTextField tfPort;
    private JButton btStartStop;

    protected JModemKonfiguration(Hardware hardware) {
        super(hardware);
        ((Modem)this.holeHardware()).getSystemSoftware().addObserver(this);
    }

    private void aenderungenAnnehmen() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (JModemKonfiguration), aenderungenAnnehmen()");
        Modem modem = (Modem)this.holeHardware();
        ModemFirmware firmware = (ModemFirmware)modem.getSystemSoftware();
        modem.setName(this.name.getText());
        firmware.setIpAdresse(this.tfIpAdresse.getText());
        try {
            firmware.setPort(Integer.parseInt(this.tfPort.getText()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.cbServerModus.isSelected()) {
            ((ModemFirmware)modem.getSystemSoftware()).setMode(1);
        } else {
            ((ModemFirmware)modem.getSystemSoftware()).setMode(2);
        }
        GUIContainer.getGUIContainer().updateViewport();
    }

    @Override
    protected void initContents() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (JModemKonfiguration), initAttributEingabeBox(" + this.box + ")");
        FocusListener configFocusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                JModemKonfiguration.this.aenderungenAnnehmen();
                JModemKonfiguration.this.updateAttribute();
            }
        };
        ActionListener configActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JModemKonfiguration.this.aenderungenAnnehmen();
                JModemKonfiguration.this.updateAttribute();
            }
        };
        JLabel tempLabel = new JLabel(messages.getString("jmodemkonfiguration_msg1"));
        tempLabel.setPreferredSize(new Dimension(140, 10));
        tempLabel.setAlignmentX(1.0f);
        this.name = new JTextField("");
        this.name.addActionListener(configActionListener);
        this.name.addFocusListener(configFocusListener);
        Box tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setMaximumSize(new Dimension(400, 40));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(tempLabel);
        tempBox.add(Box.createHorizontalStrut(5));
        tempBox.add(this.name);
        this.box.add((Component)tempBox, "North");
        tempBox = Box.createHorizontalBox();
        tempBox.setAlignmentX(0.0f);
        tempBox.setMaximumSize(new Dimension(400, 40));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cbServerModus = new JCheckBox();
        this.cbServerModus.setText(messages.getString("jmodemkonfiguration_msg2"));
        this.cbServerModus.setOpaque(false);
        this.cbServerModus.addActionListener(configActionListener);
        tempBox.add(this.cbServerModus);
        this.box.add(tempBox);
        tempBox = Box.createHorizontalBox();
        tempBox.setAlignmentX(0.0f);
        tempBox.setMaximumSize(new Dimension(400, 40));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempLabel = new JLabel(messages.getString("jmodemkonfiguration_msg3"));
        tempLabel.setPreferredSize(new Dimension(140, 10));
        tempBox.add(tempLabel);
        this.tfIpAdresse = new JTextField("192.168.0.21");
        this.tfIpAdresse.setEnabled(false);
        this.tfIpAdresse.setPreferredSize(new Dimension(100, 18));
        this.tfIpAdresse.setText(((ModemFirmware)((Modem)this.holeHardware()).getSystemSoftware()).getIpAdresse());
        this.tfIpAdresse.addActionListener(configActionListener);
        this.tfIpAdresse.addFocusListener(configFocusListener);
        tempBox.add(this.tfIpAdresse);
        this.box.add(tempBox);
        tempBox = Box.createHorizontalBox();
        tempBox.setAlignmentX(0.0f);
        tempBox.setMaximumSize(new Dimension(400, 40));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempLabel = new JLabel(messages.getString("jmodemkonfiguration_msg4"));
        tempLabel.setPreferredSize(new Dimension(140, 10));
        tempBox.add(tempLabel);
        this.tfPort = new JTextField("1234");
        this.tfPort.setPreferredSize(new Dimension(100, 18));
        this.tfPort.setText("" + ((ModemFirmware)((Modem)this.holeHardware()).getSystemSoftware()).getPort());
        this.tfPort.addActionListener(configActionListener);
        this.tfPort.addFocusListener(configFocusListener);
        tempBox.add(this.tfPort);
        this.box.add(tempBox);
        tempBox = Box.createHorizontalBox();
        tempBox.setAlignmentX(0.0f);
        tempBox.setMaximumSize(new Dimension(400, 40));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.btStartStop = new JButton(messages.getString("jmodemkonfiguration_msg2"));
        this.btStartStop.setPreferredSize(new Dimension(300, 30));
        this.btStartStop.setActionCommand(CMD_START_SERVER);
        this.btStartStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModemFirmware firmware = (ModemFirmware)((Modem)JModemKonfiguration.this.holeHardware()).getSystemSoftware();
                JModemKonfiguration.this.aenderungenAnnehmen();
                if (e.getActionCommand().equals(JModemKonfiguration.CMD_START_CLIENT)) {
                    firmware.starteClient();
                } else if (e.getActionCommand().equals(JModemKonfiguration.CMD_START_SERVER)) {
                    firmware.starteServer();
                } else if (e.getActionCommand().equals(JModemKonfiguration.CMD_DISCONNECT)) {
                    firmware.trennen();
                }
                JModemKonfiguration.this.updateAttribute();
            }
        });
        tempBox.add(this.btStartStop);
        this.box.add(tempBox);
        this.updateAttribute();
    }

    @Override
    public synchronized void updateAttribute() {
        boolean aktiv;
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (JModemKonfiguration), updateAttribute()");
        Modem modem = (Modem)this.holeHardware();
        ModemFirmware firmware = (ModemFirmware)modem.getSystemSoftware();
        this.name.setText(modem.holeAnzeigeName());
        this.tfIpAdresse.setText(firmware.getIpAdresse());
        this.tfPort.setText("" + firmware.getPort());
        if (firmware.getMode() == 2) {
            this.cbServerModus.setSelected(false);
            this.tfIpAdresse.setEnabled(true);
            this.btStartStop.setPreferredSize(new Dimension(300, 30));
            this.btStartStop.setActionCommand(CMD_START_CLIENT);
            aktiv = modem.istModemVerbindungAktiv();
            this.btStartStop.setText(aktiv ? messages.getString("jmodemkonfiguration_msg6") : messages.getString("jmodemkonfiguration_msg5"));
        } else {
            this.cbServerModus.setSelected(true);
            this.tfIpAdresse.setEnabled(false);
            this.btStartStop.setPreferredSize(new Dimension(300, 30));
            this.btStartStop.setActionCommand(CMD_START_SERVER);
            aktiv = firmware.istServerBereit();
            this.btStartStop.setText(aktiv ? messages.getString("jmodemkonfiguration_msg8") : messages.getString("jmodemkonfiguration_msg7"));
        }
        if (aktiv) {
            this.btStartStop.setActionCommand(CMD_DISCONNECT);
            this.tfIpAdresse.setEnabled(false);
            this.tfPort.setEnabled(false);
            this.cbServerModus.setEnabled(false);
        } else {
            this.tfPort.setEnabled(true);
            this.cbServerModus.setEnabled(true);
        }
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (JModemKonfiguration), update(" + arg0 + "," + arg1 + ")");
        this.updateAttribute();
    }
}

