/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import filius.gui.ControlPanel;
import filius.gui.netzwerksicht.JGatewayConfiguration;
import filius.gui.netzwerksicht.JHostKonfiguration;
import filius.gui.netzwerksicht.JModemKonfiguration;
import filius.gui.netzwerksicht.JSwitchKonfiguration;
import filius.gui.netzwerksicht.JVermittlungsrechnerKonfiguration;
import filius.hardware.Hardware;
import filius.hardware.knoten.Gateway;
import filius.hardware.knoten.Host;
import filius.hardware.knoten.Modem;
import filius.hardware.knoten.Switch;
import filius.hardware.knoten.Vermittlungsrechner;
import filius.rahmenprogramm.EingabenUeberpruefung;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.swing.JTextField;

public class JKonfiguration
extends ControlPanel {
    private Hardware hardware;
    protected static HashMap<Hardware, JKonfiguration> instances = new HashMap();

    protected JKonfiguration(Hardware hardware) {
        this.hardware = hardware;
        if (hardware != null) {
            hardware.addObserver(this);
            this.reInit();
            this.updateAttribute();
        }
        this.minimieren();
    }

    public static JKonfiguration getInstance(Hardware hardware) {
        if (hardware == null) {
            return new JKonfiguration(null);
        }
        if (!instances.containsKey(hardware)) {
            JKonfiguration newInstance = hardware instanceof Host ? new JHostKonfiguration(hardware) : (hardware instanceof Modem ? new JModemKonfiguration(hardware) : (hardware instanceof Switch ? new JSwitchKonfiguration(hardware) : (hardware instanceof Vermittlungsrechner ? new JVermittlungsrechnerKonfiguration(hardware) : (hardware instanceof Gateway ? new JGatewayConfiguration(hardware) : new JKonfiguration(null)))));
            instances.put(hardware, newInstance);
        }
        return instances.get(hardware);
    }

    public Hardware holeHardware() {
        return this.hardware;
    }

    public boolean ueberpruefen(Pattern pruefRegel, JTextField feld) {
        if (EingabenUeberpruefung.isGueltig(feld.getText(), pruefRegel)) {
            feld.setForeground(EingabenUeberpruefung.farbeRichtig);
            return true;
        }
        feld.setForeground(EingabenUeberpruefung.farbeFalsch);
        return false;
    }
}

