/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import filius.gui.GUIContainer;
import filius.gui.GUIEvents;
import filius.gui.JMainFrame;
import filius.gui.netzwerksicht.GUIKabelItem;
import filius.gui.netzwerksicht.GUIKnotenItem;
import filius.gui.netzwerksicht.JDHCPKonfiguration;
import filius.gui.netzwerksicht.JKonfiguration;
import filius.hardware.Hardware;
import filius.hardware.knoten.Host;
import filius.hardware.knoten.InternetKnoten;
import filius.hardware.knoten.Switch;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.rahmenprogramm.I18n;
import filius.software.system.Betriebssystem;
import filius.software.system.InternetKnotenBetriebssystem;
import filius.software.system.SwitchFirmware;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JHostKonfiguration
extends JKonfiguration
implements I18n {
    private static Logger LOG = LoggerFactory.getLogger(JHostKonfiguration.class);
    private static final int LABEL_WIDTH = 160;
    private JTextField name;
    private JTextField macAdresse;
    private JTextField ipAdresse;
    private JTextField netzmaske;
    private JTextField gateway;
    private JTextField dns;
    private JCheckBox dhcp;
    private JCheckBox ipForwarding;
    private JButton btDhcp;
    private JCheckBox useIpAsName;
    private JCheckBox useMacAsName;
    private JComboBox<String> ssid;
    private JLabel ssidLabel;
    private JRadioButton useLAN;
    private JRadioButton useWiFi;
    private ButtonGroup lanWifi;

    protected JHostKonfiguration(Hardware hardware) {
        super(hardware);
    }

    private void aendereAnzeigeName() {
        if (this.holeHardware() != null) {
            Host host = (Host)this.holeHardware();
            host.setUseIPAsName(this.useIpAsName.isSelected());
            host.setUseMACAsName(this.useMacAsName.isSelected());
        }
        GUIContainer.getGUIContainer().updateViewport();
        this.updateAttribute();
    }

    private void aenderungenAnnehmen() {
        if (this.holeHardware() != null) {
            Host host = (Host)this.holeHardware();
            if (!this.useIpAsName.isSelected()) {
                host.setName(this.name.getText());
            }
            Betriebssystem bs = (Betriebssystem)host.getSystemSoftware();
            bs.setzeIPAdresse(this.ipAdresse.getText());
            bs.setzeNetzmaske(this.netzmaske.getText());
            bs.setStandardGateway(this.gateway.getText());
            bs.setDNSServer(this.dns.getText());
            bs.setIpForwardingEnabled(this.ipForwarding.isSelected());
            bs.setDHCPKonfiguration(this.dhcp.isSelected());
            boolean wifiStatusBeforeChange = bs.wireless();
            String ssidBeforeChange = bs.getSsid();
            bs.nicWireless(this.useWiFi.isSelected());
            if (this.ssid.getSelectedIndex() >= 1) {
                ((Betriebssystem)host.getSystemSoftware()).setSsid(this.ssid.getSelectedItem().toString());
            } else {
                ((Betriebssystem)host.getSystemSoftware()).setSsid(null);
            }
            boolean wifiStatusAfterChange = bs.wireless();
            String ssidAfterChange = bs.getSsid();
            if (!StringUtils.equals(ssidBeforeChange, ssidAfterChange) || wifiStatusBeforeChange != wifiStatusAfterChange) {
                this.updateWifiConnection();
            }
            if (this.dhcp.isSelected()) {
                bs.getDHCPServer().setAktiv(false);
            }
        } else {
            LOG.debug("GUIRechnerKonfiguration: Aenderungen konnten nicht uebernommen werden.");
        }
        GUIContainer.getGUIContainer().updateViewport();
    }

    @Override
    protected void initContents() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JHostKonfiguration.this.aenderungenAnnehmen();
                JHostKonfiguration.this.updateAttribute();
            }
        };
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                JHostKonfiguration.this.aenderungenAnnehmen();
                JHostKonfiguration.this.updateAttribute();
            }
        };
        JLabel tempLabel = new JLabel(messages.getString("jhostkonfiguration_msg1"));
        tempLabel.setPreferredSize(new Dimension(160, 10));
        tempLabel.setVisible(true);
        tempLabel.setAlignmentX(1.0f);
        this.name = new JTextField(messages.getString("jhostkonfiguration_msg2"));
        this.name.addActionListener(actionListener);
        this.name.addFocusListener(focusListener);
        Box tempBox = Box.createHorizontalBox();
        tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setMaximumSize(new Dimension(400, 35));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(tempLabel);
        tempBox.add(Box.createHorizontalStrut(5));
        tempBox.add(this.name);
        this.box.add((Component)tempBox, "North");
        tempLabel = new JLabel(messages.getString("jhostkonfiguration_msg9"));
        tempLabel.setPreferredSize(new Dimension(160, 10));
        tempLabel.setVisible(true);
        tempLabel.setAlignmentX(1.0f);
        this.macAdresse = new JTextField("");
        this.macAdresse.setEditable(false);
        tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setMaximumSize(new Dimension(400, 35));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(tempLabel);
        tempBox.add(Box.createHorizontalStrut(5));
        tempBox.add(this.macAdresse);
        this.box.add((Component)tempBox, "North");
        tempLabel = new JLabel(messages.getString("jhostkonfiguration_msg3"));
        tempLabel.setPreferredSize(new Dimension(160, 10));
        tempLabel.setVisible(true);
        tempLabel.setAlignmentX(1.0f);
        this.ipAdresse = new JTextField("192.168.0.1");
        this.ipAdresse.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JHostKonfiguration.this.checkIpAddress();
            }
        });
        this.ipAdresse.addActionListener(actionListener);
        this.ipAdresse.addFocusListener(focusListener);
        tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setMaximumSize(new Dimension(400, 35));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(tempLabel);
        tempBox.add(Box.createHorizontalStrut(5));
        tempBox.add(this.ipAdresse);
        this.box.add((Component)tempBox, "North");
        tempLabel = new JLabel(messages.getString("jhostkonfiguration_msg4"));
        tempLabel.setPreferredSize(new Dimension(160, 10));
        tempLabel.setVisible(true);
        tempLabel.setAlignmentX(1.0f);
        this.netzmaske = new JTextField("255.255.255.0");
        this.netzmaske.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JHostKonfiguration.this.checkNetmask();
            }
        });
        this.netzmaske.addActionListener(actionListener);
        this.netzmaske.addFocusListener(focusListener);
        tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setMaximumSize(new Dimension(400, 35));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(tempLabel);
        tempBox.add(Box.createHorizontalStrut(5));
        tempBox.add(this.netzmaske);
        this.box.add((Component)tempBox, "North");
        tempLabel = new JLabel(messages.getString("jhostkonfiguration_msg5"));
        tempLabel.setPreferredSize(new Dimension(160, 10));
        tempLabel.setVisible(true);
        tempLabel.setAlignmentX(1.0f);
        this.gateway = new JTextField("192.168.0.1");
        this.gateway.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JHostKonfiguration.this.checkGatewayAddress();
            }
        });
        this.gateway.addActionListener(actionListener);
        this.gateway.addFocusListener(focusListener);
        tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setMaximumSize(new Dimension(400, 35));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(tempLabel);
        tempBox.add(Box.createHorizontalStrut(5));
        tempBox.add(this.gateway);
        this.box.add((Component)tempBox, "North");
        tempLabel = new JLabel(messages.getString("jhostkonfiguration_msg6"));
        tempLabel.setPreferredSize(new Dimension(160, 10));
        tempLabel.setVisible(true);
        tempLabel.setAlignmentX(1.0f);
        this.dns = new JTextField("192.168.0.1");
        this.dns.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JHostKonfiguration.this.checkDnsAddress();
            }
        });
        this.dns.addActionListener(actionListener);
        this.dns.addFocusListener(focusListener);
        tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setMaximumSize(new Dimension(400, 35));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(tempLabel);
        tempBox.add(Box.createHorizontalStrut(5));
        tempBox.add(this.dns);
        this.box.add((Component)tempBox, "North");
        ActionListener wifiLanActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JHostKonfiguration.this.aenderungenAnnehmen();
                JHostKonfiguration.this.updateAttribute();
            }
        };
        JLabel connectivity = new JLabel(" / ");
        this.useLAN = new JRadioButton();
        this.useLAN.setText(messages.getString("jhostkonfiguration_msg14"));
        this.useLAN.setOpaque(false);
        this.useLAN.addActionListener(wifiLanActionListener);
        this.lanWifi = new ButtonGroup();
        this.lanWifi.add(this.useLAN);
        this.useWiFi = new JRadioButton();
        this.useWiFi.setText(messages.getString("jhostkonfiguration_msg13"));
        this.useWiFi.setOpaque(false);
        this.useWiFi.addActionListener(wifiLanActionListener);
        this.lanWifi.add(this.useWiFi);
        tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setPreferredSize(new Dimension(400, 35));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(this.useLAN);
        tempBox.add(connectivity);
        tempBox.add(this.useWiFi);
        this.middleBox.add(tempBox);
        this.ssidLabel = new JLabel(messages.getString("jhostkonfiguration_msg15"));
        this.ssidLabel.setVisible(true);
        this.ssidLabel.setOpaque(false);
        this.ssidLabel.setAlignmentX(1.0f);
        tempBox = Box.createHorizontalBox();
        tempBox.add(Box.createHorizontalStrut(30));
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setPreferredSize(new Dimension(400, 35));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(this.ssidLabel);
        this.middleBox.add(tempBox);
        this.ssid = new JComboBox();
        this.ssid.addItem(messages.getString("jhostkonfiguration_msg16"));
        this.ssid.setPreferredSize(new Dimension(100, 15));
        this.ssid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JHostKonfiguration.this.aenderungenAnnehmen();
            }
        });
        tempBox = Box.createHorizontalBox();
        tempBox.add(Box.createHorizontalStrut(30));
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setPreferredSize(new Dimension(400, 35));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(this.ssid);
        this.middleBox.add(tempBox);
        this.middleBox.add(Box.createVerticalStrut(160));
        tempLabel = new JLabel(messages.getString("jhostkonfiguration_msg10"));
        tempLabel.setPreferredSize(new Dimension(160, 10));
        tempLabel.setVisible(true);
        tempLabel.setOpaque(false);
        tempLabel.setAlignmentX(1.0f);
        this.useIpAsName = new JCheckBox();
        this.useIpAsName.setOpaque(false);
        this.useIpAsName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JHostKonfiguration.this.aendereAnzeigeName();
            }
        });
        tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setPreferredSize(new Dimension(400, 35));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(this.useIpAsName);
        tempBox.add(Box.createHorizontalStrut(5));
        tempBox.add(tempLabel);
        this.rightBox.add((Component)tempBox, "North");
        tempLabel = new JLabel(messages.getString("jhostkonfiguration_msg12"));
        tempLabel.setPreferredSize(new Dimension(160, 10));
        tempLabel.setVisible(true);
        tempLabel.setOpaque(false);
        tempLabel.setAlignmentX(1.0f);
        this.useMacAsName = new JCheckBox();
        this.useMacAsName.setOpaque(false);
        this.useMacAsName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JHostKonfiguration.this.aendereAnzeigeName();
            }
        });
        tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setPreferredSize(new Dimension(400, 35));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(this.useMacAsName);
        tempBox.add(Box.createHorizontalStrut(5));
        tempBox.add(tempLabel);
        this.rightBox.add((Component)tempBox, "North");
        tempLabel = new JLabel(messages.getString("jhostkonfiguration_msg11"));
        tempLabel.setPreferredSize(new Dimension(160, 10));
        tempLabel.setVisible(true);
        tempLabel.setOpaque(false);
        tempLabel.setAlignmentX(1.0f);
        this.ipForwarding = new JCheckBox();
        this.ipForwarding.setOpaque(false);
        this.ipForwarding.addActionListener(actionListener);
        tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setPreferredSize(new Dimension(400, 35));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(this.ipForwarding);
        tempBox.add(Box.createHorizontalStrut(5));
        tempBox.add(tempLabel);
        this.rightBox.add((Component)tempBox, "North");
        tempLabel = new JLabel(messages.getString("jhostkonfiguration_msg7"));
        tempLabel.setPreferredSize(new Dimension(160, 10));
        tempLabel.setVisible(true);
        tempLabel.setOpaque(false);
        tempLabel.setAlignmentX(1.0f);
        this.dhcp = new JCheckBox();
        this.dhcp.setSelected(false);
        this.dhcp.setOpaque(false);
        this.dhcp.addActionListener(actionListener);
        tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setPreferredSize(new Dimension(400, 35));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(this.dhcp);
        tempBox.add(Box.createHorizontalStrut(5));
        tempBox.add(tempLabel);
        this.rightBox.add((Component)tempBox, "North");
        this.rightBox.add(Box.createVerticalStrut(10));
        tempBox = Box.createHorizontalBox();
        tempBox.setAlignmentX(0.0f);
        tempBox.setOpaque(false);
        this.btDhcp = new JButton(messages.getString("jhostkonfiguration_msg8"));
        this.btDhcp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JHostKonfiguration.this.showDhcpConfiguration();
            }
        });
        tempBox.add(this.btDhcp);
        this.rightBox.add(tempBox);
        this.rightBox.add(Box.createVerticalStrut(80));
        this.updateAttribute();
    }

    private void showDhcpConfiguration() {
        JDHCPKonfiguration dhcpKonfig = new JDHCPKonfiguration(JMainFrame.getJMainFrame(), messages.getString("jhostkonfiguration_msg8"), (InternetKnotenBetriebssystem)((InternetKnoten)this.holeHardware()).getSystemSoftware());
        dhcpKonfig.setVisible(true);
    }

    private void checkIpAddress() {
        this.ueberpruefen(EingabenUeberpruefung.musterIpAdresse, this.ipAdresse);
    }

    private void checkDnsAddress() {
        this.ueberpruefen(EingabenUeberpruefung.musterIpAdresseAuchLeer, this.dns);
    }

    private void checkGatewayAddress() {
        this.ueberpruefen(EingabenUeberpruefung.musterIpAdresseAuchLeer, this.gateway);
    }

    private void checkNetmask() {
        this.ueberpruefen(EingabenUeberpruefung.musterSubNetz, this.netzmaske);
    }

    @Override
    public void updateAttribute() {
        if (this.holeHardware() != null) {
            Host host = (Host)this.holeHardware();
            this.name.setText(host.holeAnzeigeName());
            this.useIpAsName.setSelected(host.isUseIPAsName());
            this.useMacAsName.setSelected(host.isUseMACAsName());
            this.name.setEnabled(!host.isUseIPAsName() && !host.isUseMACAsName());
            Betriebssystem bs = (Betriebssystem)host.getSystemSoftware();
            this.macAdresse.setText(bs.primaryMACAddress());
            this.ipAdresse.setText(bs.primaryIPAdresse());
            this.netzmaske.setText(bs.primarySubnetMask());
            this.gateway.setText(bs.getStandardGateway());
            this.dns.setText(bs.getDNSServer());
            this.ipForwarding.setSelected(bs.isIpForwardingEnabled());
            this.dhcp.setSelected(bs.isDHCPKonfiguration());
            this.btDhcp.setEnabled(!this.dhcp.isSelected());
            this.ipAdresse.setEnabled(!bs.isDHCPKonfiguration());
            this.netzmaske.setEnabled(!bs.isDHCPKonfiguration());
            this.gateway.setEnabled(!bs.isDHCPKonfiguration());
            this.dns.setEnabled(!bs.isDHCPKonfiguration());
            this.useLAN.setSelected(!bs.wireless());
            this.useWiFi.setSelected(bs.wireless());
            this.useWiFi.setEnabled(host.holeFreienPort() != null || bs.wireless());
            this.ssid.setEnabled(this.useWiFi.isSelected());
            this.ssidLabel.setEnabled(this.ssid.isEnabled());
            this.updateSsid();
            this.checkIpAddress();
            this.checkDnsAddress();
            this.checkGatewayAddress();
            this.checkNetmask();
        } else {
            LOG.debug("GUIRechnerKonfiguration: keine Hardware-Komponente vorhanden");
        }
    }

    private void updateWifiConnection() {
        boolean connectWifi;
        Host host = (Host)this.holeHardware();
        for (GUIKabelItem cable : GUIContainer.getGUIContainer().getCableItems()) {
            if (!cable.getDasKabel().getWireless() || !host.equals(cable.getKabelpanel().getZiel1().getKnoten()) && !host.equals(cable.getKabelpanel().getZiel2().getKnoten())) continue;
            GUIEvents.getGUIEvents().removeConnection(cable);
            break;
        }
        Betriebssystem os = (Betriebssystem)host.getSystemSoftware();
        String configuredSSID = os.getSsid();
        boolean bl = connectWifi = os.wireless() && null != configuredSSID;
        if (connectWifi) {
            GUIKnotenItem wifiAccessPoint = null;
            GUIKnotenItem hostNode = null;
            for (GUIKnotenItem item : GUIContainer.getGUIContainer().getKnotenItems()) {
                if (item.getKnoten() instanceof Switch && configuredSSID.equals(((SwitchFirmware)item.getKnoten().getSystemSoftware()).getSSID())) {
                    wifiAccessPoint = item;
                    continue;
                }
                if (item.getKnoten().equals(host)) {
                    hostNode = item;
                    continue;
                }
                if (null == wifiAccessPoint || null == hostNode) continue;
                break;
            }
            if (null != wifiAccessPoint) {
                GUIEvents.getGUIEvents().createConnection(hostNode, wifiAccessPoint);
            }
        }
        GUIContainer.getGUIContainer().updateCables();
    }

    private void updateSsid() {
        ArrayList<String> ssidList = new ArrayList<String>();
        for (int i = 1; i < this.ssid.getItemCount(); ++i) {
            ssidList.add(this.ssid.getItemAt(i));
        }
        Host host = (Host)this.holeHardware();
        String configuredSSID = ((Betriebssystem)host.getSystemSoftware()).getSsid();
        ArrayList<String> accessPointSsidList = new ArrayList<String>();
        for (GUIKnotenItem item : GUIContainer.getGUIContainer().getKnotenItems()) {
            if (!(item.getKnoten() instanceof Switch)) continue;
            String accessPointSsid = ((SwitchFirmware)item.getKnoten().getSystemSoftware()).getSSID();
            accessPointSsidList.add(accessPointSsid);
            if (ssidList.contains(accessPointSsid)) continue;
            this.ssid.addItem(accessPointSsid);
        }
        for (int i = this.ssid.getItemCount() - 1; i >= 1; --i) {
            if (accessPointSsidList.contains(this.ssid.getItemAt(i))) continue;
            this.ssid.removeItemAt(i);
        }
        if (null != configuredSSID && accessPointSsidList.contains(configuredSSID)) {
            this.ssid.setSelectedItem(configuredSSID);
        } else {
            this.ssid.setSelectedIndex(0);
        }
    }
}

