/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import filius.gui.GUIContainer;
import filius.gui.JMainFrame;
import filius.gui.netzwerksicht.GUIKnotenItem;
import filius.gui.netzwerksicht.JDHCPKonfiguration;
import filius.gui.netzwerksicht.JFirewallDialog;
import filius.gui.netzwerksicht.JKonfiguration;
import filius.hardware.Hardware;
import filius.hardware.Kabel;
import filius.hardware.NetzwerkInterface;
import filius.hardware.Port;
import filius.hardware.Verbindung;
import filius.hardware.knoten.Gateway;
import filius.hardware.knoten.InternetKnoten;
import filius.hardware.knoten.Knoten;
import filius.hardware.knoten.LokalerKnoten;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.rahmenprogramm.I18n;
import filius.software.firewall.Firewall;
import filius.software.system.GatewayFirmware;
import filius.software.system.InternetKnotenBetriebssystem;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGatewayConfiguration
extends JKonfiguration
implements I18n {
    private static Logger LOG = LoggerFactory.getLogger(JGatewayConfiguration.class);
    private static final int WAN_TAB_IDX = 2;
    private static final int LAN_TAB_IDX = 1;
    private JTextField name;
    private JTextField ipAddressWANPort;
    private JTextField netmaskWANPort;
    private JTextField macAddressWANPort;
    private JLabel connectedComponentWAN;
    private JTextField ipAddressLANPort;
    private JTextField netmaskLANPort;
    private JTextField macAddressLANPort;
    private JLabel connectedComponentLAN;
    private JTextField gatewayName;
    private JCheckBox ipForwarding;
    private JCheckBox dhcp;
    private JTabbedPane tpNetzwerkKarten;
    private Kabel highlightedCable = null;

    protected JGatewayConfiguration(Hardware hardware) {
        super(hardware);
    }

    public void aenderungenAnnehmen() {
        Gateway gateway = (Gateway)this.holeHardware();
        GatewayFirmware firmware = (GatewayFirmware)gateway.getSystemSoftware();
        gateway.setName(this.name.getText());
        firmware.setStandardGateway(this.gatewayName.getText());
        this.applyNICConfig(gateway.holeWANInterface(), this.ipAddressWANPort, this.netmaskWANPort);
        firmware.setDHCPKonfiguration(this.dhcp.isSelected());
        this.applyNICConfig(gateway.holeLANInterface(), this.ipAddressLANPort, this.netmaskLANPort);
        GUIContainer.getGUIContainer().updateViewport();
        this.updateAttribute();
    }

    private void applyNICConfig(NetzwerkInterface nic, JTextField ipAddressTextfield, JTextField netmaskTextfield) {
        if (this.ueberpruefen(EingabenUeberpruefung.musterIpAdresse, ipAddressTextfield)) {
            nic.setIp(ipAddressTextfield.getText());
        } else {
            LOG.debug("ERROR (" + this.hashCode() + "): IP-Adresse ungueltig " + ipAddressTextfield.getText());
        }
        if (this.ueberpruefen(EingabenUeberpruefung.musterSubNetz, netmaskTextfield)) {
            nic.setSubnetzMaske(netmaskTextfield.getText());
        } else {
            LOG.debug("ERROR (" + this.hashCode() + "): Netzmaske ungueltig " + netmaskTextfield.getText());
        }
    }

    private void showFirewallDialog() {
        Firewall firewall = ((GatewayFirmware)((Gateway)this.holeHardware()).getSystemSoftware()).holeFirewall();
        JFirewallDialog firewallDialog = new JFirewallDialog(firewall, JMainFrame.getJMainFrame());
        firewallDialog.setBounds(100, 100, 850, 340);
        firewallDialog.setName(messages.getString("jgatewayconfiguration_msg1"));
        firewallDialog.updateRuleTable();
        firewallDialog.setVisible(true);
    }

    private void showDhcpConfiguration() {
        JDHCPKonfiguration dhcpKonfig = new JDHCPKonfiguration(JMainFrame.getJMainFrame(), messages.getString("jhostkonfiguration_msg8"), (InternetKnotenBetriebssystem)((InternetKnoten)this.holeHardware()).getSystemSoftware());
        dhcpKonfig.setVisible(true);
    }

    @Override
    protected void initContents() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JGatewayConfiguration.this.aenderungenAnnehmen();
            }
        };
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                JGatewayConfiguration.this.aenderungenAnnehmen();
            }
        };
        this.addFocusListener(focusListener);
        Box boxNetzwerkKarten = Box.createVerticalBox();
        boxNetzwerkKarten.setPreferredSize(new Dimension(440, 150));
        boxNetzwerkKarten.setAlignmentX(0.0f);
        boxNetzwerkKarten.setOpaque(false);
        this.tpNetzwerkKarten = new JTabbedPane();
        this.tpNetzwerkKarten.setOpaque(false);
        boxNetzwerkKarten.add(this.tpNetzwerkKarten);
        KeyAdapter ipAdresseKeyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JTextField tfQuelle = (JTextField)e.getSource();
                JGatewayConfiguration.this.ueberpruefen(EingabenUeberpruefung.musterIpAdresse, tfQuelle);
            }
        };
        KeyAdapter netzmaskeKeyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JTextField tfQuelle = (JTextField)e.getSource();
                JGatewayConfiguration.this.ueberpruefen(EingabenUeberpruefung.musterSubNetz, tfQuelle);
            }
        };
        Box vBox = Box.createVerticalBox();
        Box tempBox = Box.createHorizontalBox();
        tempBox.setMaximumSize(new Dimension(400, 40));
        JLabel tempLabel = new JLabel(messages.getString("jgatewayconfiguration_msg2"));
        tempLabel.setPreferredSize(new Dimension(140, 20));
        tempLabel.setVisible(true);
        tempLabel.setAlignmentX(1.0f);
        tempBox.add(tempLabel);
        this.name = new JTextField(messages.getString("jgatewayconfiguration_msg3"));
        this.name.setPreferredSize(new Dimension(160, 20));
        this.name.addActionListener(actionListener);
        this.name.addFocusListener(focusListener);
        tempBox.add(this.name);
        vBox.add(tempBox);
        vBox.add(Box.createVerticalStrut(5));
        tempBox = Box.createHorizontalBox();
        tempBox.setMaximumSize(new Dimension(400, 40));
        tempLabel = new JLabel(messages.getString("jgatewayconfiguration_msg9"));
        tempLabel.setPreferredSize(new Dimension(140, 20));
        tempLabel.setVisible(true);
        tempLabel.setAlignmentX(1.0f);
        tempBox.add(tempLabel);
        this.gatewayName = new JTextField();
        this.gatewayName.setPreferredSize(new Dimension(160, 20));
        this.gatewayName.addActionListener(actionListener);
        this.gatewayName.addFocusListener(focusListener);
        this.gatewayName.addKeyListener(ipAdresseKeyAdapter);
        tempBox.add(this.gatewayName);
        vBox.add(tempBox);
        vBox.add(Box.createVerticalStrut(5));
        tempBox = Box.createHorizontalBox();
        tempBox.setMaximumSize(new Dimension(400, 40));
        this.ipForwarding = new JCheckBox();
        this.ipForwarding.setPreferredSize(new Dimension(160, 20));
        this.ipForwarding.addActionListener(actionListener);
        this.ipForwarding.addFocusListener(focusListener);
        this.ipForwarding.setOpaque(false);
        this.ipForwarding.setEnabled(false);
        tempBox.add(this.ipForwarding);
        tempBox.add(Box.createHorizontalStrut(10));
        tempLabel = new JLabel(messages.getString("jhostkonfiguration_msg11"));
        tempLabel.setPreferredSize(new Dimension(140, 20));
        tempLabel.setVisible(true);
        tempLabel.setAlignmentX(1.0f);
        tempBox.add(tempLabel);
        vBox.add(tempBox);
        vBox.add(Box.createVerticalStrut(5));
        tempBox = Box.createHorizontalBox();
        tempBox.setMaximumSize(new Dimension(400, 40));
        JButton btFirewall = new JButton(messages.getString("jgatewayconfiguration_msg4"));
        btFirewall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JGatewayConfiguration.this.showFirewallDialog();
            }
        });
        tempBox.add(btFirewall);
        vBox.add(tempBox);
        this.tpNetzwerkKarten.addTab(messages.getString("jgatewayconfiguration_msg17"), vBox);
        this.ipAddressLANPort = new JTextField();
        this.netmaskLANPort = new JTextField();
        this.macAddressLANPort = new JTextField();
        this.connectedComponentLAN = new JLabel();
        this.initNICConfigPane(ipAdresseKeyAdapter, netzmaskeKeyAdapter, focusListener, actionListener, this.ipAddressLANPort, this.macAddressLANPort, this.netmaskLANPort, this.connectedComponentLAN, true, false);
        this.ipAddressWANPort = new JTextField();
        this.netmaskWANPort = new JTextField();
        this.macAddressWANPort = new JTextField();
        this.connectedComponentWAN = new JLabel();
        this.initNICConfigPane(ipAdresseKeyAdapter, netzmaskeKeyAdapter, focusListener, actionListener, this.ipAddressWANPort, this.macAddressWANPort, this.netmaskWANPort, this.connectedComponentWAN, false, true);
        this.tpNetzwerkKarten.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                JTabbedPane pane = (JTabbedPane)arg0.getSource();
                if (JGatewayConfiguration.this.highlightedCable != null) {
                    JGatewayConfiguration.this.highlightedCable.setAktiv(false);
                }
                Verbindung conn = null;
                int sel = pane.getSelectedIndex();
                if (sel == 2) {
                    conn = ((Gateway)JGatewayConfiguration.this.holeHardware()).holeWANInterface().getPort().getVerbindung();
                } else if (sel == 1) {
                    conn = ((Gateway)JGatewayConfiguration.this.holeHardware()).holeLANInterface().getPort().getVerbindung();
                }
                if (conn != null) {
                    conn.setAktiv(true);
                    JGatewayConfiguration.this.highlightedCable = (Kabel)conn;
                }
            }
        });
        this.box.add(boxNetzwerkKarten);
        this.updateAttribute();
    }

    private void initNICConfigPane(KeyAdapter ipAdresseKeyAdapter, KeyAdapter netzmaskeKeyAdapter, FocusListener focusListener, ActionListener actionListener, JTextField ipAddressTextfield, JTextField macAddressTextfield, JTextField netmaskTextfield, JLabel connectedComponentLabel, boolean dhcpServer, boolean dhcpConfig) {
        Box boxNic = Box.createVerticalBox();
        Box boxKomponente = Box.createHorizontalBox();
        boxKomponente.setMaximumSize(new Dimension(400, 30));
        connectedComponentLabel.setPreferredSize(new Dimension(400, 10));
        boxKomponente.add(connectedComponentLabel);
        Box boxIpAdresse = Box.createHorizontalBox();
        boxIpAdresse.setMaximumSize(new Dimension(400, 30));
        JLabel tempLabel = new JLabel(messages.getString("jgatewayconfiguration_msg7"));
        tempLabel.setPreferredSize(new Dimension(120, 10));
        boxIpAdresse.add(tempLabel);
        boxIpAdresse.add(ipAddressTextfield);
        Box boxSubnetz = Box.createHorizontalBox();
        boxSubnetz.setMaximumSize(new Dimension(400, 30));
        tempLabel = new JLabel(messages.getString("jgatewayconfiguration_msg8"));
        tempLabel.setPreferredSize(new Dimension(120, 10));
        boxSubnetz.add(tempLabel);
        boxSubnetz.add(netmaskTextfield);
        Box boxMacAdresse = Box.createHorizontalBox();
        boxMacAdresse.setMaximumSize(new Dimension(400, 30));
        tempLabel = new JLabel(messages.getString("jgatewayconfiguration_msg18"));
        tempLabel.setPreferredSize(new Dimension(120, 10));
        boxMacAdresse.add(tempLabel);
        macAddressTextfield.setEnabled(false);
        boxMacAdresse.add(macAddressTextfield);
        boxNic.add(boxKomponente);
        boxNic.add(Box.createVerticalStrut(5));
        boxNic.add(boxIpAdresse);
        boxNic.add(Box.createVerticalStrut(5));
        boxNic.add(boxSubnetz);
        boxNic.add(Box.createVerticalStrut(5));
        boxNic.add(boxMacAdresse);
        if (dhcpServer) {
            boxNic.add(Box.createVerticalStrut(10));
            Box tempBox = Box.createHorizontalBox();
            tempBox.setMaximumSize(new Dimension(400, 40));
            JButton btDhcp = new JButton(messages.getString("jhostkonfiguration_msg8"));
            btDhcp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JGatewayConfiguration.this.showDhcpConfiguration();
                }
            });
            tempBox.add(btDhcp);
            boxNic.add(tempBox);
        } else if (dhcpConfig) {
            boxNic.add(Box.createVerticalStrut(10));
            Box tempBox = Box.createHorizontalBox();
            tempBox.setMaximumSize(new Dimension(400, 40));
            this.dhcp = new JCheckBox();
            this.dhcp.setSelected(false);
            this.dhcp.setOpaque(false);
            this.dhcp.addActionListener(actionListener);
            this.dhcp.setText(messages.getString("jhostkonfiguration_msg7"));
            tempBox.add(this.dhcp);
            boxNic.add(tempBox);
        }
        this.tpNetzwerkKarten.addTab(messages.getString("jgatewayconfiguration_msg10"), new ImageIcon(this.getClass().getResource("/gfx/allgemein/conn_fail.png")), boxNic);
        ipAddressTextfield.addKeyListener(ipAdresseKeyAdapter);
        ipAddressTextfield.addActionListener(actionListener);
        ipAddressTextfield.addFocusListener(focusListener);
        netmaskTextfield.addKeyListener(netzmaskeKeyAdapter);
        netmaskTextfield.addActionListener(actionListener);
        netmaskTextfield.addFocusListener(focusListener);
    }

    @Override
    public void doUnselectAction() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (jgatewayconfiguration), doUnselectAction()");
        if (this.highlightedCable != null) {
            this.highlightedCable.setAktiv(false);
            this.highlightedCable = null;
            this.tpNetzwerkKarten.setSelectedIndex(0);
        }
    }

    public void highlightConnCable() {
        if (this.highlightedCable != null) {
            this.highlightedCable.setAktiv(true);
        }
    }

    public JGatewayConfiguration getKonfiguration() {
        return this;
    }

    @Override
    public void updateAttribute() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (jgatewayconfiguration), updateAttribute()");
        Gateway vRechner = (Gateway)this.holeHardware();
        GatewayFirmware bs = (GatewayFirmware)vRechner.getSystemSoftware();
        this.name.setText(vRechner.holeAnzeigeName());
        this.gatewayName.setText(bs.getStandardGateway());
        this.ipForwarding.setSelected(bs.isIpForwardingEnabled());
        boolean dhcpEnabled = bs.isDHCPKonfiguration();
        this.dhcp.setSelected(dhcpEnabled);
        this.ipAddressWANPort.setEnabled(!dhcpEnabled);
        this.netmaskWANPort.setEnabled(!dhcpEnabled);
        this.updateNICConfigPane("LAN", vRechner.holeLANInterface(), this.ipAddressLANPort, this.macAddressLANPort, this.netmaskLANPort, this.connectedComponentLAN, 1);
        this.updateNICConfigPane("WAN", vRechner.holeWANInterface(), this.ipAddressWANPort, this.macAddressWANPort, this.netmaskWANPort, this.connectedComponentWAN, 2);
    }

    private void updateNICConfigPane(String titlePrefix, NetzwerkInterface nic, JTextField ipAddressTextfield, JTextField macAddressTextfield, JTextField netmaskTextfield, JLabel connectedComponentTextfield, int tabIdx) {
        ipAddressTextfield.setText(nic.getIp());
        netmaskTextfield.setText(nic.getSubnetzMaske());
        macAddressTextfield.setText(nic.getMac());
        Knoten tempKnoten = this.holeVerbundeneKomponente(nic);
        if (tempKnoten == null) {
            connectedComponentTextfield.setText(messages.getString("jgatewayconfiguration_msg16"));
            this.tpNetzwerkKarten.setIconAt(tabIdx, new ImageIcon(this.getClass().getResource("/gfx/allgemein/conn_fail.png")));
        } else {
            connectedComponentTextfield.setText(messages.getString("jgatewayconfiguration_msg6") + " " + tempKnoten.holeAnzeigeName());
            this.tpNetzwerkKarten.setIconAt(tabIdx, new ImageIcon(this.getClass().getResource("/gfx/allgemein/conn_ok.png")));
        }
        this.tpNetzwerkKarten.setTitleAt(tabIdx, titlePrefix + ": " + nic.getIp());
    }

    private Knoten holeVerbundeneKomponente(NetzwerkInterface nic) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (jgatewayconfiguration), holeVerbundeneKomponente(" + nic + ")");
        if (nic.getPort().getVerbindung() == null) {
            return null;
        }
        Port lokalerAnschluss = nic.getPort();
        Port[] ports = lokalerAnschluss.getVerbindung().getAnschluesse();
        Port entfernterAnschluss = ports[0] == lokalerAnschluss ? ports[1] : ports[0];
        for (GUIKnotenItem node : GUIContainer.getGUIContainer().getKnotenItems()) {
            if (node.getKnoten() instanceof LokalerKnoten) {
                for (Port port : ((LokalerKnoten)node.getKnoten()).getAnschluesse()) {
                    if (port != entfernterAnschluss) continue;
                    return node.getKnoten();
                }
                continue;
            }
            if (node.getKnoten() instanceof InternetKnoten) {
                for (NetzwerkInterface tmpNic : ((InternetKnoten)node.getKnoten()).getNetzwerkInterfaces()) {
                    if (tmpNic.getPort() != entfernterAnschluss) continue;
                    return node.getKnoten();
                }
                continue;
            }
            LOG.debug("Knotentyp unbekannt.");
        }
        return null;
    }
}

