/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import filius.gui.JExtendedTable;
import filius.gui.netzwerksicht.JFirewallDialog;
import filius.rahmenprogramm.I18n;
import filius.software.firewall.Firewall;
import filius.software.firewall.FirewallRule;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class GatewayFirewallConfigTable
extends JExtendedTable
implements I18n {
    public GatewayFirewallConfigTable(TableModel model, boolean editable) {
        super(model, editable);
    }

    @Override
    public void editingStopped(ChangeEvent evt) {
        this.closeEditor();
    }

    void closeEditor() {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            Firewall firewall = ((JFirewallDialog)this.parentGUI).getFirewall();
            FirewallRule rule = firewall.getRuleset().get(this.editingRow);
            rule.srcIP = this.getCurrentValueAt(this.editingRow, 1);
            rule.srcMask = this.getCurrentValueAt(this.editingRow, 2);
            rule.destIP = this.getCurrentValueAt(this.editingRow, 3);
            rule.destMask = this.getCurrentValueAt(this.editingRow, 4);
            String protocol = this.getCurrentValueAt(this.editingRow, 5);
            rule.protocol = protocol.equals("TCP") ? (short)6 : (protocol.equals("UDP") ? (short)17 : (short)-1);
            String port = this.getCurrentValueAt(this.editingRow, 6);
            try {
                rule.port = Integer.valueOf(port);
            }
            catch (NumberFormatException e) {
                rule.port = -1;
            }
            String action = this.getCurrentValueAt(this.editingRow, 7);
            rule.action = messages.getString("jfirewalldialog_msg33").equals(action) ? (short)1 : 0;
            this.removeEditor();
            if (rule.validateExistingAttributes()) {
                firewall.updateRule(this.editingRow, rule);
                ((JFirewallDialog)this.parentGUI).updateRuleTable();
            }
        }
    }

    private String getCurrentValueAt(int row, int col) {
        if (row == this.editingRow && col == this.editingColumn) {
            return (String)this.getCellEditor().getCellEditorValue();
        }
        return (String)this.getValueAt(row, col);
    }
}

