/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import filius.gui.netzwerksicht.GUIDocuItem;
import filius.gui.netzwerksicht.GUIDocumentationPanel;
import filius.gui.netzwerksicht.GUIFooterPanel;
import filius.gui.netzwerksicht.GUIKabelItem;
import filius.gui.netzwerksicht.GUIKnotenItem;
import filius.gui.netzwerksicht.GUINetworkPanel;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;

public class GUIPrintPanel
extends JPanel {
    private static final int EMPTY_BORDER = 10;
    private GUINetworkPanel networkPanel;
    private GUIDocumentationPanel docuPanel;
    private GUIFooterPanel footer;

    public GUIPrintPanel(int width, int height, String footerText) {
        this.setOpaque(false);
        this.footer = new GUIFooterPanel(width, height + 100, StringUtils.isBlank(footerText) ? "Filius" : footerText);
        this.add(this.footer);
        this.networkPanel = new GUINetworkPanel(width, height);
        this.networkPanel.setBounds(10, 10, width, height);
        this.add(this.networkPanel);
        this.docuPanel = new GUIDocumentationPanel(width, height);
        this.docuPanel.setBounds(10, 10, width, height);
        this.add(this.docuPanel);
        this.setSize(this.footer.getWidth() + 20, this.footer.getHeight() + 20);
    }

    public void updateViewport(List<GUIKnotenItem> knoten, List<GUIKabelItem> kabel, List<GUIDocuItem> docuItems) {
        this.networkPanel.updateViewport(knoten, kabel);
        this.docuPanel.updateViewport(docuItems, false);
        this.updateFooterPosition();
        this.footer.updateViewport();
    }

    private void updateFooterPosition() {
        int footerY = (int)Math.max(this.networkPanel.maxY, this.docuPanel.maxY) + 30;
        int footerX = (int)Math.min(this.networkPanel.minX, this.docuPanel.minX) + 10;
        this.footer.setFooterPos(footerX, footerY);
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public int getClipY() {
        return (int)this.min(this.networkPanel.minY, this.docuPanel.minY, this.footer.minY);
    }

    public int getClipHeight() {
        int totalMaxY = (int)this.footer.maxY;
        return totalMaxY - this.getClipY() + 20;
    }

    public int getClipWidth() {
        int totalMaxX = (int)this.max(this.networkPanel.maxX, this.docuPanel.maxX, this.footer.maxX);
        return totalMaxX - this.getClipX() + 20;
    }

    public int getClipX() {
        return (int)this.min(this.networkPanel.minX, this.docuPanel.minX, this.footer.minX);
    }

    private double min(double a, double b, double c) {
        double min = 2.147483647E9;
        if (a < min) {
            min = a;
        }
        if (b < min) {
            min = b;
        }
        if (c < min) {
            min = c;
        }
        return min;
    }

    private double max(double a, double b, double c) {
        double max = 0.0;
        if (a > max) {
            max = a;
        }
        if (b > max) {
            max = b;
        }
        if (c > max) {
            max = c;
        }
        return max;
    }
}

