/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import filius.gui.netzwerksicht.GUIKabelItem;
import filius.gui.netzwerksicht.GUIKnotenItem;
import filius.gui.netzwerksicht.GUIMainArea;
import filius.gui.netzwerksicht.JSidebarButton;
import filius.hardware.knoten.Gateway;
import filius.hardware.knoten.InternetKnoten;
import filius.hardware.knoten.Knoten;
import filius.hardware.knoten.Modem;
import filius.hardware.knoten.Notebook;
import filius.hardware.knoten.Rechner;
import filius.hardware.knoten.Switch;
import filius.hardware.knoten.Vermittlungsrechner;
import java.awt.Dimension;
import java.util.List;
import javax.swing.ImageIcon;

public class GUINetworkPanel
extends GUIMainArea {
    private static final long serialVersionUID = 1L;

    public GUINetworkPanel(int width, int height) {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(width, height));
        this.setOpaque(false);
        this.setBounds(0, 0, width, height);
    }

    public void updateViewport(List<GUIKnotenItem> knoten, List<GUIKabelItem> kabel) {
        this.removeAll();
        for (GUIKnotenItem tempitem : knoten) {
            Knoten tempKnoten = tempitem.getKnoten();
            JSidebarButton templabel = tempitem.getImageLabel();
            tempKnoten.addObserver(templabel);
            tempKnoten.getSystemSoftware().addObserver(templabel);
            templabel.setSelektiert(false);
            templabel.setTextAndUpdateLocation(tempKnoten.holeAnzeigeName());
            templabel.setTyp(tempKnoten.holeHardwareTyp());
            if (tempitem.getKnoten() instanceof InternetKnoten) {
                templabel.updateTooltip((InternetKnoten)tempitem.getKnoten());
            }
            if (tempitem.getKnoten() instanceof Switch) {
                if (((Switch)tempitem.getKnoten()).isCloud()) {
                    templabel.setIcon(new ImageIcon(this.getClass().getResource("/gfx/hardware/cloud.png")));
                } else {
                    templabel.setIcon(new ImageIcon(this.getClass().getResource("/gfx/hardware/switch.png")));
                }
            } else if (tempitem.getKnoten() instanceof Vermittlungsrechner) {
                templabel.setIcon(new ImageIcon(this.getClass().getResource("/gfx/hardware/router.png")));
            } else if (tempitem.getKnoten() instanceof Rechner) {
                templabel.setIcon(new ImageIcon(this.getClass().getResource("/gfx/hardware/server.png")));
            } else if (tempitem.getKnoten() instanceof Notebook) {
                templabel.setIcon(new ImageIcon(this.getClass().getResource("/gfx/hardware/laptop.png")));
            } else if (tempitem.getKnoten() instanceof Modem) {
                templabel.setIcon(new ImageIcon(this.getClass().getResource("/gfx/hardware/vermittlungsrechner-out.png")));
            } else if (tempitem.getKnoten() instanceof Gateway) {
                templabel.setIcon(new ImageIcon(this.getClass().getResource("/gfx/hardware/gateway.png")));
            }
            templabel.setBounds(tempitem.getImageLabel().getBounds());
            this.add(templabel);
        }
        for (GUIKabelItem tempcable : kabel) {
            this.add(tempcable.getKabelpanel());
        }
    }
}

