/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import com.itextpdf.text.DocumentException;
import filius.gui.GUIContainer;
import filius.gui.JMainFrame;
import filius.gui.documentation.ReportGenerator;
import filius.gui.netzwerksicht.GUISidebar;
import filius.gui.netzwerksicht.JSidebarButton;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.SzenarioVerwaltung;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.event.MouseInputAdapter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class GUIDocumentationSidebar
extends GUISidebar
implements I18n {
    public static final String TYPE_TEXTFIELD = "textfield";
    public static final String TYPE_RECTANGLE = "rectangle";
    public static final String TYPE_EXPORT = "export";
    public static final String TYPE_REPORT = "report";
    public static final String ADD_TEXT = "gfx/dokumentation/add_text_small.png";
    public static final String ADD_RECTANGLE = "gfx/dokumentation/add_small.png";
    public static final String EXPORT = "gfx/dokumentation/download_small.png";
    public static final String REPORT = "gfx/dokumentation/pdf_small.png";
    private static GUIDocumentationSidebar sidebar;

    public static GUIDocumentationSidebar getGUIDocumentationSidebar() {
        if (sidebar == null) {
            sidebar = new GUIDocumentationSidebar();
        }
        return sidebar;
    }

    @Override
    protected void addItemsToSidebar() {
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/gfx/dokumentation/add_text_small.png"));
        JSidebarButton newLabel = new JSidebarButton(messages.getString("docusidebar_msg1"), (Icon)icon, TYPE_TEXTFIELD);
        this.buttonList.add(newLabel);
        this.leistenpanel.add(newLabel);
        icon = new ImageIcon(this.getClass().getResource("/gfx/dokumentation/add_small.png"));
        newLabel = new JSidebarButton(messages.getString("docusidebar_msg3"), (Icon)icon, TYPE_RECTANGLE);
        this.buttonList.add(newLabel);
        this.leistenpanel.add(newLabel);
        icon = new ImageIcon(this.getClass().getResource("/gfx/dokumentation/download_small.png"));
        newLabel = new JSidebarButton(messages.getString("docusidebar_msg5"), (Icon)icon, TYPE_EXPORT);
        newLabel.setToolTipText(messages.getString("docusidebar_msg6"));
        newLabel.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                GUIContainer.getGUIContainer().exportAsImage();
            }
        });
        this.buttonList.add(newLabel);
        this.leistenpanel.add(newLabel);
        icon = new ImageIcon(this.getClass().getResource("/gfx/dokumentation/pdf_small.png"));
        newLabel = new JSidebarButton(messages.getString("docusidebar_msg7"), (Icon)icon, TYPE_REPORT);
        newLabel.setToolTipText(messages.getString("docusidebar_msg8"));
        newLabel.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                GUIDocumentationSidebar.this.generateReport();
            }
        });
        this.buttonList.add(newLabel);
        this.leistenpanel.add(newLabel);
    }

    private void generateReport() {
        JFileChooser fileChooser = new JFileChooser();
        FileNameExtensionFilter pdfFileFilter = new FileNameExtensionFilter("PDF", "pdf");
        fileChooser.addChoosableFileFilter(pdfFileFilter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        String path = SzenarioVerwaltung.getInstance().holePfad();
        if (path != null) {
            String szenarioFile = new File(path).getAbsolutePath();
            File preselectedFile = new File(szenarioFile.substring(0, szenarioFile.lastIndexOf(".")));
            fileChooser.setSelectedFile(preselectedFile);
        }
        if (fileChooser.showSaveDialog(JMainFrame.getJMainFrame()) == 0) {
            String reportPath = fileChooser.getSelectedFile().getAbsolutePath();
            reportPath = reportPath.endsWith(".pdf") ? reportPath : reportPath + ".pdf";
            int entscheidung = 0;
            if (reportPath != null && new File(reportPath).exists()) {
                entscheidung = JOptionPane.showConfirmDialog(JMainFrame.getJMainFrame(), messages.getString("guimainmemu_msg17"), messages.getString("guimainmemu_msg10"), 0);
            }
            if (entscheidung == 0) {
                try {
                    ReportGenerator.getInstance().generateReport(reportPath);
                }
                catch (DocumentException | IOException e) {
                    JOptionPane.showMessageDialog(JMainFrame.getJMainFrame(), messages.getString("guimainmemu_msg11"));
                }
            }
        }
    }
}

