/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.netzwerksicht;

import filius.gui.netzwerksicht.GUIDocuItem;
import filius.gui.netzwerksicht.GUIMainArea;
import filius.gui.netzwerksicht.JDocuElement;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.event.MouseInputAdapter;

public class GUIDocumentationPanel
extends GUIMainArea {
    private static final long serialVersionUID = 1L;

    public GUIDocumentationPanel(int width, int height) {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(width, height));
        this.setBounds(0, 0, width, height);
        this.setOpaque(false);
        this.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                GUIDocumentationPanel.this.removeElementsFocus();
            }
        });
    }

    public void removeElementsFocus() {
        this.getRootPane().requestFocusInWindow();
        Component[] c = this.getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (!(c[i] instanceof JDocuElement) || c[i] == this) continue;
            ((JDocuElement)c[i]).setLocalFocus(false);
        }
    }

    public void updateViewport(List<GUIDocuItem> docuItems, boolean elementsEnabled) {
        this.removeAll();
        for (GUIDocuItem item : docuItems) {
            if (item.getType() != 2) continue;
            this.addItem(elementsEnabled, item);
        }
        for (GUIDocuItem item : docuItems) {
            if (item.getType() != 1) continue;
            this.addItem(elementsEnabled, item);
        }
    }

    private void addItem(boolean elementsEnabled, GUIDocuItem item) {
        this.add(item.asDocuElement());
        item.asDocuElement().setEnabled(elementsEnabled);
    }
}

