/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.nachrichtensicht;

import filius.gui.nachrichtensicht.AggregatedExchangePanel;
import filius.gui.nachrichtensicht.ExchangeComponent;
import filius.rahmenprogramm.I18n;
import filius.software.system.SystemSoftware;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class AggregatedExchangeDialog
extends JDialog
implements ExchangeComponent,
I18n {
    private static AggregatedExchangeDialog instance = null;
    private AggregatedExchangePanel exchangePanel;

    public static AggregatedExchangeDialog getInstance(JFrame owner) {
        if (instance == null) {
            instance = new AggregatedExchangeDialog(owner);
        }
        return instance;
    }

    private AggregatedExchangeDialog(JFrame owner) {
        super(owner);
        owner.getLayeredPane().setLayer(this, JLayeredPane.PALETTE_LAYER);
        this.setTitle(messages.getString("lauscherdialog_msg1"));
        int screenHeight = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        int screenWidth = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        this.setBounds(screenWidth / 2, screenHeight / 10, screenWidth / 2, 4 * screenHeight / 5);
        Image image = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/gfx/allgemein/nachrichtenfenster_icon.png"));
        this.setIconImage(image);
        this.setModal(false);
        this.setDefaultCloseOperation(1);
        this.exchangePanel = new AggregatedExchangePanel();
        this.getContentPane().add((Component)this.exchangePanel, "Center");
        this.setVisible(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                AggregatedExchangeDialog.this.exchangePanel.updateTabTitle();
                AggregatedExchangeDialog.this.exchangePanel.clearUnavailableComponents();
            }
        });
    }

    @Override
    public void reset() {
        if (instance != null) {
            instance.setVisible(false);
        }
        instance = null;
    }

    @Override
    public void addTable(SystemSoftware system, String identifier) {
        this.exchangePanel.addTable(system, identifier);
    }

    @Override
    public void removeTable(String mac, JPanel panel) {
        this.exchangePanel.removeTable(mac, panel);
    }
}

