/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.gui.ControlPanel;
import filius.hardware.Verbindung;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.nachrichten.Lauscher;
import filius.rahmenprogramm.nachrichten.LauscherBeobachter;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SimulationControl
extends ControlPanel
implements I18n,
LauscherBeobachter {
    private JTextPane textPane;

    public SimulationControl() {
        this.reInit();
    }

    @Override
    protected void initContents() {
        JButton dropButton = new JButton(messages.getString("simulation_control_drop_packets"));
        dropButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ButtonModel model = ((JButton)evt.getSource()).getModel();
                if (model.isPressed() && !Verbindung.isDrop()) {
                    Verbindung.setDrop(true);
                } else if (!model.isPressed() && Verbindung.isDrop()) {
                    Verbindung.setDrop(false);
                }
            }
        });
        Box tempBox = Box.createHorizontalBox();
        tempBox.setOpaque(false);
        tempBox.setAlignmentX(0.0f);
        tempBox.setPreferredSize(new Dimension(400, 35));
        tempBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        tempBox.add(dropButton);
        this.rightBox.add((Component)tempBox, "North");
        this.textPane = new JTextPane();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.textPane);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        this.box.add(scrollPane);
        Lauscher.getLauscher().resetDroppedDataUnits();
        Lauscher.getLauscher().addBeobachter("dropped packets", this);
    }

    @Override
    public void update() {
        StringBuffer buffer = new StringBuffer();
        for (String dataUnit : Lauscher.getLauscher().getDroppedDataUnits()) {
            buffer.append(dataUnit).append("\n");
        }
        this.textPane.setText(buffer.toString());
    }

    @Override
    public void writeToStream(OutputStream outputStream) throws IOException {
    }
}

