/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.gui.anwendungssicht.GUIDesktopPanel;
import filius.hardware.NetzwerkInterface;
import filius.hardware.knoten.Host;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.rahmenprogramm.I18n;
import filius.software.system.Betriebssystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NetworkInfoPanel
extends JPanel
implements I18n {
    private GUIDesktopPanel dp;
    private JLabel ipLabel;
    private JLabel dnsLabel;
    private JLabel gatewayLabel;
    private JLabel netmaskLabel;
    private JLabel macLabel;
    private JTextField ipField;
    private JTextField dnsField;
    private JTextField gatewayField;
    private JTextField netmaskField;
    private JTextField macField;
    private JButton changeButton;
    private Betriebssystem bs;
    private boolean istGueltig = true;

    public NetworkInfoPanel(final GUIDesktopPanel dp) {
        super(new BorderLayout());
        this.dp = dp;
        this.ipLabel = new JLabel(messages.getString("network_msg1"));
        this.ipLabel.setSize(new Dimension(150, 15));
        this.ipLabel.setPreferredSize(new Dimension(150, 15));
        this.dnsLabel = new JLabel(messages.getString("network_msg2"));
        this.dnsLabel.setSize(new Dimension(150, 15));
        this.dnsLabel.setPreferredSize(new Dimension(150, 15));
        this.gatewayLabel = new JLabel(messages.getString("network_msg3"));
        this.gatewayLabel.setSize(new Dimension(150, 15));
        this.gatewayLabel.setPreferredSize(new Dimension(150, 15));
        this.netmaskLabel = new JLabel(messages.getString("network_msg4"));
        this.netmaskLabel.setSize(new Dimension(150, 15));
        this.netmaskLabel.setPreferredSize(new Dimension(150, 15));
        this.macLabel = new JLabel(messages.getString("network_msg9"));
        this.macLabel.setSize(new Dimension(150, 15));
        this.macLabel.setPreferredSize(new Dimension(150, 15));
        this.bs = this.dp.getBetriebssystem();
        NetzwerkInterface nic = ((Host)this.bs.getKnoten()).getNetzwerkInterfaces().get(0);
        this.ipField = new JTextField(nic.getIp());
        this.ipField.setEditable(false);
        this.ipField.setSize(new Dimension(150, 15));
        this.ipField.setPreferredSize(new Dimension(150, 15));
        this.ipField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                NetworkInfoPanel.this.ueberpruefen(EingabenUeberpruefung.musterIpAdresse, NetworkInfoPanel.this.ipField);
            }
        });
        this.dnsField = new JTextField(this.bs.getDNSServer());
        this.dnsField.setEditable(false);
        this.dnsField.setSize(new Dimension(150, 15));
        this.dnsField.setPreferredSize(new Dimension(150, 15));
        this.dnsField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                NetworkInfoPanel.this.ueberpruefen(EingabenUeberpruefung.musterIpAdresse, NetworkInfoPanel.this.dnsField);
            }
        });
        this.gatewayField = new JTextField(this.bs.getStandardGateway());
        this.gatewayField.setEditable(false);
        this.gatewayField.setSize(new Dimension(150, 15));
        this.gatewayField.setPreferredSize(new Dimension(150, 15));
        this.gatewayField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                NetworkInfoPanel.this.ueberpruefen(EingabenUeberpruefung.musterIpAdresse, NetworkInfoPanel.this.gatewayField);
            }
        });
        this.netmaskField = new JTextField(nic.getSubnetzMaske());
        this.netmaskField.setEditable(false);
        this.netmaskField.setSize(new Dimension(150, 15));
        this.netmaskField.setPreferredSize(new Dimension(150, 15));
        this.netmaskField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                NetworkInfoPanel.this.ueberpruefen(EingabenUeberpruefung.musterIpAdresse, NetworkInfoPanel.this.netmaskField);
            }
        });
        this.macField = new JTextField(nic.getMac());
        this.macField.setEditable(false);
        this.macField.setSize(new Dimension(150, 15));
        this.macField.setPreferredSize(new Dimension(150, 15));
        this.changeButton = new JButton(messages.getString("network_msg5"));
        this.changeButton.setToolTipText(messages.getString("network_msg6"));
        this.changeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NetworkInfoPanel.this.istGueltig = true;
                if (!EingabenUeberpruefung.isGueltig(NetworkInfoPanel.this.ipField.getText(), EingabenUeberpruefung.musterIpAdresse) || !NetworkInfoPanel.this.istGueltig) {
                    NetworkInfoPanel.this.istGueltig = false;
                }
                if (!EingabenUeberpruefung.isGueltig(NetworkInfoPanel.this.netmaskField.getText(), EingabenUeberpruefung.musterIpAdresse) || !NetworkInfoPanel.this.istGueltig) {
                    NetworkInfoPanel.this.istGueltig = false;
                }
                if (!EingabenUeberpruefung.isGueltig(NetworkInfoPanel.this.dnsField.getText(), EingabenUeberpruefung.musterIpAdresse) || !NetworkInfoPanel.this.istGueltig) {
                    NetworkInfoPanel.this.istGueltig = false;
                }
                if (!EingabenUeberpruefung.isGueltig(NetworkInfoPanel.this.gatewayField.getText(), EingabenUeberpruefung.musterIpAdresse) || !NetworkInfoPanel.this.istGueltig) {
                    NetworkInfoPanel.this.istGueltig = false;
                }
                if (NetworkInfoPanel.this.istGueltig) {
                    NetworkInfoPanel.this.bs.setzeIPAdresse(NetworkInfoPanel.this.ipField.getText());
                    NetworkInfoPanel.this.bs.setzeNetzmaske(NetworkInfoPanel.this.netmaskField.getText());
                    NetworkInfoPanel.this.bs.setDNSServer(NetworkInfoPanel.this.dnsField.getText());
                    NetworkInfoPanel.this.bs.setStandardGateway(NetworkInfoPanel.this.gatewayField.getText());
                } else {
                    JOptionPane.showMessageDialog(dp, I18n.messages.getString("network_msg7"));
                }
            }
        });
        Box backBox = Box.createVerticalBox();
        Box ipBox = Box.createHorizontalBox();
        ipBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ipBox.add(this.ipLabel);
        ipBox.add(Box.createHorizontalStrut(5));
        ipBox.add(this.ipField);
        Box maskBox = Box.createHorizontalBox();
        maskBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        maskBox.add(this.netmaskLabel);
        maskBox.add(Box.createHorizontalStrut(5));
        maskBox.add(this.netmaskField);
        Box dnsBox = Box.createHorizontalBox();
        dnsBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        dnsBox.add(this.dnsLabel);
        dnsBox.add(Box.createHorizontalStrut(5));
        dnsBox.add(this.dnsField);
        Box gateBox = Box.createHorizontalBox();
        gateBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gateBox.add(this.gatewayLabel);
        gateBox.add(Box.createHorizontalStrut(5));
        gateBox.add(this.gatewayField);
        Box macBox = Box.createHorizontalBox();
        macBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        macBox.add(this.macLabel);
        macBox.add(Box.createHorizontalStrut(5));
        macBox.add(this.macField);
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonBox.add(this.changeButton);
        backBox.setBorder(BorderFactory.createBevelBorder(2));
        backBox.add(ipBox);
        backBox.add(Box.createHorizontalStrut(5));
        backBox.add(maskBox);
        backBox.add(Box.createHorizontalStrut(5));
        backBox.add(gateBox);
        backBox.add(Box.createHorizontalStrut(5));
        backBox.add(dnsBox);
        backBox.add(Box.createHorizontalStrut(10));
        backBox.add(macBox);
        backBox.add(Box.createHorizontalStrut(5));
        this.add((Component)backBox, "Center");
    }

    public void ueberpruefen(Pattern pruefRegel, JTextField feld) {
        if (EingabenUeberpruefung.isGueltig(feld.getText(), pruefRegel)) {
            feld.setForeground(EingabenUeberpruefung.farbeRichtig);
            JTextField test = new JTextField();
            feld.setBorder(test.getBorder());
        } else {
            feld.setForeground(EingabenUeberpruefung.farbeFalsch);
            feld.setForeground(EingabenUeberpruefung.farbeFalsch);
            feld.setBorder(BorderFactory.createLineBorder(EingabenUeberpruefung.farbeFalsch, 1));
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.bs = this.dp.getBetriebssystem();
            NetzwerkInterface nic = ((Host)this.bs.getKnoten()).getNetzwerkInterfaces().get(0);
            this.ipField.setText(nic.getIp());
            this.dnsField.setText(this.bs.getDNSServer());
            this.gatewayField.setText(this.bs.getStandardGateway());
            this.netmaskField.setText(nic.getSubnetzMaske());
        }
        super.setVisible(b);
    }
}

