/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.gui.anwendungssicht.GUIApplicationWindow;
import filius.gui.anwendungssicht.GUIDesktopPanel;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.Information;
import filius.software.Anwendung;
import filius.software.system.Betriebssystem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class GUIInstallationsDialog
extends GUIApplicationWindow
implements I18n {
    private JList<String> softwareInstalliert;
    private JList<String> softwareVerfuegbar;
    private DefaultListModel<String> lmVerfuegbar;
    private DefaultListModel<String> lmInstalliert;
    private List<Map<String, String>> programme = Information.getInformation().ladeProgrammListe();

    public GUIInstallationsDialog(GUIDesktopPanel dp) {
        super(dp);
        this.setTitle(messages.getString("installationsdialog_msg1"));
        this.setIcon("/gfx/desktop/icon_softwareinstallation.png");
        Box gesamtBox = Box.createVerticalBox();
        Box listenBox = Box.createHorizontalBox();
        listenBox.add(Box.createHorizontalStrut(10));
        listenBox.add(this.createInstalledAppsBox());
        listenBox.add(Box.createHorizontalGlue());
        listenBox.add(this.createSelectionButtonBox());
        listenBox.add(this.createAvailableAppsBox());
        listenBox.add(Box.createHorizontalStrut(10));
        gesamtBox.add(Box.createVerticalStrut(10));
        gesamtBox.add(listenBox);
        gesamtBox.add(Box.createVerticalStrut(10));
        gesamtBox.add(this.createLowerButtonBox());
        gesamtBox.add(Box.createVerticalStrut(10));
        this.add((Component)gesamtBox, "Center");
    }

    private Box createInstalledAppsBox() {
        Box wrapperInstBox = Box.createVerticalBox();
        wrapperInstBox.add(new JLabel(messages.getString("installationsdialog_msg3")));
        wrapperInstBox.add(Box.createVerticalStrut(10));
        this.lmInstalliert = new DefaultListModel();
        Anwendung[] anwendungen = this.desktop.getBetriebssystem().holeArrayInstallierteSoftware();
        for (int i = 0; i < anwendungen.length; ++i) {
            if (anwendungen[i] == null) continue;
            this.lmInstalliert.addElement(anwendungen[i].holeAnwendungsName());
        }
        this.softwareInstalliert = new JList();
        this.softwareInstalliert.setModel(this.lmInstalliert);
        this.softwareInstalliert.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GUIInstallationsDialog.this.entfernen();
                }
            }
        });
        JScrollPane scrollAnwendungInstallieren = new JScrollPane(this.softwareInstalliert);
        scrollAnwendungInstallieren.setPreferredSize(new Dimension(170, 200));
        wrapperInstBox.add(scrollAnwendungInstallieren);
        return wrapperInstBox;
    }

    private Box createAvailableAppsBox() {
        Box wrapperAvailBox = Box.createVerticalBox();
        wrapperAvailBox.add(new JLabel(messages.getString("installationsdialog_msg4")));
        wrapperAvailBox.add(Box.createVerticalStrut(10));
        this.lmVerfuegbar = new DefaultListModel();
        if (this.programme != null) {
            for (Map<String, String> programmInfo : this.programme) {
                String awKlasse = programmInfo.get("Klasse");
                if (this.desktop.getBetriebssystem().holeSoftware(awKlasse) != null) continue;
                this.lmVerfuegbar.addElement(programmInfo.get("Anwendung"));
            }
        }
        this.softwareVerfuegbar = new JList();
        this.softwareVerfuegbar.setModel(this.lmVerfuegbar);
        this.softwareVerfuegbar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GUIInstallationsDialog.this.hinzufuegen();
                }
            }
        });
        JScrollPane scrollAnwendungVerfuegbar = new JScrollPane(this.softwareVerfuegbar);
        scrollAnwendungVerfuegbar.setPreferredSize(new Dimension(170, 200));
        wrapperAvailBox.add(scrollAnwendungVerfuegbar);
        return wrapperAvailBox;
    }

    private Box createSelectionButtonBox() {
        Box topButtonBox = Box.createVerticalBox();
        JButton addButton = new JButton(new ImageIcon(this.getClass().getResource("/gfx/allgemein/pfeil_links.png")));
        addButton.setMargin(new Insets(2, 2, 2, 2));
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GUIInstallationsDialog.this.hinzufuegen();
            }
        });
        topButtonBox.add(addButton);
        topButtonBox.add(Box.createVerticalStrut(10));
        JButton removeButton = new JButton(new ImageIcon(this.getClass().getResource("/gfx/allgemein/pfeil_rechts.png")));
        removeButton.setMargin(new Insets(2, 2, 2, 2));
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GUIInstallationsDialog.this.entfernen();
            }
        });
        topButtonBox.add(removeButton);
        return topButtonBox;
    }

    private Box createLowerButtonBox() {
        Box bottomButtonBox = Box.createVerticalBox();
        JButton confirmButton = new JButton(messages.getString("installationsdialog_msg2"));
        confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GUIInstallationsDialog.this.aenderungenSpeichern();
                GUIInstallationsDialog.this.setVisible(false);
            }
        });
        confirmButton.setAlignmentX(0.5f);
        bottomButtonBox.add(confirmButton);
        return bottomButtonBox;
    }

    private void hinzufuegen() {
        int[] selektiertIndices;
        Vector<String> vLoeschen = new Vector<String>();
        for (int i : selektiertIndices = this.softwareVerfuegbar.getSelectedIndices()) {
            this.lmInstalliert.addElement(this.lmVerfuegbar.get(i));
            vLoeschen.add(this.lmVerfuegbar.get(i));
        }
        Enumeration e = vLoeschen.elements();
        while (e.hasMoreElements()) {
            String oZuLoeschen = (String)e.nextElement();
            this.lmVerfuegbar.removeElement(oZuLoeschen);
        }
    }

    private void entfernen() {
        int[] selektiertIndices = this.softwareInstalliert.getSelectedIndices();
        Vector<String> hinzu = new Vector<String>();
        for (int i : selektiertIndices) {
            this.lmVerfuegbar.addElement(this.lmInstalliert.getElementAt(i));
            hinzu.add(this.lmInstalliert.getElementAt(i));
        }
        Enumeration e = hinzu.elements();
        while (e.hasMoreElements()) {
            String hinzuObjekt = (String)e.nextElement();
            this.lmInstalliert.removeElement(hinzuObjekt);
        }
    }

    private void aenderungenSpeichern() {
        Betriebssystem bs = this.desktop.getBetriebssystem();
        for (Map<String, String> appInfo : this.programme) {
            Anwendung anwendung;
            int i;
            for (i = 0; i < this.lmInstalliert.getSize(); ++i) {
                if (!this.lmInstalliert.getElementAt(i).equals(appInfo.get("Anwendung")) || bs.holeSoftware(appInfo.get("Klasse").toString()) != null) continue;
                bs.installAppIfAvailable(appInfo.get("Klasse").toString());
                anwendung = bs.holeSoftware(appInfo.get("Klasse").toString());
                anwendung.starten();
            }
            for (i = 0; i < this.lmVerfuegbar.getSize(); ++i) {
                if (!this.lmVerfuegbar.getElementAt(i).equals(appInfo.get("Anwendung")) || (anwendung = bs.holeSoftware(appInfo.get("Klasse").toString())) == null) continue;
                anwendung.beenden();
                bs.entferneSoftware(appInfo.get("Klasse").toString());
            }
        }
        this.desktop.updateAppPane();
    }

    @Override
    public void update(Observable arg0, Object arg1) {
    }
}

