/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.gui.anwendungssicht.DMTNFileChooser;
import filius.gui.anwendungssicht.GUIApplicationWindow;
import filius.gui.anwendungssicht.GUIDesktopPanel;
import filius.software.system.Betriebssystem;
import filius.software.system.Datei;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.tree.DefaultMutableTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIApplicationTextEditorWindow
extends GUIApplicationWindow {
    private static Logger LOG = LoggerFactory.getLogger(GUIApplicationTextEditorWindow.class);
    private static final long serialVersionUID = 1L;
    private JTextArea editorField = new JTextArea("");
    private JPanel backPanel;
    private Datei aktuelleDatei = null;
    private String original = "";
    private DefaultMutableTreeNode arbeitsVerzeichnis;

    public GUIApplicationTextEditorWindow(GUIDesktopPanel desktop, String appName) {
        super(desktop, appName);
        this.editorField.setEditable(true);
        this.editorField.setFont(new Font("Courier New", 0, 11));
        this.arbeitsVerzeichnis = this.holeAnwendung().getSystemSoftware().getDateisystem().getRoot();
        String dateiName = this.holeParameter()[0];
        if (!dateiName.equals("")) {
            Datei datei;
            if (this.arbeitsVerzeichnis == null) {
                this.arbeitsVerzeichnis = this.holeAnwendung().getSystemSoftware().getDateisystem().getRoot();
            }
            if ((datei = this.holeAnwendung().getSystemSoftware().getDateisystem().holeDatei(this.arbeitsVerzeichnis, dateiName)) != null) {
                this.aktuelleDatei = datei;
            }
            this.updateFromFile();
        }
        JScrollPane tpPane = new JScrollPane(this.editorField);
        tpPane.setBorder(null);
        Box editorBox = Box.createHorizontalBox();
        editorBox.add(tpPane);
        editorBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.backPanel = new JPanel(new BorderLayout());
        this.backPanel.add((Component)editorBox, "Center");
        this.add((Component)this.backPanel, "Center");
        JPanel menubar = new JPanel(new FlowLayout());
        JButton newFile = new JButton(messages.getString("texteditor_msg3"));
        newFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GUIApplicationTextEditorWindow.this.neu();
            }
        });
        menubar.add(newFile);
        JButton openFile = new JButton(messages.getString("texteditor_msg4"));
        openFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GUIApplicationTextEditorWindow.this.oeffnen();
            }
        });
        menubar.add(openFile);
        JButton saveFile = new JButton(messages.getString("texteditor_msg5"));
        saveFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GUIApplicationTextEditorWindow.this.speichern();
            }
        });
        menubar.add(saveFile);
        JButton saveAsFile = new JButton(messages.getString("texteditor_msg6"));
        saveAsFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GUIApplicationTextEditorWindow.this.speichernUnter();
            }
        });
        menubar.add(saveAsFile);
        this.backPanel.add((Component)menubar, "North");
    }

    public void speichern() {
        if (this.aktuelleDatei != null) {
            this.original = this.editorField.getText();
            this.aktuelleDatei.setDateiInhalt(this.original);
        } else {
            this.speichernUnter();
        }
    }

    public void speichernUnter() {
        DMTNFileChooser fc = new DMTNFileChooser((Betriebssystem)this.holeAnwendung().getSystemSoftware());
        int rueckgabe = fc.saveDialog();
        if (rueckgabe == 1) {
            String dateiNameNeu = fc.getAktuellerDateiname();
            Datei tmpFile = new Datei(dateiNameNeu, messages.getString("texteditor_msg8"), this.editorField.getText());
            this.holeAnwendung().getSystemSoftware().getDateisystem().speicherDatei(fc.getAktuellerOrdner(), tmpFile);
            this.changeCurrentFile(tmpFile);
        }
    }

    public void changeCurrentFile(Datei tmpFile) {
        if (this.aktuelleDatei != null) {
            this.aktuelleDatei.deleteObserver(this);
        }
        this.aktuelleDatei = tmpFile;
        this.updateFromFile();
        if (this.aktuelleDatei != null) {
            this.aktuelleDatei.addObserver(this);
        }
    }

    public void oeffnen() {
        DMTNFileChooser fc = new DMTNFileChooser((Betriebssystem)this.holeAnwendung().getSystemSoftware());
        int rueckgabe = fc.openDialog();
        if (rueckgabe == 1) {
            String aktuellerDateiname = fc.getAktuellerDateiname();
            Datei tmpFile = this.holeAnwendung().getSystemSoftware().getDateisystem().holeDatei(fc.getAktuellerOrdner(), aktuellerDateiname);
            this.changeCurrentFile(tmpFile);
        } else {
            LOG.debug("ERROR (" + this.hashCode() + "): Fehler beim oeffnen einer Datei");
        }
    }

    private void updateFromFile() {
        if (this.aktuelleDatei != null) {
            this.setTitle(this.anwendung, this.aktuelleDatei.getName());
            this.original = this.aktuelleDatei.getDateiInhalt();
            this.editorField.setText(this.original);
        } else {
            this.setTitle(this.anwendung);
            LOG.debug("Fehler beim oeffnen einer Datei: keine Datei ausgewaehlt");
        }
    }

    @Override
    public void starten(String[] param) {
        String dateiName = this.holeParameter()[0];
        if (!dateiName.equals("")) {
            Datei datei = this.holeAnwendung().getSystemSoftware().getDateisystem().holeDatei(this.arbeitsVerzeichnis, dateiName);
            if (datei != null) {
                this.aktuelleDatei = datei;
            }
            this.updateFromFile();
        }
    }

    public void neu() {
        this.editorField.setText("");
        this.setTitle(this.anwendung);
        this.changeCurrentFile(null);
    }

    public void updateUnchangedTextFromFile() {
        if (this.original != null && this.editorField != null && this.aktuelleDatei != null && this.original.equals(this.editorField.getText())) {
            this.original = this.aktuelleDatei.getDateiInhalt();
            this.editorField.setText(this.original);
        }
    }

    @Override
    public void update(Observable observable, Object arg1) {
        if (observable == this.aktuelleDatei) {
            this.updateUnchangedTextFromFile();
        }
    }
}

