/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.gui.anwendungssicht.GUIApplicationWindow;
import filius.gui.anwendungssicht.GUIDesktopPanel;
import filius.software.lokal.Terminal;
import filius.software.system.Dateisystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIApplicationTerminalWindow
extends GUIApplicationWindow {
    private static Logger LOG = LoggerFactory.getLogger(GUIApplicationTerminalWindow.class);
    private static final Color BACKGROUND = new Color(0, 0, 0);
    private static final Color FOREGROUND = new Color(222, 222, 222);
    private static final String MENU_LINE = "==========================================================================\n";
    private JTextArea terminalField;
    private JPanel backPanel;
    private JLabel inputLabel;
    private JTextField inputField;
    private JScrollPane tpPane;
    private boolean jobRunning = false;
    private String enteredCommand;
    private String[] enteredParameters;
    private int lastScrollPaneSize;
    private boolean multipleObserverEvents = false;
    private ArrayList<String> commandHistory = new ArrayList();
    private int commandHistoryPointer = -1;

    public GUIApplicationTerminalWindow(GUIDesktopPanel desktop, String appName) {
        super(desktop, appName);
        this.terminalField = new JTextArea("");
        this.terminalField.setEditable(false);
        this.terminalField.setCaretColor(FOREGROUND);
        this.terminalField.setForeground(FOREGROUND);
        this.terminalField.setBackground(BACKGROUND);
        this.terminalField.setFont(new Font("Monospaced", 0, 11));
        this.terminalField.setFocusable(false);
        this.terminalField.setBorder(null);
        this.terminalField.setLineWrap(true);
        this.initInput();
        this.inputLabel = new JLabel(">");
        this.inputLabel.setBackground(BACKGROUND);
        this.inputLabel.setForeground(FOREGROUND);
        this.inputLabel.setFont(new Font("Monospaced", 0, 11));
        Box terminalBox = Box.createHorizontalBox();
        terminalBox.setBackground(BACKGROUND);
        terminalBox.add(this.terminalField);
        terminalBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 1, 5));
        Box inputBox = Box.createHorizontalBox();
        inputBox.setBackground(BACKGROUND);
        inputBox.add(this.inputLabel);
        inputBox.add(Box.createHorizontalStrut(1));
        inputBox.add(this.inputField);
        inputBox.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.backPanel = new JPanel(new BorderLayout());
        this.backPanel.setBackground(BACKGROUND);
        this.backPanel.setFocusCycleRoot(true);
        this.backPanel.add((Component)terminalBox, "Center");
        this.backPanel.add((Component)inputBox, "South");
        this.tpPane = new JScrollPane(this.backPanel);
        this.tpPane.setBorder(null);
        this.tpPane.setBackground(BACKGROUND);
        this.tpPane.setFocusable(false);
        this.tpPane.setVerticalScrollBarPolicy(22);
        this.tpPane.setHorizontalScrollBarPolicy(31);
        this.tpPane.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GUIApplicationTerminalWindow.this.scrollToBottomAndFocusInput();
            }
        });
        this.add((Component)this.tpPane, "Center");
        this.terminalField.setText("");
        this.showStartScreen();
        this.inputLabel.setText(Dateisystem.absoluterPfad(((Terminal)this.holeAnwendung()).getAktuellerOrdner()) + "> ");
        this.scrollToBottomAndFocusInput();
    }

    private void showStartScreen() {
        this.appendText(messages.getString("sw_terminal_msg57") + "\n");
        this.appendText(MENU_LINE);
        this.appendText(messages.getString("sw_terminal_msg26") + "\n");
        this.appendText(MENU_LINE);
    }

    private void initInput() {
        this.inputField = new JTextField("");
        this.inputField.setEditable(true);
        this.inputField.setBackground(BACKGROUND);
        this.inputField.setForeground(FOREGROUND);
        this.inputField.setCaretColor(FOREGROUND);
        this.inputField.setBorder(null);
        this.inputField.setFont(new Font("Courier New", 0, 11));
        this.inputField.setOpaque(false);
        this.inputField.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "doNothing");
        this.inputField.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "doNothing");
        this.inputField.getActionMap().put("doNothing", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.inputField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    GUIApplicationTerminalWindow.this.commandHistoryPointer = -1;
                    if (!StringUtils.isBlank(GUIApplicationTerminalWindow.this.inputField.getText())) {
                        GUIApplicationTerminalWindow.this.appendText("\n" + GUIApplicationTerminalWindow.this.inputLabel.getText() + GUIApplicationTerminalWindow.this.inputField.getText() + "\n");
                        StringTokenizer tk = new StringTokenizer(GUIApplicationTerminalWindow.this.inputField.getText(), " ");
                        GUIApplicationTerminalWindow.this.enteredCommand = tk.nextToken();
                        GUIApplicationTerminalWindow.access$602(GUIApplicationTerminalWindow.this, new String[3 + tk.countTokens()]);
                        for (int i = 0; i < 3 + tk.countTokens(); ++i) {
                            ((GUIApplicationTerminalWindow)GUIApplicationTerminalWindow.this).enteredParameters[i] = new String();
                        }
                        int iti = 0;
                        while (tk.hasMoreTokens()) {
                            ((GUIApplicationTerminalWindow)GUIApplicationTerminalWindow.this).enteredParameters[iti] = tk.nextToken();
                            ++iti;
                        }
                        GUIApplicationTerminalWindow.this.commandHistory.add(GUIApplicationTerminalWindow.this.inputField.getText());
                        if (GUIApplicationTerminalWindow.this.enteredCommand.equals("exit")) {
                            GUIApplicationTerminalWindow.this.close();
                        } else if (GUIApplicationTerminalWindow.this.enteredCommand.equals("reset") || GUIApplicationTerminalWindow.this.enteredCommand.equals("cls")) {
                            GUIApplicationTerminalWindow.this.terminalField.setText("");
                            GUIApplicationTerminalWindow.this.showStartScreen();
                            GUIApplicationTerminalWindow.this.scrollToBottomAndFocusInput();
                        } else {
                            GUIApplicationTerminalWindow.this.prepareJobStart();
                            ((Terminal)GUIApplicationTerminalWindow.this.holeAnwendung()).terminalEingabeAuswerten(GUIApplicationTerminalWindow.this.enteredCommand, GUIApplicationTerminalWindow.this.enteredParameters);
                        }
                    } else {
                        GUIApplicationTerminalWindow.this.appendText("  \n");
                    }
                    GUIApplicationTerminalWindow.this.inputField.setText("");
                } else if (e.getKeyCode() == 67 && (e.getModifiersEx() & 0x80) == 128) {
                    ((Terminal)GUIApplicationTerminalWindow.this.holeAnwendung()).setInterrupt(true);
                    LOG.debug("execution aborted with ctrl+c");
                } else if (e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                    if (e.getKeyCode() == 38) {
                        GUIApplicationTerminalWindow.this.commandHistoryPointer++;
                    }
                    if (e.getKeyCode() == 40) {
                        GUIApplicationTerminalWindow.this.commandHistoryPointer--;
                    }
                    if (GUIApplicationTerminalWindow.this.commandHistoryPointer < -1) {
                        GUIApplicationTerminalWindow.this.commandHistoryPointer = -1;
                    }
                    if (GUIApplicationTerminalWindow.this.commandHistoryPointer >= GUIApplicationTerminalWindow.this.commandHistory.size()) {
                        GUIApplicationTerminalWindow.this.commandHistoryPointer = GUIApplicationTerminalWindow.this.commandHistory.size() - 1;
                    }
                    try {
                        if (GUIApplicationTerminalWindow.this.commandHistoryPointer != -1) {
                            GUIApplicationTerminalWindow.this.inputField.setText((String)GUIApplicationTerminalWindow.this.commandHistory.get(GUIApplicationTerminalWindow.this.commandHistory.size() - 1 - GUIApplicationTerminalWindow.this.commandHistoryPointer));
                        } else if (GUIApplicationTerminalWindow.this.commandHistoryPointer == -1) {
                            GUIApplicationTerminalWindow.this.inputField.setText("");
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
                GUIApplicationTerminalWindow.this.scrollToBottom(true);
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
    }

    @Override
    public void update(Observable observable, Object notificationObject) {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (GUIApplicationTerminalWindow), update(" + observable + "," + notificationObject + ")");
        if (notificationObject != null && this.jobRunning) {
            if (notificationObject instanceof Boolean) {
                this.multipleObserverEvents = (Boolean)notificationObject;
            } else {
                this.appendText(notificationObject.toString());
            }
            if (!this.multipleObserverEvents) {
                this.inputLabel.setText(Dateisystem.absoluterPfad(((Terminal)this.holeAnwendung()).getAktuellerOrdner()) + "> ");
                this.prepareJobFinished();
            }
        }
        this.scrollToBottomAndFocusInput();
    }

    private void prepareJobFinished() {
        this.inputLabel.setVisible(true);
        this.jobRunning = false;
    }

    private void prepareJobStart() {
        this.inputLabel.setVisible(false);
        this.jobRunning = true;
    }

    private void appendText(String text) {
        this.terminalField.append(text);
    }

    private void scrollToBottomAndFocusInput() {
        this.scrollToBottom(false);
        this.focusInput();
    }

    private void focusInput() {
        if (null != this.inputField) {
            this.inputField.requestFocusInWindow();
            this.inputField.grabFocus();
        }
    }

    private void scrollToBottom(boolean force) {
        if (force || this.lastScrollPaneSize < this.tpPane.getVerticalScrollBar().getMaximum()) {
            this.lastScrollPaneSize = this.tpPane.getVerticalScrollBar().getMaximum();
            this.tpPane.getVerticalScrollBar().setValue(this.tpPane.getVerticalScrollBar().getMaximum());
        }
    }

    static /* synthetic */ String[] access$602(GUIApplicationTerminalWindow x0, String[] x1) {
        x0.enteredParameters = x1;
        return x1;
    }
}

