/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.gui.anwendungssicht.DMTNFileChooser;
import filius.gui.anwendungssicht.GUIApplicationWindow;
import filius.gui.anwendungssicht.GUIDesktopPanel;
import filius.rahmenprogramm.Base64;
import filius.rahmenprogramm.Information;
import filius.software.system.Betriebssystem;
import filius.software.system.Datei;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIApplicationImageViewerWindow
extends GUIApplicationWindow {
    private static Logger LOG = LoggerFactory.getLogger(GUIApplicationImageViewerWindow.class);
    private JPanel backPanel = new JPanel(new BorderLayout());

    public GUIApplicationImageViewerWindow(GUIDesktopPanel desktop, String appName) {
        super(desktop, appName);
        JButton open = new JButton(messages.getString("imageviewer_msg2"));
        open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUIApplicationImageViewerWindow.this.oeffnen();
            }
        });
        this.backPanel.add((Component)open, "North");
        this.add((Component)this.backPanel, "Center");
    }

    public void oeffnen() {
        DMTNFileChooser fc = new DMTNFileChooser((Betriebssystem)this.holeAnwendung().getSystemSoftware());
        int rueckgabe = fc.openDialog();
        if (rueckgabe == 1) {
            Datei aktuelleDatei = this.holeAnwendung().getSystemSoftware().getDateisystem().holeDatei(fc.getAktuellerOrdner(), fc.getAktuellerDateiname());
            if (aktuelleDatei != null) {
                this.setTitle(aktuelleDatei.getName());
                Base64.decodeToFile(aktuelleDatei.getDateiInhalt(), Information.getInformation().getTempPfad() + aktuelleDatei.getName());
                String path = Information.getInformation().getTempPfad() + aktuelleDatei.getName();
                ImageIcon image = new ImageIcon(path);
                JLabel titelgrafik = new JLabel(image);
                this.backPanel.add((Component)titelgrafik, "Center");
                this.backPanel.updateUI();
            } else {
                LOG.debug("ERROR (" + this.hashCode() + "): Fehler beim oeffnen einer Datei: keine Datei ausgewaehlt");
            }
        } else {
            LOG.debug("ERROR (" + this.hashCode() + "): Fehler beim oeffnen einer Datei");
        }
    }

    @Override
    public void update(Observable arg0, Object arg1) {
    }
}

