/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.gui.JExtendedTable;
import filius.gui.anwendungssicht.GUIApplicationWindow;
import filius.gui.anwendungssicht.GUIDesktopPanel;
import filius.software.firewall.Firewall;
import filius.software.firewall.FirewallRule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class GUIApplicationFirewallWindow
extends GUIApplicationWindow {
    private static final String ALL_PROT_STRING = "*";
    private static final String UDP_STRING = "UDP";
    private static final String TCP_STRING = "TCP";
    private JTable tTabellePort;
    private JTextField tfPort;
    private JComboBox cbProtocol;
    private JComboBox cbAlleAbsender;
    private JTextArea log;
    private JCheckBox cbEinAus = new JCheckBox();
    private JCheckBox cbIcmp = new JCheckBox();
    private JCheckBox cbUdp = new JCheckBox();

    private void initKomponenten() {
        Box boxFirewall = Box.createVerticalBox();
        boxFirewall.add(Box.createVerticalStrut(10));
        JPanel globalBox = new JPanel(new GridBagLayout());
        this.cbEinAus = new JCheckBox(messages.getString("firewall_msg1"));
        this.cbEinAus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((Firewall)GUIApplicationFirewallWindow.this.holeAnwendung()).setActivated(GUIApplicationFirewallWindow.this.cbEinAus.isSelected());
                GUIApplicationFirewallWindow.this.updateAttribute();
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.fill = 2;
        globalBox.add((Component)this.cbEinAus, constraints);
        this.cbIcmp = new JCheckBox(messages.getString("firewall_msg13"));
        this.cbIcmp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((Firewall)GUIApplicationFirewallWindow.this.holeAnwendung()).setDropICMP(!GUIApplicationFirewallWindow.this.cbIcmp.isSelected());
                GUIApplicationFirewallWindow.this.updateAttribute();
            }
        });
        globalBox.add((Component)this.cbIcmp, constraints);
        this.cbUdp = new JCheckBox(messages.getString("firewall_msg14"));
        this.cbUdp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((Firewall)GUIApplicationFirewallWindow.this.holeAnwendung()).setFilterUdp(GUIApplicationFirewallWindow.this.cbUdp.isSelected());
                GUIApplicationFirewallWindow.this.updateAttribute();
            }
        });
        globalBox.add((Component)this.cbUdp, constraints);
        boxFirewall.add(globalBox);
        boxFirewall.add(Box.createVerticalStrut(10));
        JEditorPane text = new JEditorPane();
        text.setEditable(false);
        text.setText(messages.getString("firewall_msg2"));
        text.setBackground(boxFirewall.getBackground());
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(10));
        JLabel label = new JLabel(messages.getString("firewall_msg3"));
        box.add(label);
        box.add(Box.createHorizontalStrut(10));
        this.tfPort = new JTextField();
        this.tfPort.setPreferredSize(new Dimension(30, 15));
        box.add(this.tfPort);
        box.add(Box.createHorizontalStrut(10));
        String[] protValues = new String[]{TCP_STRING, UDP_STRING, ALL_PROT_STRING};
        this.cbProtocol = new JComboBox<String>(protValues);
        box.add(this.cbProtocol);
        box.add(Box.createHorizontalStrut(10));
        this.cbAlleAbsender = new JComboBox();
        this.cbAlleAbsender.addItem(messages.getString("firewall_msg4"));
        this.cbAlleAbsender.addItem(messages.getString("firewall_msg5"));
        this.cbAlleAbsender.setSelectedIndex(0);
        box.add(this.cbAlleAbsender);
        box.add(Box.createHorizontalStrut(10));
        boxFirewall.add(box);
        boxFirewall.add(Box.createVerticalStrut(10));
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(10));
        JButton button = new JButton(messages.getString("firewall_msg6"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIApplicationFirewallWindow.this.hinzuRegel();
                GUIApplicationFirewallWindow.this.updateAttribute();
            }
        });
        box.add(button);
        box.add(Box.createHorizontalStrut(10));
        button = new JButton(messages.getString("firewall_msg7"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIApplicationFirewallWindow.this.loescheRegel();
                GUIApplicationFirewallWindow.this.updateAttribute();
            }
        });
        box.add(button);
        box.add(Box.createHorizontalStrut(10));
        boxFirewall.add(box);
        boxFirewall.add(Box.createVerticalStrut(10));
        DefaultTableModel tabellenModell = new DefaultTableModel(0, 3);
        this.tTabellePort = new JExtendedTable((TableModel)tabellenModell, false);
        this.tTabellePort.setSelectionMode(0);
        this.tTabellePort.setIntercellSpacing(new Dimension(10, 5));
        this.tTabellePort.setRowHeight(30);
        this.tTabellePort.setShowGrid(false);
        this.tTabellePort.setFillsViewportHeight(true);
        this.tTabellePort.setBackground(Color.WHITE);
        this.tTabellePort.setShowHorizontalLines(true);
        TableColumnModel columnModel = this.tTabellePort.getColumnModel();
        columnModel.getColumn(0).setHeaderValue(messages.getString("jfirewalldialog_msg31"));
        columnModel.getColumn(0).setWidth(20);
        columnModel.getColumn(1).setHeaderValue(messages.getString("firewall_msg8"));
        columnModel.getColumn(1).setWidth(20);
        columnModel.getColumn(2).setHeaderValue(messages.getString("firewall_msg9"));
        columnModel.getColumn(2).setWidth(300);
        JScrollPane scrollPane = new JScrollPane(this.tTabellePort);
        scrollPane.setPreferredSize(new Dimension(90, 250));
        boxFirewall.add(scrollPane);
        boxFirewall.add(Box.createVerticalStrut(10));
        JTabbedPane tp = new JTabbedPane();
        tp.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                GUIApplicationFirewallWindow.this.updateAttribute();
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)boxFirewall, "Center");
        tp.add(messages.getString("firewall_msg10"), panel);
        this.log = new JTextArea();
        scrollPane = new JScrollPane(this.log);
        tp.add(messages.getString("firewall_msg11"), scrollPane);
        this.add((Component)tp, "Center");
    }

    private void hinzuRegel() {
        try {
            boolean unterscheideNetzwerk;
            int port = Integer.parseInt(this.tfPort.getText());
            boolean bl = unterscheideNetzwerk = this.cbAlleAbsender.getSelectedIndex() == 1;
            short protocol = this.cbProtocol.getSelectedIndex() == 0 ? (short)6 : (this.cbProtocol.getSelectedIndex() == 1 ? (short)17 : -1);
            FirewallRule newRule = new FirewallRule("", "", "", "", port, protocol, 1);
            if (unterscheideNetzwerk) {
                newRule.srcIP = FirewallRule.SAME_NETWORK;
            }
            ((Firewall)this.holeAnwendung()).addRule(newRule);
            this.tfPort.setText("");
            this.log.append(messages.getString("sw_firewall_msg5") + " " + port + "/" + this.cbProtocol.getSelectedItem() + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateAttribute();
    }

    private void loescheRegel() {
        if (this.tTabellePort.getSelectedRow() != -1) {
            ((Firewall)this.holeAnwendung()).deleteRule(this.tTabellePort.getSelectedRow());
            this.log.append(messages.getString("sw_firewall_msg7") + "\n");
        }
        this.updateAttribute();
    }

    public GUIApplicationFirewallWindow(GUIDesktopPanel desktop, String appName) {
        super(desktop, appName);
        this.initKomponenten();
        this.updateAttribute();
    }

    public void updateAttribute() {
        DefaultTableModel model = (DefaultTableModel)this.tTabellePort.getModel();
        model.setRowCount(0);
        Vector<FirewallRule> ruleset = ((Firewall)this.holeAnwendung()).getRuleset();
        for (int i = 0; i < ruleset.size(); ++i) {
            model.addRow(this.ruleToVector(ruleset.get(i)));
        }
        this.cbEinAus.setSelected(((Firewall)this.holeAnwendung()).isActivated());
        this.cbIcmp.setSelected(!((Firewall)this.holeAnwendung()).getDropICMP());
        this.cbIcmp.setEnabled(this.cbEinAus.isSelected());
        this.cbUdp.setSelected(((Firewall)this.holeAnwendung()).getFilterUdp());
        this.cbUdp.setEnabled(this.cbEinAus.isSelected());
    }

    private Vector<String> ruleToVector(FirewallRule rule) {
        Vector<String> resultVec = new Vector<String>();
        if (rule.protocol == 6) {
            resultVec.addElement(TCP_STRING);
        } else if (rule.protocol == 17) {
            resultVec.addElement(UDP_STRING);
        } else {
            resultVec.addElement(ALL_PROT_STRING);
        }
        if (rule.port >= 0) {
            resultVec.addElement(Integer.toString(rule.port));
        } else {
            resultVec.addElement("");
        }
        if (rule.srcIP.equals(FirewallRule.SAME_NETWORK)) {
            resultVec.addElement(messages.getString("firewall_msg12"));
        } else {
            resultVec.addElement(messages.getString("firewall_msg4"));
        }
        return resultVec;
    }

    @Override
    public void update(Observable arg0, Object nachricht) {
        this.log.append(nachricht + "\n");
    }
}

