/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.gui.JExtendedTable;
import filius.gui.anwendungssicht.GUIApplicationWindow;
import filius.gui.anwendungssicht.GUIDesktopPanel;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.ResourceUtil;
import filius.software.email.Email;
import filius.software.email.EmailAnwendung;
import filius.software.email.EmailKonto;
import filius.software.email.EmailUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIApplicationEmailAnwendungWindow
extends GUIApplicationWindow {
    private static Logger LOG = LoggerFactory.getLogger(GUIApplicationEmailAnwendungWindow.class);
    private static final long serialVersionUID = 1L;
    private JTabbedPane tabbedPane;
    private JPanel gesendetPanel;
    private JPanel eingangPanel;
    private JScrollPane gesendetScroll;
    private JScrollPane eingangScroll;
    private JEditorPane emailVorschau;
    private JButton buttonMailsAbholen;
    private JButton buttonMailVerfassen;
    private JButton buttonMailAntworten;
    private JButton buttonKonten;
    private JButton buttonEmailLoeschen;
    private JProgressBar progressBar;
    private Box middleBox;
    private DefaultTableModel posteingangModell = new DefaultTableModel(0, 2);
    private DefaultTableModel gesendeteModell = new DefaultTableModel(0, 2);
    private JTable posteingangTable;
    private JTable gesendeteTable;
    private JTextField tfName;
    private JTextField tfEmailAdresse;
    private JTextField tfPOP3Server;
    private JTextField tfPOP3Port;
    private JTextField tfSMTPServer;
    private JTextField tfSMTPPort;
    private JTextField tfBenutzername;
    private JPasswordField tfPasswort;
    private Email aktuelleMail = null;
    private int zeilenNummer;
    private int auswahlfuerloeschen;
    ListMode paa = ListMode.UNKNOWN;
    private JPanel progressPanel;
    private JPanel verfassenPanel;

    public GUIApplicationEmailAnwendungWindow(GUIDesktopPanel desktop, String appName) {
        super(desktop, appName);
        ((EmailAnwendung)this.holeAnwendung()).holePOP3Client().hinzuBeobachter(this);
        this.initialisiereKomponenten();
        this.laden();
        this.posteingangAktualisieren();
        this.gesendeteAktualisieren();
    }

    private void initialisiereKomponenten() {
        this.tabbedPane = new JTabbedPane();
        this.gesendetPanel = new JPanel(new BorderLayout());
        this.eingangPanel = new JPanel(new BorderLayout());
        Box gesendetBox = Box.createHorizontalBox();
        gesendetBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Box eingangBox = Box.createHorizontalBox();
        eingangBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Box vorschauBox = Box.createHorizontalBox();
        vorschauBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.posteingangTable = new JExtendedTable((TableModel)this.posteingangModell, false);
        TableColumnModel tcm = this.posteingangTable.getColumnModel();
        tcm.getColumn(0).setHeaderValue(messages.getString("emailanwendung_msg1"));
        tcm.getColumn(1).setHeaderValue(messages.getString("emailanwendung_msg2"));
        this.eingangScroll = new JScrollPane(this.posteingangTable);
        this.posteingangTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                GUIApplicationEmailAnwendungWindow.this.zeilenNummer = GUIApplicationEmailAnwendungWindow.this.posteingangTable.getSelectedRow();
                GUIApplicationEmailAnwendungWindow.this.auswahlfuerloeschen = GUIApplicationEmailAnwendungWindow.this.zeilenNummer;
                GUIApplicationEmailAnwendungWindow.this.paa = ListMode.INBOX;
                if (GUIApplicationEmailAnwendungWindow.this.zeilenNummer != -1) {
                    Email tmpEmail = ((EmailAnwendung)GUIApplicationEmailAnwendungWindow.this.holeAnwendung()).getEmpfangeneNachrichten().get(GUIApplicationEmailAnwendungWindow.this.zeilenNummer);
                    GUIApplicationEmailAnwendungWindow.this.emailVorschau.setContentType("text/plain");
                    GUIApplicationEmailAnwendungWindow.this.emailVorschau.setText(tmpEmail.getText());
                    GUIApplicationEmailAnwendungWindow.this.aktuelleMail = tmpEmail;
                    GUIApplicationEmailAnwendungWindow.this.emailVorschau.updateUI();
                }
            }
        });
        eingangBox.add(this.eingangScroll);
        this.eingangPanel.add((Component)eingangBox, "Center");
        this.gesendeteTable = new JExtendedTable((TableModel)this.gesendeteModell, false);
        TableColumnModel tcmGesendet = this.gesendeteTable.getColumnModel();
        tcmGesendet.getColumn(0).setHeaderValue(messages.getString("emailanwendung_msg3"));
        tcmGesendet.getColumn(1).setHeaderValue(messages.getString("emailanwendung_msg2"));
        this.gesendeteTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                GUIApplicationEmailAnwendungWindow.this.zeilenNummer = GUIApplicationEmailAnwendungWindow.this.gesendeteTable.getSelectedRow();
                GUIApplicationEmailAnwendungWindow.this.auswahlfuerloeschen = GUIApplicationEmailAnwendungWindow.this.zeilenNummer;
                GUIApplicationEmailAnwendungWindow.this.paa = ListMode.OUTBOX;
                if (GUIApplicationEmailAnwendungWindow.this.zeilenNummer != -1) {
                    Email tmpEmail = ((EmailAnwendung)GUIApplicationEmailAnwendungWindow.this.holeAnwendung()).getGesendeteNachrichten().get(GUIApplicationEmailAnwendungWindow.this.zeilenNummer);
                    GUIApplicationEmailAnwendungWindow.this.emailVorschau.setContentType("text/plain");
                    GUIApplicationEmailAnwendungWindow.this.emailVorschau.setText(tmpEmail.getText());
                    GUIApplicationEmailAnwendungWindow.this.aktuelleMail = tmpEmail;
                    GUIApplicationEmailAnwendungWindow.this.emailVorschau.updateUI();
                }
            }
        });
        this.gesendetScroll = new JScrollPane(this.gesendeteTable);
        gesendetBox.add(this.gesendetScroll);
        this.gesendetPanel.add((Component)gesendetBox, "Center");
        this.emailVorschau = new JEditorPane();
        this.emailVorschau.setBackground(new Color(255, 255, 255));
        this.emailVorschau.setContentType("text/html");
        this.emailVorschau.setEditable(false);
        this.emailVorschau.setText("<html><head><base href=\"file:bilder\"></head><body><img src=\"file:" + ResourceUtil.getResourceUrlEncodedPath("img/email_icon.png") + "\" align=\"top\"><font face=arial>" + messages.getString("emailanwendung_msg4") + "!<br /></font></body></html>");
        JScrollPane vorschauScrollPane = new JScrollPane(this.emailVorschau);
        vorschauScrollPane.setPreferredSize(new Dimension(300, 200));
        vorschauBox.add(vorschauScrollPane);
        this.eingangPanel.add((Component)vorschauBox, "South");
        this.tabbedPane.addTab(messages.getString("emailanwendung_msg5"), new ImageIcon(this.getClass().getResource("/gfx/desktop/email_ordner_posteingang.png")), this.eingangPanel);
        this.tabbedPane.addTab(messages.getString("emailanwendung_msg6"), new ImageIcon(this.getClass().getResource("/gfx/desktop/email_ordner_gesendet.png")), this.gesendetPanel);
        this.tabbedPane.setTabPlacement(2);
        Box topBox = Box.createHorizontalBox();
        ImageIcon image = new ImageIcon(this.getClass().getResource("/gfx/desktop/email_emails_abholen.png"));
        this.buttonMailsAbholen = new JButton(image);
        image = new ImageIcon(this.getClass().getResource("/gfx/desktop/email_emails_abholen.gif"));
        this.buttonMailsAbholen.setRolloverIcon(image);
        this.buttonMailsAbholen.setFocusPainted(false);
        this.buttonMailsAbholen.setActionCommand("Abholen");
        this.buttonMailsAbholen.setToolTipText(messages.getString("emailanwendung_msg7"));
        topBox.add(this.buttonMailsAbholen);
        topBox.add(Box.createHorizontalStrut(5));
        image = new ImageIcon(this.getClass().getResource("/gfx/desktop/email_email_verfassen.png"));
        this.buttonMailVerfassen = new JButton(image);
        image = new ImageIcon(this.getClass().getResource("/gfx/desktop/email_email_verfassen.gif"));
        this.buttonMailVerfassen.setRolloverIcon(image);
        this.buttonMailVerfassen.setFocusPainted(false);
        this.buttonMailVerfassen.setActionCommand("Verfassen");
        this.buttonMailVerfassen.setToolTipText(messages.getString("emailanwendung_msg8"));
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (arg0.getActionCommand() == GUIApplicationEmailAnwendungWindow.this.buttonMailVerfassen.getActionCommand()) {
                    GUIApplicationEmailAnwendungWindow.this.emailVerfassen(null);
                }
                if (arg0.getActionCommand() == GUIApplicationEmailAnwendungWindow.this.buttonMailAntworten.getActionCommand()) {
                    GUIApplicationEmailAnwendungWindow.this.emailVerfassen(GUIApplicationEmailAnwendungWindow.this.aktuelleMail);
                }
                if (arg0.getActionCommand() == GUIApplicationEmailAnwendungWindow.this.buttonMailsAbholen.getActionCommand()) {
                    GUIApplicationEmailAnwendungWindow.this.emailsAbholen();
                }
                if (arg0.getActionCommand() == GUIApplicationEmailAnwendungWindow.this.buttonKonten.getActionCommand()) {
                    GUIApplicationEmailAnwendungWindow.this.kontoVerwalten();
                    GUIApplicationEmailAnwendungWindow.this.kontoAktualisieren();
                }
                if (arg0.getActionCommand() == GUIApplicationEmailAnwendungWindow.this.buttonEmailLoeschen.getActionCommand()) {
                    GUIApplicationEmailAnwendungWindow.this.emailLoeschen(GUIApplicationEmailAnwendungWindow.this.auswahlfuerloeschen, GUIApplicationEmailAnwendungWindow.this.paa);
                }
            }
        };
        this.buttonMailVerfassen.addActionListener(al);
        this.buttonMailsAbholen.addActionListener(al);
        topBox.add(this.buttonMailVerfassen);
        topBox.add(Box.createHorizontalStrut(5));
        image = new ImageIcon(this.getClass().getResource("/gfx/desktop/email_email_antworten.png"));
        this.buttonMailAntworten = new JButton(image);
        image = new ImageIcon(this.getClass().getResource("/gfx/desktop/email_email_antworten.gif"));
        this.buttonMailAntworten.setRolloverIcon(image);
        this.buttonMailAntworten.setFocusPainted(false);
        this.buttonMailAntworten.addActionListener(al);
        this.buttonMailAntworten.setActionCommand("antworten");
        this.buttonMailAntworten.setToolTipText(messages.getString("emailanwendung_msg9"));
        topBox.add(this.buttonMailAntworten);
        topBox.add(Box.createHorizontalStrut(5));
        image = new ImageIcon(this.getClass().getResource("/gfx/desktop/icon_emailloeschen.png"));
        this.buttonEmailLoeschen = new JButton(messages.getString("emailanwendung_msg43"));
        this.buttonEmailLoeschen.addActionListener(al);
        this.buttonEmailLoeschen.setActionCommand("loeschen");
        this.buttonEmailLoeschen.setToolTipText(messages.getString("emailanwendung_msg10"));
        topBox.add(this.buttonEmailLoeschen);
        topBox.add(Box.createHorizontalStrut(5));
        this.buttonKonten = new JButton(messages.getString("emailanwendung_msg44"));
        this.buttonKonten.addActionListener(al);
        this.buttonKonten.setActionCommand("konten");
        this.buttonKonten.setToolTipText(messages.getString("emailanwendung_msg11"));
        topBox.add(this.buttonKonten);
        topBox.add(Box.createHorizontalStrut(5));
        topBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)this.tabbedPane, "Center");
        contentPane.add((Component)vorschauBox, "South");
        contentPane.add((Component)topBox, "North");
        this.add((Component)contentPane, "Center");
    }

    public void emailLoeschen(int rowIndex, ListMode list) {
        if (ListMode.INBOX.equals((Object)list)) {
            ((EmailAnwendung)this.holeAnwendung()).removeReceivedMail(this.posteingangTable.getSelectedRow());
            --this.zeilenNummer;
            this.posteingangAktualisieren();
            this.emailVorschau.setText(" ");
            this.emailVorschau.updateUI();
        } else if (ListMode.OUTBOX.equals((Object)list)) {
            ((EmailAnwendung)this.holeAnwendung()).removeSentMail(this.gesendeteTable.getSelectedRow());
            --this.zeilenNummer;
            this.gesendeteAktualisieren();
            this.emailVorschau.setText(" ");
            this.emailVorschau.updateUI();
        } else {
            LOG.debug("============================================GuiAppl. Emailloeschen: Email konnte nicht geloescht werden=======================================");
        }
    }

    private String replyLayout(String text) {
        return "> " + text.replaceAll("\\n", "\n> ");
    }

    private void emailVerfassen(Email antwortAuf) {
        this.verfassenPanel = new JPanel(new BorderLayout());
        Box topBox = Box.createHorizontalBox();
        JButton buttonSenden = new JButton(messages.getString("emailanwendung_msg13"));
        buttonSenden.setActionCommand("senden");
        topBox.add(buttonSenden);
        topBox.add(Box.createHorizontalStrut(5));
        JButton cancelButton = new JButton(messages.getString("emailanwendung_msg37"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GUIApplicationEmailAnwendungWindow.this.desktop.closeModularWindow();
            }
        });
        topBox.add(cancelButton);
        topBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.verfassenPanel.add((Component)topBox, "North");
        this.middleBox = Box.createVerticalBox();
        Box absenderBox = Box.createHorizontalBox();
        Vector<String> kontenVector = new Vector<String>();
        for (EmailKonto konto : ((EmailAnwendung)this.holeAnwendung()).holeKontoListe().values()) {
            kontenVector.addElement(konto.getBenutzername());
        }
        final JComboBox cbAbsender = new JComboBox(kontenVector);
        absenderBox.add(cbAbsender);
        absenderBox.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.middleBox.add(absenderBox);
        Box kleineBox = Box.createHorizontalBox();
        JLabel anLabel = new JLabel(messages.getString("emailanwendung_msg14"));
        anLabel.setPreferredSize(new Dimension(120, 20));
        kleineBox.add(anLabel);
        kleineBox.add(Box.createHorizontalStrut(5));
        final JTextField anField = new JTextField();
        anField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                GUIApplicationEmailAnwendungWindow.this.mailPruefen(anField);
            }
        });
        anField.setBorder(null);
        kleineBox.add(anField);
        this.middleBox.add(kleineBox);
        this.middleBox.add(Box.createVerticalStrut(3));
        kleineBox = Box.createHorizontalBox();
        JLabel ccLabel = new JLabel(messages.getString("emailanwendung_msg15"));
        ccLabel.setPreferredSize(new Dimension(120, 20));
        kleineBox.add(ccLabel);
        kleineBox.add(Box.createHorizontalStrut(5));
        final JTextField ccField = new JTextField();
        ccField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                GUIApplicationEmailAnwendungWindow.this.mailPruefen(ccField);
            }
        });
        ccField.setBorder(null);
        kleineBox.add(ccField);
        this.middleBox.add(kleineBox);
        this.middleBox.add(Box.createVerticalStrut(3));
        kleineBox = Box.createHorizontalBox();
        JLabel bccLabel = new JLabel(messages.getString("emailanwendung_msg16"));
        bccLabel.setPreferredSize(new Dimension(120, 20));
        kleineBox.add(bccLabel);
        kleineBox.add(Box.createHorizontalStrut(5));
        final JTextField bccField = new JTextField();
        bccField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                GUIApplicationEmailAnwendungWindow.this.mailPruefen(bccField);
            }
        });
        bccField.setBorder(null);
        kleineBox.add(bccField);
        this.middleBox.add(kleineBox);
        this.middleBox.add(Box.createVerticalStrut(10));
        kleineBox = Box.createHorizontalBox();
        JLabel betreffLabel = new JLabel(messages.getString("emailanwendung_msg17"));
        betreffLabel.setPreferredSize(new Dimension(120, 20));
        kleineBox.add(betreffLabel);
        kleineBox.add(Box.createHorizontalStrut(5));
        final JTextField betreffszeile = new JTextField();
        betreffszeile.setBorder(null);
        kleineBox.add(betreffszeile);
        this.middleBox.add(kleineBox);
        this.middleBox.add(Box.createVerticalStrut(5));
        final JTextArea inhaltField = new JTextArea();
        inhaltField.setPreferredSize(new Dimension(100, 300));
        this.middleBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane inhaltScrollPane = new JScrollPane(inhaltField);
        inhaltScrollPane.setPreferredSize(new Dimension(500, 150));
        this.middleBox.add(inhaltScrollPane);
        this.verfassenPanel.add(this.middleBox);
        if (antwortAuf != null) {
            betreffszeile.setText(messages.getString("emailanwendung_msg18") + " " + antwortAuf.getBetreff());
            inhaltField.setText("\n\n" + antwortAuf.getAbsender().toString() + " " + messages.getString("emailanwendung_msg19") + "\n" + this.replyLayout(antwortAuf.getText()));
            anField.setText(antwortAuf.getAbsender().toString());
        }
        inhaltField.requestFocus();
        inhaltField.grabFocus();
        inhaltField.setCaretPosition(0);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                boolean eingabeFehler = false;
                Email mail = new Email();
                if (cbAbsender.getSelectedItem() == null) {
                    String msgNoAccountAvailable = messages.getString("emailanwendung_msg47");
                    GUIApplicationEmailAnwendungWindow.this.showMessageDialog(msgNoAccountAvailable);
                } else {
                    String kontoString = cbAbsender.getSelectedItem().toString();
                    EmailKonto versendeKonto = ((EmailAnwendung)GUIApplicationEmailAnwendungWindow.this.holeAnwendung()).holeKontoListe().get(kontoString);
                    mail.setAbsender(versendeKonto.getVorname() + (!versendeKonto.getNachname().isEmpty() ? " " + versendeKonto.getNachname() : "") + " <" + versendeKonto.getEmailAdresse() + ">");
                    if (!GUIApplicationEmailAnwendungWindow.this.mailPruefen(anField)) {
                        eingabeFehler = true;
                    } else {
                        mail.setEmpfaenger(EmailUtils.stringToAddressEntryList(anField.getText()));
                    }
                    if (!GUIApplicationEmailAnwendungWindow.this.mailPruefen(ccField)) {
                        eingabeFehler = true;
                    } else {
                        mail.setCc(EmailUtils.stringToAddressEntryList(ccField.getText()));
                    }
                    if (!GUIApplicationEmailAnwendungWindow.this.mailPruefen(bccField)) {
                        eingabeFehler = true;
                    } else {
                        mail.setBcc(EmailUtils.stringToAddressEntryList(bccField.getText()));
                    }
                    if (eingabeFehler) {
                        GUIApplicationEmailAnwendungWindow.this.showMessageDialog(I18n.messages.getString("emailanwendung_msg20"));
                    } else if (mail.getEmpfaenger().size() == 0 && mail.getCc().size() == 0 && mail.getBcc().size() == 0) {
                        GUIApplicationEmailAnwendungWindow.this.showMessageDialog(I18n.messages.getString("emailanwendung_msg21"));
                    } else {
                        mail.setBetreff(betreffszeile.getText());
                        mail.setText(inhaltField.getText());
                        GUIApplicationEmailAnwendungWindow.this.progressBar = new JProgressBar(0, 100);
                        GUIApplicationEmailAnwendungWindow.this.progressBar.setValue(0);
                        GUIApplicationEmailAnwendungWindow.this.progressBar.setIndeterminate(true);
                        GUIApplicationEmailAnwendungWindow.this.progressBar.setStringPainted(true);
                        GUIApplicationEmailAnwendungWindow.this.middleBox.add(GUIApplicationEmailAnwendungWindow.this.progressBar);
                        GUIApplicationEmailAnwendungWindow.this.middleBox.invalidate();
                        GUIApplicationEmailAnwendungWindow.this.middleBox.validate();
                        GUIApplicationEmailAnwendungWindow.this.progressBar.setString(I18n.messages.getString("emailanwendung_msg22"));
                        ((EmailAnwendung)GUIApplicationEmailAnwendungWindow.this.holeAnwendung()).versendeEmail(versendeKonto.getSmtpserver(), mail, versendeKonto.getEmailAdresse());
                        GUIApplicationEmailAnwendungWindow.this.tabbedPane.setSelectedIndex(1);
                    }
                }
            }
        };
        buttonSenden.addActionListener(al);
        this.desktop.showModularWindow(messages.getString("emailanwendung_msg12"), this.verfassenPanel);
    }

    public void emailsAbholen() {
        if (!((EmailAnwendung)this.holeAnwendung()).holeKontoListe().isEmpty()) {
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setValue(0);
            this.progressBar.setIndeterminate(true);
            this.progressBar.setStringPainted(true);
            this.progressPanel = new JPanel(new BorderLayout());
            this.progressPanel.add((Component)this.progressBar, "Center");
            this.progressPanel.setPreferredSize(new Dimension(500, 40));
            this.desktop.showModularWindow(messages.getString("emailanwendung_msg23"), this.progressPanel);
            for (EmailKonto aktuellesKonto : ((EmailAnwendung)this.holeAnwendung()).holeKontoListe().values()) {
                this.progressBar.setString(messages.getString("emailanwendung_msg24") + aktuellesKonto.getEmailAdresse() + ")");
                ((EmailAnwendung)this.holeAnwendung()).emailsAbholenEmails(aktuellesKonto.getBenutzername(), aktuellesKonto.getPasswort(), aktuellesKonto.getPop3port(), aktuellesKonto.getPop3server());
                this.tabbedPane.setSelectedIndex(0);
            }
        }
    }

    private void posteingangAktualisieren() {
        this.posteingangModell.setRowCount(0);
        List<Email> empfangeneNachrichten = ((EmailAnwendung)this.holeAnwendung()).getEmpfangeneNachrichten();
        for (Email neueMail : empfangeneNachrichten) {
            Vector<String> v = new Vector<String>();
            String absender = neueMail.getAbsender() == null ? "" : (neueMail.getAbsender().getName() == null ? neueMail.getAbsender().getMailAddress() : neueMail.getAbsender().getName());
            v.add(absender);
            v.add(neueMail.getBetreff());
            this.posteingangModell.addRow(v);
        }
    }

    public void gesendeteAktualisieren() {
        this.gesendeteModell.setRowCount(0);
        List<Email> gesendeteNachrichten = ((EmailAnwendung)this.holeAnwendung()).getGesendeteNachrichten();
        for (Email neueMail : gesendeteNachrichten) {
            Vector<String> v = new Vector<String>();
            v.add(neueMail.holeEmpfaengerListe());
            v.add(neueMail.getBetreff());
            this.gesendeteModell.addRow(v);
        }
    }

    private void kontoAktualisieren() {
        Map<String, EmailKonto> kontoListe = ((EmailAnwendung)this.holeAnwendung()).holeKontoListe();
        for (EmailKonto konto : kontoListe.values()) {
            this.tfName.setText(konto.getVorname() + " " + konto.getNachname());
            this.tfEmailAdresse.setText(konto.getEmailAdresse());
            this.tfPOP3Server.setText(konto.getPop3server());
            this.tfPOP3Port.setText(konto.getPop3port());
            this.tfSMTPServer.setText(konto.getSmtpserver());
            this.tfSMTPPort.setText(konto.getSmtpport());
            this.tfBenutzername.setText(konto.getBenutzername());
            this.tfPasswort.setText(konto.getPasswort());
        }
    }

    private void kontoVerwalten() {
        Box vBox = Box.createVerticalBox();
        JLabel label = new JLabel(messages.getString("emailanwendung_msg45"));
        label.setPreferredSize(new Dimension(150, 25));
        this.tfName = new JTextField();
        this.tfName.setPreferredSize(new Dimension(150, 25));
        Box hBox = Box.createHorizontalBox();
        hBox.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        hBox.add(label);
        hBox.add(this.tfName);
        vBox.add(hBox);
        label = new JLabel(messages.getString("emailanwendung_msg26"));
        label.setPreferredSize(new Dimension(150, 25));
        this.tfEmailAdresse = new JTextField();
        this.tfEmailAdresse.setPreferredSize(new Dimension(150, 25));
        this.tfEmailAdresse.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                GUIApplicationEmailAnwendungWindow.this.gueltigkeitPruefen(GUIApplicationEmailAnwendungWindow.this.tfEmailAdresse, EingabenUeberpruefung.musterEmailAdresse);
            }
        });
        hBox = Box.createHorizontalBox();
        hBox.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        hBox.add(label);
        hBox.add(this.tfEmailAdresse);
        vBox.add(hBox);
        label = new JLabel(messages.getString("emailanwendung_msg27"));
        label.setPreferredSize(new Dimension(150, 25));
        this.tfPOP3Server = new JTextField();
        this.tfPOP3Server.setPreferredSize(new Dimension(150, 25));
        hBox = Box.createHorizontalBox();
        hBox.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        hBox.add(label);
        hBox.add(this.tfPOP3Server);
        vBox.add(hBox);
        label = new JLabel(messages.getString("emailanwendung_msg28"));
        label.setPreferredSize(new Dimension(150, 25));
        this.tfPOP3Port = new JTextField();
        this.tfPOP3Port.setPreferredSize(new Dimension(150, 25));
        this.tfPOP3Port.setText("110");
        this.tfPOP3Port.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                GUIApplicationEmailAnwendungWindow.this.gueltigkeitPruefen(GUIApplicationEmailAnwendungWindow.this.tfPOP3Port, EingabenUeberpruefung.musterPort);
            }
        });
        hBox = Box.createHorizontalBox();
        hBox.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        hBox.add(label);
        hBox.add(this.tfPOP3Port);
        vBox.add(hBox);
        label = new JLabel(messages.getString("emailanwendung_msg29"));
        label.setPreferredSize(new Dimension(150, 25));
        this.tfSMTPServer = new JTextField();
        this.tfSMTPServer.setPreferredSize(new Dimension(150, 25));
        hBox = Box.createHorizontalBox();
        hBox.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        hBox.add(label);
        hBox.add(this.tfSMTPServer);
        vBox.add(hBox);
        label = new JLabel(messages.getString("emailanwendung_msg30"));
        label.setPreferredSize(new Dimension(150, 25));
        this.tfSMTPPort = new JTextField();
        this.tfSMTPPort.setPreferredSize(new Dimension(150, 25));
        this.tfSMTPPort.setText("25");
        this.tfSMTPPort.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                GUIApplicationEmailAnwendungWindow.this.gueltigkeitPruefen(GUIApplicationEmailAnwendungWindow.this.tfSMTPPort, EingabenUeberpruefung.musterPort);
            }
        });
        hBox = Box.createHorizontalBox();
        hBox.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        hBox.add(label);
        hBox.add(this.tfSMTPPort);
        vBox.add(hBox);
        label = new JLabel(messages.getString("emailanwendung_msg31"));
        label.setPreferredSize(new Dimension(150, 25));
        this.tfBenutzername = new JTextField();
        this.tfBenutzername.setPreferredSize(new Dimension(150, 25));
        this.tfBenutzername.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                GUIApplicationEmailAnwendungWindow.this.gueltigkeitPruefen(GUIApplicationEmailAnwendungWindow.this.tfBenutzername, EingabenUeberpruefung.musterEmailBenutzername);
            }
        });
        hBox = Box.createHorizontalBox();
        hBox.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        hBox.add(label);
        hBox.add(this.tfBenutzername);
        vBox.add(hBox);
        label = new JLabel(messages.getString("emailanwendung_msg32"));
        label.setPreferredSize(new Dimension(150, 25));
        this.tfPasswort = new JPasswordField();
        this.tfPasswort.setPreferredSize(new Dimension(150, 25));
        hBox = Box.createHorizontalBox();
        hBox.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        hBox.add(label);
        hBox.add(this.tfPasswort);
        vBox.add(hBox);
        hBox = Box.createHorizontalBox();
        JButton button = new JButton(messages.getString("emailanwendung_msg33"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GUIApplicationEmailAnwendungWindow.this.kontoSpeichern()) {
                    GUIApplicationEmailAnwendungWindow.this.desktop.closeModularWindow();
                } else {
                    GUIApplicationEmailAnwendungWindow.this.showMessageDialog(I18n.messages.getString("emailanwendung_msg46"));
                }
            }
        });
        hBox.add(button);
        hBox.add(Box.createHorizontalStrut(5));
        button = new JButton(messages.getString("emailanwendung_msg37"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIApplicationEmailAnwendungWindow.this.desktop.closeModularWindow();
            }
        });
        hBox.add(button);
        vBox.add(Box.createVerticalStrut(10));
        vBox.add(hBox);
        JPanel panel = new JPanel();
        panel.add(vBox);
        JScrollPane scroller = new JScrollPane(panel);
        scroller.setPreferredSize(new Dimension(340, 300));
        this.desktop.showModularWindow(messages.getString("emailanwendung_msg25"), scroller);
    }

    private boolean kontoSpeichern() {
        if (EingabenUeberpruefung.isGueltig(this.tfPOP3Port.getText(), EingabenUeberpruefung.musterPort) && EingabenUeberpruefung.isGueltig(this.tfSMTPPort.getText(), EingabenUeberpruefung.musterPort) && EingabenUeberpruefung.isGueltig(this.tfBenutzername.getText(), EingabenUeberpruefung.musterEmailBenutzername)) {
            EmailKonto konto = new EmailKonto();
            if (this.tfName.getText().trim().equals("")) {
                konto.setVorname("");
                konto.setNachname("");
            } else {
                String[] teilStrings = this.tfName.getText().split(" ");
                if (teilStrings.length == 1) {
                    konto.setVorname(this.tfName.getText().trim());
                } else if (teilStrings.length >= 2) {
                    konto.setNachname(teilStrings[teilStrings.length - 1]);
                    String tmp = "";
                    for (int i = 0; i < teilStrings.length - 1; ++i) {
                        tmp = tmp + teilStrings[i] + " ";
                    }
                    konto.setVorname(tmp.trim());
                }
            }
            konto.setBenutzername(this.tfBenutzername.getText());
            konto.setPasswort(new String(this.tfPasswort.getPassword()));
            konto.setPop3port(this.tfPOP3Port.getText());
            konto.setPop3server(this.tfPOP3Server.getText());
            konto.setSmtpport(this.tfSMTPPort.getText());
            konto.setSmtpserver(this.tfSMTPServer.getText());
            konto.setEmailAdresse(this.tfEmailAdresse.getText());
            ((EmailAnwendung)this.holeAnwendung()).setzeKonto(konto);
            this.speichern();
            return true;
        }
        return false;
    }

    private void speichern() {
        ((EmailAnwendung)this.holeAnwendung()).speichern();
    }

    private void laden() {
        ((EmailAnwendung)this.holeAnwendung()).laden();
    }

    public void gueltigkeitPruefen(JTextField feld, Pattern pruefRegel) {
        if (EingabenUeberpruefung.isGueltig(feld.getText(), pruefRegel)) {
            feld.setForeground(EingabenUeberpruefung.farbeRichtig);
            JTextField temp = new JTextField();
            feld.setBorder(temp.getBorder());
        } else {
            feld.setForeground(EingabenUeberpruefung.farbeFalsch);
            feld.setBorder(BorderFactory.createLineBorder(EingabenUeberpruefung.farbeFalsch, 1));
        }
    }

    private boolean mailPruefen(JTextField feld) {
        boolean fehler = false;
        if (!feld.getText().trim().equals("")) {
            String[] adressen = feld.getText().split(",");
            for (int i = 0; i < adressen.length; ++i) {
                if (EingabenUeberpruefung.isGueltig(adressen[i].trim(), EingabenUeberpruefung.musterEmailAdresse)) continue;
                fehler = true;
            }
        }
        if (!fehler) {
            feld.setForeground(EingabenUeberpruefung.farbeRichtig);
            feld.setBorder(null);
        } else {
            feld.setForeground(EingabenUeberpruefung.farbeFalsch);
            feld.setBorder(BorderFactory.createLineBorder(EingabenUeberpruefung.farbeFalsch, 1));
        }
        return !fehler;
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        this.posteingangAktualisieren();
        this.gesendeteAktualisieren();
        if (arg1 instanceof Exception) {
            this.showMessageDialog(((Exception)arg1).getMessage());
        }
        if (arg1 == null || arg1.equals("") || arg1 instanceof Exception) {
            this.desktop.closeModularWindow(this.progressPanel);
            this.desktop.closeModularWindow(this.verfassenPanel);
        }
    }

    private static enum ListMode {
        INBOX,
        OUTBOX,
        UNKNOWN;

    }
}

