/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.gui.anwendungssicht.GUIApplicationWindow;
import filius.gui.anwendungssicht.GUIDesktopPanel;
import filius.software.clientserver.ClientBaustein;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class GUIApplicationClientBausteinWindow
extends GUIApplicationWindow {
    private static final long serialVersionUID = 1L;
    private JTextArea taAusgabe;
    private JTextField tfServerAdresse;
    private JTextField tfServerPort;
    private JTextArea taSenden;
    private JButton btVerbinden;
    private JButton btSenden;

    public GUIApplicationClientBausteinWindow(GUIDesktopPanel desktop, String appName) {
        super(desktop, appName);
        this.initialisiereKomponenten();
    }

    private void initialisiereKomponenten() {
        Box hauptBox = Box.createVerticalBox();
        hauptBox.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        hauptBox.add(Box.createVerticalStrut(5));
        Box hBox = Box.createHorizontalBox();
        JLabel label = new JLabel(messages.getString("clientbaustein_msg1"));
        label.setPreferredSize(new Dimension(140, label.getHeight()));
        hBox.add(label);
        this.tfServerAdresse = new JTextField();
        this.tfServerAdresse.setPreferredSize(new Dimension(100, 20));
        hBox.add(this.tfServerAdresse);
        hauptBox.add(hBox);
        hauptBox.add(Box.createVerticalStrut(5));
        hBox = Box.createHorizontalBox();
        label = new JLabel(messages.getString("clientbaustein_msg2"));
        label.setPreferredSize(new Dimension(140, label.getHeight()));
        hBox.add(label);
        this.tfServerPort = new JTextField();
        this.tfServerPort.setPreferredSize(new Dimension(100, 20));
        hBox.add(this.tfServerPort);
        hauptBox.add(hBox);
        hauptBox.add(Box.createVerticalStrut(5));
        this.btVerbinden = new JButton(messages.getString("clientbaustein_msg3"));
        this.btVerbinden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("verbinden")) {
                    ((ClientBaustein)GUIApplicationClientBausteinWindow.this.holeAnwendung()).setZielIPAdresse(GUIApplicationClientBausteinWindow.this.tfServerAdresse.getText());
                    ((ClientBaustein)GUIApplicationClientBausteinWindow.this.holeAnwendung()).setZielPort(Integer.parseInt(GUIApplicationClientBausteinWindow.this.tfServerPort.getText()));
                    ((ClientBaustein)GUIApplicationClientBausteinWindow.this.holeAnwendung()).verbinden();
                } else {
                    ((ClientBaustein)GUIApplicationClientBausteinWindow.this.holeAnwendung()).trennen();
                }
                GUIApplicationClientBausteinWindow.this.aktualisieren();
            }
        });
        hauptBox.add(this.btVerbinden);
        hauptBox.add(Box.createVerticalStrut(5));
        label = new JLabel(messages.getString("clientbaustein_msg4"));
        label.setPreferredSize(new Dimension(100, 20));
        hauptBox.add(label);
        this.taSenden = new JTextArea();
        JScrollPane scrollPane = new JScrollPane(this.taSenden);
        scrollPane.setPreferredSize(new Dimension(400, 50));
        hauptBox.add(scrollPane);
        this.btSenden = new JButton(messages.getString("clientbaustein_msg5"));
        this.btSenden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((ClientBaustein)GUIApplicationClientBausteinWindow.this.holeAnwendung()).senden(GUIApplicationClientBausteinWindow.this.taSenden.getText());
                GUIApplicationClientBausteinWindow.this.taSenden.setText("");
            }
        });
        hauptBox.add(this.btSenden);
        hauptBox.add(Box.createVerticalStrut(5));
        this.taAusgabe = new JTextArea();
        this.taAusgabe.setEditable(false);
        scrollPane = new JScrollPane(this.taAusgabe);
        scrollPane.setPreferredSize(new Dimension(400, 200));
        hauptBox.add(scrollPane);
        hauptBox.add(Box.createVerticalStrut(5));
        this.add((Component)hauptBox, "Center");
        this.aktualisieren();
    }

    private void aktualisieren() {
        ClientBaustein client = (ClientBaustein)this.holeAnwendung();
        this.tfServerAdresse.setText(client.getZielIPAdresse());
        this.tfServerPort.setText("" + client.getZielPort());
        if (client.istVerbunden()) {
            this.btVerbinden.setText(messages.getString("clientbaustein_msg6"));
            this.btVerbinden.setActionCommand("trennen");
            this.btSenden.setEnabled(true);
            this.tfServerAdresse.setEditable(false);
            this.tfServerPort.setEditable(false);
        } else {
            this.btVerbinden.setText(messages.getString("clientbaustein_msg3"));
            this.btVerbinden.setActionCommand("verbinden");
            this.btSenden.setEnabled(false);
            this.tfServerAdresse.setEditable(true);
            this.tfServerPort.setEditable(true);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg != null) {
            this.taAusgabe.append(arg.toString() + "\n");
        }
        this.aktualisieren();
    }
}

